/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.controller;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.youtrack.notifications.Localization;
import jetbrains.youtrack.notifications.controller.ContextualTemplateRenderer;
import jetbrains.youtrack.notifications.controller.ProjectBasedNotificationFreemarkerConfiguration;
import jetbrains.youtrack.notifications.controller.TemplatePreviewException;
import jetbrains.youtrack.persistent.XdProject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="previewTemplateRenderer")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J0\u0010\f\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/notifications/controller/NotificationTemplatePreviewRenderer;", "", "()V", "renderer", "Ljetbrains/youtrack/notifications/controller/ContextualTemplateRenderer;", "createTemplate", "Lfreemarker/template/Template;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "id", "", "content", "render", "data", "", "renderSyntaxException", "ioe", "Ljava/io/IOException;", "renderTemplateException", "te", "Lfreemarker/template/TemplateException;", "renderWithErrorProcessing", "verifyContent", "", "Companion", "youtrack-custom-notifications"})
public class NotificationTemplatePreviewRenderer {
    private final ContextualTemplateRenderer renderer = new ContextualTemplateRenderer();
    private static final String TEST_TEMPLATE_ID = "test_template.ftl";
    private static final String TEST_TEMPLATE_PREFIX = "test_template_";
    public static final Companion Companion = new Companion(null);

    public final void verifyContent(@NotNull XdProject project, @Nullable String content2) throws IOException, IllegalArgumentException {
        block3: {
            block2: {
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (content2 == null || !((charSequence = (CharSequence)content2).length() > 0)) break block2;
                charSequence = content2;
                if ((charSequence = (CharSequence)((Object)StringsKt.trim((CharSequence)charSequence)).toString()).length() > 0) break block3;
            }
            throw (Throwable)new IllegalArgumentException((String)Localization.INSTANCE.getCannotLoadEmptyTemplate().invoke());
        }
        this.createTemplate(project, TEST_TEMPLATE_ID, content2);
    }

    @NotNull
    public final String renderWithErrorProcessing(@NotNull XdProject project, @NotNull String id, @NotNull String content2, @NotNull Map<?, ?> data) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        String testId = TEST_TEMPLATE_PREFIX + id;
        try {
            Template testTemplate = this.createTemplate(project, testId, content2);
            return this.renderer.render(testTemplate, data);
        }
        catch (IOException ioe) {
            return StringsKt.replace$default((String)this.renderSyntaxException(ioe), (String)testId, (String)id, (boolean)false, (int)4, null);
        }
        catch (TemplateException te) {
            return StringsKt.replace$default((String)this.renderTemplateException(te), (String)testId, (String)id, (boolean)false, (int)4, null);
        }
    }

    @NotNull
    public final String render(@Nullable XdProject project, @NotNull String id, @NotNull String content2, @NotNull Map<?, ?> data) throws TemplatePreviewException {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        String testId = TEST_TEMPLATE_PREFIX + id;
        try {
            Template testTemplate = this.createTemplate(project, testId, content2);
            return this.renderer.render(testTemplate, data);
        }
        catch (IOException ioe) {
            String message = StringsKt.replace$default((String)this.renderSyntaxException(ioe), (String)testId, (String)id, (boolean)false, (int)4, null);
            throw (Throwable)new TemplatePreviewException("freemarker-syntax-error", message, ioe);
        }
        catch (TemplateException te) {
            String message = StringsKt.replace$default((String)this.renderTemplateException(te), (String)testId, (String)id, (boolean)false, (int)4, null);
            throw (Throwable)new TemplatePreviewException("freemarker-runtime-error", message, te);
        }
    }

    private final String renderSyntaxException(IOException ioe) {
        String string = ioe.getMessage();
        if (string == null || (string = StringsKt.replace$default((String)string, (String)"\n", (String)"<br/>", (boolean)false, (int)4, null)) == null) {
            string = "Empty Syntax Exception";
        }
        return string;
    }

    private final String renderTemplateException(TemplateException te) {
        CharSequence charSequence;
        String instruction = te.getFTLInstructionStack();
        if (instruction != null && (charSequence = (CharSequence)instruction).length() > 0) {
            StringBuilder sb = new StringBuilder(te.getMessage());
            sb.append("<br/>");
            sb.append(StringsKt.replace$default((String)instruction, (String)"\n", (String)"<br/>", (boolean)false, (int)4, null));
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }
        String string = te.getMessage();
        if (string == null) {
            string = "Empty Template Exception";
        }
        return string;
    }

    private final Template createTemplate(XdProject project, String id, String content2) throws IOException {
        Template template2 = new ProjectBasedNotificationFreemarkerConfiguration(project, content2, id).getTemplate(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)template2, (String)"ProjectBasedNotification\u2026tent, id).getTemplate(id)");
        return template2;
    }

    static {
        TEST_TEMPLATE_ID = TEST_TEMPLATE_ID;
        TEST_TEMPLATE_PREFIX = TEST_TEMPLATE_PREFIX;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/notifications/controller/NotificationTemplatePreviewRenderer$Companion;", "Lmu/KLogging;", "()V", "TEST_TEMPLATE_ID", "", "TEST_TEMPLATE_PREFIX", "youtrack-custom-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

