/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.controller;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.youtrack.notifications.controller.ContextualTemplateRenderer;
import jetbrains.youtrack.notifications.controller.NotificationFreemarkerConfigurationProvider;
import jetbrains.youtrack.persistent.XdProject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="templateRenderer")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u001e\u0010\u000e\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\bJ*\u0010\u000e\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/notifications/controller/NotificationTemplateRenderer;", "", "()V", "configurationProvider", "Ljetbrains/youtrack/notifications/controller/NotificationFreemarkerConfigurationProvider;", "contextualRenderer", "Ljetbrains/youtrack/notifications/controller/ContextualTemplateRenderer;", "render", "", "data", "", "templateId", "project", "Ljetbrains/youtrack/persistent/XdProject;", "tryToRender", "youtrack-custom-notifications"})
public class NotificationTemplateRenderer {
    private final ContextualTemplateRenderer contextualRenderer = new ContextualTemplateRenderer();
    @Resource
    private NotificationFreemarkerConfigurationProvider configurationProvider;

    @NotNull
    public final String render(@NotNull Map<?, ?> data, @NotNull String templateId, @Nullable XdProject project) {
        String string;
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)templateId, (String)"templateId");
        try {
            string = this.tryToRender(data, templateId, project);
        }
        catch (Throwable t) {
            String string2 = t.getMessage();
            if (string2 == null) {
                String string3 = t.getClass().getName();
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"t.javaClass.name");
            }
            string = string2;
        }
        return string;
    }

    @NotNull
    public static /* synthetic */ String render$default(NotificationTemplateRenderer notificationTemplateRenderer, Map map2, String string, XdProject xdProject, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: render");
        }
        if ((n & 4) != 0) {
            xdProject = null;
        }
        return notificationTemplateRenderer.render(map2, string, xdProject);
    }

    @NotNull
    public final String tryToRender(@NotNull Map<?, ?> data, @NotNull String templateId) throws TemplateException, IOException, IllegalAccessException {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)templateId, (String)"templateId");
        return this.tryToRender(data, templateId, null);
    }

    private final String tryToRender(Map<?, ?> data, String templateId, XdProject project) throws TemplateException, IOException, IllegalAccessException {
        Template template2;
        NotificationFreemarkerConfigurationProvider notificationFreemarkerConfigurationProvider = this.configurationProvider;
        if (notificationFreemarkerConfigurationProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationProvider");
        }
        Template template3 = template2 = notificationFreemarkerConfigurationProvider.getConfiguration(project).getTemplate(templateId);
        Intrinsics.checkExpressionValueIsNotNull((Object)template3, (String)"template");
        return this.contextualRenderer.render(template3, data);
    }
}

