/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.main.granular;

import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationGroup;
import jetbrains.youtrack.api.notifications.YouTrackNotificationHeader;
import jetbrains.youtrack.notifications.accessData.IssueSnapshotAdapter;
import jetbrains.youtrack.notifications.analyzer.CompositeReason;
import jetbrains.youtrack.notifications.main.EventSearchUtilKt;
import jetbrains.youtrack.notifications.main.granular.GranularNotificationCase;
import jetbrains.youtrack.notifications.plugin.NotificationsXdModelPluginKt;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Deprecated(message="Granular notifications are not maintained")
@Service(value="granularIssueTaggedNotificationCase")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/notifications/main/granular/GranularIssueTaggedNotificationCase;", "Ljetbrains/youtrack/notifications/main/granular/GranularNotificationCase;", "()V", "availableVariables", "", "", "getAvailableVariables", "()Ljava/util/Set;", "header", "Ljetbrains/youtrack/api/notifications/YouTrackNotificationHeader;", "getHeader", "()Ljetbrains/youtrack/api/notifications/YouTrackNotificationHeader;", "parent", "Ljetbrains/youtrack/api/notifications/NotificationGroup;", "getParent", "()Ljetbrains/youtrack/api/notifications/NotificationGroup;", "extendWithTestData", "", "data", "Ljetbrains/youtrack/api/notifications/NotificationData;", "ctxIssue", "Ljetbrains/exodus/entitystore/Entity;", "recipient", "retrieveDataId", "youtrack-custom-notifications"})
public class GranularIssueTaggedNotificationCase
extends GranularNotificationCase {
    @Nullable
    public NotificationGroup getParent() {
        String name$iv = "granularSchemeGroup";
        return (NotificationGroup)ServiceLocator.getBean((String)name$iv);
    }

    @NotNull
    public YouTrackNotificationHeader getHeader() {
        return YouTrackNotificationHeader.ISSUE_TAGGED;
    }

    public void extendWithTestData(@NotNull NotificationData data, @NotNull Entity ctxIssue, @NotNull Entity recipient) {
        NotificationData notificationData;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)ctxIssue, (String)"ctxIssue");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        XdIssue issue = (XdIssue)XdExtensionsKt.toXd((Entity)ctxIssue);
        XdUser to = (XdUser)XdExtensionsKt.toXd((Entity)recipient);
        Event event2 = EventSearchUtilKt.findLastEvent(issue, "tagsCategory");
        if (event2 == null) {
            throw (Throwable)new IllegalArgumentException(BeansKt.getLocalizer().localizedMsg("NotificationTemplates.test.issue_has_no_tags_change", new Object[]{issue.getIdReadable()}));
        }
        Event tagsEvent = event2;
        boolean untag = !QueryOperations.isEmpty((Iterable)tagsEvent.getRemovedLinks());
        Entity tag = QueryOperations.getFirst((Iterable)(untag ? tagsEvent.getRemovedLinks() : tagsEvent.getAddedLinks()));
        IssueSnapshotAdapter issueAdapter = new IssueSnapshotAdapter(issue);
        CompositeReason reason = this.createTestReason(to, issueAdapter);
        NotificationData $receiver = notificationData = data;
        $receiver.set("from", (Object)issue.getReporter());
        $receiver.set("to", (Object)to);
        $receiver.set("issue", (Object)issueAdapter);
        $receiver.set("reason", (Object)reason);
        $receiver.set("init_notification", (Object)(!XdQueryKt.contains((XdQuery)((XdQuery)NotificationsXdModelPluginKt.getNotifiedUsers(issue)), (XdEntity)((XdEntity)to)) ? 1 : 0));
        $receiver.set("tag", (Object)tag);
        $receiver.set("untag", (Object)untag);
    }

    @NotNull
    public Set<String> getAvailableVariables() {
        return SetsKt.setOf((Object[])new String[]{"from", "to", "issue", "tag", "untag", "reason"});
    }

    @Nullable
    public String retrieveDataId(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Object object = data.get("tag");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.Entity");
        }
        return ((Entity)object).toIdString();
    }

    public GranularIssueTaggedNotificationCase() {
        super("tagged_issue", "NotificationTemplates.Tagged_issue_title", "NotificationTemplates.Tagged_issue_description");
    }
}

