/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.merge;

import jetbrains.charisma.main.RuleEngineImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.application.RuleEngine;
import jetbrains.youtrack.api.events.EventMerge;
import jetbrains.youtrack.api.events.EventMergeConsumer;
import jetbrains.youtrack.event.persistent.XdRealEvent;
import jetbrains.youtrack.notifications.analyzer.EventMergeAnalyzer;
import jetbrains.youtrack.notifications.durability.NotificationDurabilityFeatureFlag;
import jetbrains.youtrack.notifications.persistence.XdNotificationDurability;
import jetbrains.youtrack.notifications.sending.NotificationChannelService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0011H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/notifications/merge/NotificationEventMergeConsumer;", "Ljetbrains/charisma/main/RuleEngineImpl;", "Ljetbrains/youtrack/api/events/EventMergeConsumer;", "()V", "eventMergeAnalyzer", "Ljetbrains/youtrack/notifications/analyzer/EventMergeAnalyzer;", "isNotificationsEnabled", "", "()Z", "notificationChannelService", "Ljetbrains/youtrack/notifications/sending/NotificationChannelService;", "notificationDurabilityFeatureFlag", "Ljetbrains/youtrack/notifications/durability/NotificationDurabilityFeatureFlag;", "ruleEngine", "Ljetbrains/youtrack/api/application/RuleEngine;", "isEnabled", "issue", "Ljetbrains/exodus/entitystore/Entity;", "onMerge", "", "merge", "Ljetbrains/youtrack/api/events/EventMerge;", "onMergeStart", "event", "youtrack-custom-notifications"})
public final class NotificationEventMergeConsumer
extends RuleEngineImpl
implements EventMergeConsumer {
    @Autowired
    private RuleEngine ruleEngine;
    @Autowired
    private NotificationDurabilityFeatureFlag notificationDurabilityFeatureFlag;
    @Autowired
    private NotificationChannelService notificationChannelService;
    @Autowired
    private EventMergeAnalyzer eventMergeAnalyzer;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNotificationsEnabled() {
        RuleEngine ruleEngine = this.ruleEngine;
        if (ruleEngine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ruleEngine");
        }
        if (ruleEngine.isIgnoreThread()) return false;
        if (this.isIgnoreThread()) return false;
        NotificationChannelService notificationChannelService = this.notificationChannelService;
        if (notificationChannelService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationChannelService");
        }
        if (!notificationChannelService.hasEnabledChannels()) return false;
        return true;
    }

    public void onMerge(@NotNull EventMerge merge) {
        boolean wasQueuedForAnalysis;
        Intrinsics.checkParameterIsNotNull((Object)merge, (String)"merge");
        EventMergeAnalyzer eventMergeAnalyzer = this.eventMergeAnalyzer;
        if (eventMergeAnalyzer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeAnalyzer");
        }
        if (!(wasQueuedForAnalysis = eventMergeAnalyzer.analyze(merge, true))) {
            NotificationDurabilityFeatureFlag notificationDurabilityFeatureFlag = this.notificationDurabilityFeatureFlag;
            if (notificationDurabilityFeatureFlag == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationDurabilityFeatureFlag");
            }
            if (notificationDurabilityFeatureFlag.isEnabled()) {
                ((XdNotificationDurability)XdNotificationDurability.Companion.get()).releaseMerge(merge);
            }
        }
    }

    public boolean isEnabled(@NotNull Entity issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return this.isNotificationsEnabled();
    }

    public void onMergeStart(@NotNull Entity event2) {
        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
        NotificationDurabilityFeatureFlag notificationDurabilityFeatureFlag = this.notificationDurabilityFeatureFlag;
        if (notificationDurabilityFeatureFlag == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationDurabilityFeatureFlag");
        }
        if (notificationDurabilityFeatureFlag.isEnabled()) {
            ((XdNotificationDurability)XdNotificationDurability.Companion.get()).registerMergeStart((XdRealEvent)XdExtensionsKt.toXd((Entity)event2));
        }
    }
}

