/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.compress;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import jetbrains.exodus.util.IOUtil;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.youtrack.event.compress.DiffWindowEncoder;
import jetbrains.youtrack.event.compress.VcDiffConfig;
import jetbrains.youtrack.event.compress.VcDiffInputStream;
import jetbrains.youtrack.event.compress.VcDiffOutputStream;
import jetbrains.youtrack.event.compress.VlqEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\fJ \u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/event/compress/VcDiff;", "Ljava/io/Closeable;", "config", "Ljetbrains/youtrack/event/compress/VcDiffConfig;", "(Ljetbrains/youtrack/event/compress/VcDiffConfig;)V", "getConfig", "()Ljetbrains/youtrack/event/compress/VcDiffConfig;", "windowEncoder", "Ljetbrains/youtrack/event/compress/DiffWindowEncoder;", "close", "", "decode", "Ljava/io/InputStream;", "previousSource", "delta", "source", "Ljava/io/OutputStream;", "encode", "", "youtrack-events"})
public class VcDiff
implements Closeable {
    private final DiffWindowEncoder windowEncoder;
    @NotNull
    private final VcDiffConfig config;

    public final boolean encode(@NotNull InputStream source, @Nullable InputStream previousSource, @NotNull OutputStream delta) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        int windowSize = this.config.getWindowSize();
        int halfWindowSize = windowSize / 2;
        byte[] sourceWindow = new byte[halfWindowSize];
        int actuallyRead = IOUtil.readFully((InputStream)source, (byte[])sourceWindow);
        if (actuallyRead < 1) {
            return true;
        }
        LightByteArrayOutputStream tempOutput = new LightByteArrayOutputStream();
        this.windowEncoder.encodeDiffWindow(new ByteArrayInputStream(sourceWindow, 0, actuallyRead), previousSource, (OutputStream)tempOutput);
        int tempOutputSize = tempOutput.size();
        if (tempOutputSize * 100 / actuallyRead > this.config.getTargetPercentage()) {
            VlqEncoder.INSTANCE.writeInt(0, delta);
            delta.write(sourceWindow, 0, actuallyRead);
            IOUtil.copyStreams((InputStream)source, (OutputStream)delta, (ByteArraySpinAllocator)IOUtil.BUFFER_ALLOCATOR);
            return false;
        }
        VlqEncoder.INSTANCE.writeInt(windowSize, delta);
        delta.write(tempOutput.toByteArray(), 0, tempOutput.size());
        while (this.windowEncoder.encodeDiffWindow(source, previousSource, delta) > 0) {
        }
        return true;
    }

    @NotNull
    public final OutputStream encode(@Nullable InputStream previousSource, @NotNull OutputStream delta) {
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        return new VcDiffOutputStream(this.config, this.windowEncoder, previousSource, delta);
    }

    public final void decode(@Nullable InputStream previousSource, @NotNull InputStream delta, @NotNull OutputStream source) {
        int windowSize;
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        try {
            windowSize = VlqEncoder.INSTANCE.readInt(delta);
        }
        catch (EOFException e) {
            return;
        }
        if (windowSize == 0) {
            IOUtil.copyStreams((InputStream)delta, (OutputStream)source, (ByteArraySpinAllocator)IOUtil.BUFFER_ALLOCATOR);
            return;
        }
        while (!this.windowEncoder.decodeDiffWindow(previousSource, delta, source)) {
        }
    }

    @NotNull
    public final InputStream decode(@Nullable InputStream previousSource, @NotNull InputStream delta) {
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        return new VcDiffInputStream(this.windowEncoder, previousSource, delta);
    }

    @Override
    public void close() {
        this.windowEncoder.close();
    }

    @NotNull
    public final VcDiffConfig getConfig() {
        return this.config;
    }

    public VcDiff(@NotNull VcDiffConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.windowEncoder = new DiffWindowEncoder(this.config);
    }

    public /* synthetic */ VcDiff(VcDiffConfig vcDiffConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vcDiffConfig = VcDiffConfig.Companion.getDEFAULT();
        }
        this(vcDiffConfig);
    }

    public VcDiff() {
        this(null, 1, null);
    }
}

