/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.webr.ContainerAware;
import jetbrains.youtrack.api.webr.LocalScopedDelegate;
import jetbrains.youtrack.event.management.EventAudit;
import jetbrains.youtrack.event.management.EventRecoveryUtilsKt;
import jetbrains.youtrack.event.merge.MergeMethodsKt;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.event.persistent.XdRealEvent;
import jetbrains.youtrack.event.rollback.BeansKt;
import jetbrains.youtrack.event.rollback.ConversionUtils;
import jetbrains.youtrack.event.rollback.DebugInfoMethodsKt;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.WebLocalScope;

@LocalScoped
@ManagedResource(description="Diagnostic tool for events browsing")
@Component(value="EventAudit")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0007J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0007J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0014\u0010 \u001a\u00020\b*\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\"\u001a\u00020\b*\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010$\u001a\u00020\b*\u00020#H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Ljetbrains/youtrack/event/management/EventAudit;", "Ljetbrains/youtrack/api/webr/ContainerAware;", "()V", "container", "Lwebr/framework/controller/BeanContainer;", "getContainer", "()Lwebr/framework/controller/BeanContainer;", "lastCreatedEventId", "", "getLastCreatedEventId", "()Ljava/lang/String;", "lastCreatedEventId$delegate", "Ljetbrains/youtrack/api/webr/LocalScopedDelegate;", "clearCorruptedEvents", "issueKey", "findIssueHistoryByEvent", "eventLocalId", "", "verbose", "", "findIssueHistoryByIssue", "findIssueMergedHistoryByIssue", "findRealEvents", "from", "till", "markAsCorrupted", "eventId", "markCorruptedEventsBreakingTimestamps", "markCorruptedEventsWithDirectPass", "markCorruptedEventsWithReversePass", "removeCorruptedEvents", "removeRealEventDuplicates", "print", "Ljetbrains/youtrack/api/events/Event;", "printHistory", "Ljetbrains/youtrack/persistent/XdIssue;", "printMergedHistory", "youtrack-events"})
public final class EventAudit
implements ContainerAware {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final BeanContainer container;
    @NotNull
    private final LocalScopedDelegate lastCreatedEventId$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EventAudit.class), "lastCreatedEventId", "getLastCreatedEventId()Ljava/lang/String;"))};
    }

    @NotNull
    public BeanContainer getContainer() {
        return this.container;
    }

    @ManagedAttribute(description="Database id of the last created event")
    @NotNull
    public final String getLastCreatedEventId() {
        return (String)this.lastCreatedEventId$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @ManagedOperation(description="Print events of the issue with history containing the requested event")
    @NotNull
    public final String findIssueHistoryByEvent(long eventLocalId, boolean verbose) {
        return (String)this.transactionalInScope((Function0)new Function0<String>(this, eventLocalId, verbose){
            final /* synthetic */ EventAudit this$0;
            final /* synthetic */ long $eventLocalId;
            final /* synthetic */ boolean $verbose;

            @NotNull
            public final String invoke() {
                int eventTypeId = jetbrains.youtrack.gaprest.BeansKt.getPersistentEntityStore().getEntityTypeId(XdRealEvent.Companion.getEntityType());
                PersistentEntity persistentEntity = jetbrains.youtrack.gaprest.BeansKt.getPersistentEntityStore().getEntity((EntityId)new PersistentEntityId(eventTypeId, this.$eventLocalId));
                TransientStoreSession transientStoreSession = XdExtensionsKt.getSession((TransientEntityStore)((TransientEntityStore)jetbrains.youtrack.gaprest.BeansKt.getTransientEntityStore()));
                PersistentEntity persistentEntity2 = persistentEntity;
                Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntity2, (String)"persistentEntity");
                XdRealEvent xdEvent = (XdRealEvent)XdExtensionsKt.toXd((Entity)((Entity)transientStoreSession.newEntity((Entity)persistentEntity2)));
                return EventAudit.access$printHistory(this.this$0, xdEvent.getIssue(), this.$verbose);
            }
            {
                this.this$0 = eventAudit;
                this.$eventLocalId = l;
                this.$verbose = bl;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Print events of issue")
    @NotNull
    public final String findIssueHistoryByIssue(@NotNull String issueKey, boolean verbose) {
        Intrinsics.checkParameterIsNotNull((Object)issueKey, (String)"issueKey");
        return (String)this.transactionalInScope((Function0)new Function0<String>(this, issueKey, verbose){
            final /* synthetic */ EventAudit this$0;
            final /* synthetic */ String $issueKey;
            final /* synthetic */ boolean $verbose;

            @NotNull
            public final String invoke() {
                Entity entity = IssueImpl.fromId((String)this.$issueKey);
                if (entity == null || (entity = (XdIssue)XdExtensionsKt.toXd((Entity)entity)) == null) {
                    throw (Throwable)new IllegalArgumentException("Issue " + this.$issueKey + " not found");
                }
                Entity xdIssue = entity;
                return EventAudit.access$printHistory(this.this$0, (XdIssue)xdIssue, this.$verbose);
            }
            {
                this.this$0 = eventAudit;
                this.$issueKey = string;
                this.$verbose = bl;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Print merged events of issue")
    @ManagedOperationParameter(name="issueKey", description="Human readable issue key")
    @NotNull
    public final String findIssueMergedHistoryByIssue(@NotNull String issueKey) {
        Intrinsics.checkParameterIsNotNull((Object)issueKey, (String)"issueKey");
        return (String)this.transactionalInScope((Function0)new Function0<String>(this, issueKey){
            final /* synthetic */ EventAudit this$0;
            final /* synthetic */ String $issueKey;

            @NotNull
            public final String invoke() {
                Entity entity = IssueImpl.fromId((String)this.$issueKey);
                if (entity == null || (entity = (XdIssue)XdExtensionsKt.toXd((Entity)entity)) == null) {
                    throw (Throwable)new IllegalArgumentException("Issue " + this.$issueKey + " not found");
                }
                Entity xdIssue = entity;
                return EventAudit.access$printMergedHistory(this.this$0, (XdIssue)xdIssue);
            }
            {
                this.this$0 = eventAudit;
                this.$issueKey = string;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Print events with timestamps in the requested time interval")
    @NotNull
    public final String findRealEvents(long from, long till) {
        return (String)this.transactionalInScope((Function0)new Function0<String>(from, till){
            final /* synthetic */ long $from;
            final /* synthetic */ long $till;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void var3_3;
                void $receiver$iv$iv;
                Map<Entity, List<Event>> $receiver$iv;
                if (this.$from >= this.$till) {
                    throw (Throwable)new IllegalAccessException("from: " + this.$from + " should be less than till: " + this.$till);
                }
                Map<Entity, List<Event>> map = $receiver$iv = ConversionUtils.INSTANCE.getIssueReversedRealEvents(this.$from, this.$till);
                Collection destination$iv$iv = new ArrayList<E>($receiver$iv.size());
                void var4_4 = $receiver$iv$iv;
                Iterator<Map.Entry<K, V>> iterator = var4_4.entrySet().iterator();
                while (iterator.hasNext()) {
                    String string;
                    void it;
                    StringBuilder stringBuilder;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    StringBuilder $receiver = stringBuilder = new StringBuilder();
                    $receiver.append(((XdIssue)XdExtensionsKt.toXd((Entity)((Entity)it.getKey()))).getIdReadable());
                    Collection collection2 = (Collection)it.getValue();
                    if (!collection2.isEmpty()) {
                        $receiver.append("\n");
                    }
                    Iterable $receiver$iv2 = (Iterable)it.getValue();
                    for (T element$iv : $receiver$iv2) {
                        Event event2 = (Event)element$iv;
                        $receiver.append("\t").append(DebugInfoMethodsKt.getDebugInfo(event2));
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
                    collection.add(string);
                }
                return CollectionsKt.joinToString$default((Iterable)((List)var3_3), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
            {
                this.$from = l;
                this.$till = l2;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Remove real event duplicates from the issue history")
    @ManagedOperationParameter(name="issueKey", description="Human readable issue key")
    @NotNull
    public final String removeRealEventDuplicates(@NotNull String issueKey) {
        Intrinsics.checkParameterIsNotNull((Object)issueKey, (String)"issueKey");
        return (String)this.transactionalInScope((Function0)new Function0<String>(issueKey){
            final /* synthetic */ String $issueKey;

            @NotNull
            public final String invoke() {
                Entity entity = IssueImpl.fromId((String)this.$issueKey);
                if (entity == null || (entity = (XdIssue)XdExtensionsKt.toXd((Entity)entity)) == null) {
                    throw (Throwable)new IllegalArgumentException("Issue " + this.$issueKey + " not found");
                }
                Entity xdIssue = entity;
                return CollectionsKt.joinToString$default((Iterable)EventRecoveryUtilsKt.removeRealEventDuplicates((XdIssue)xdIssue), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
            {
                this.$issueKey = string;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Mark event as corrupted")
    @ManagedOperationParameter(name="eventId", description="Database event id")
    @NotNull
    public final String markAsCorrupted(@NotNull String eventId) {
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        return (String)this.transactionalInScope((Function0)new Function0<String>(eventId){
            final /* synthetic */ String $eventId;

            @NotNull
            public final String invoke() {
                String string;
                EntityId entityId = XdExtensionsKt.getSession((TransientEntityStore)((TransientEntityStore)jetbrains.youtrack.gaprest.BeansKt.getTransientEntityStore())).toEntityId(this.$eventId);
                Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"transientEntityStore.session.toEntityId(eventId)");
                EntityId entityId2 = entityId;
                try {
                    PersistentEntity entity = jetbrains.youtrack.gaprest.BeansKt.getPersistentEntityStore().getEntity(entityId2);
                    TransientStoreSession transientStoreSession = XdExtensionsKt.getSession((TransientEntityStore)((TransientEntityStore)jetbrains.youtrack.gaprest.BeansKt.getTransientEntityStore()));
                    PersistentEntity persistentEntity = entity;
                    Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntity, (String)"entity");
                    XdAbstractEvent xdEvent = (XdAbstractEvent)XdExtensionsKt.toXd((Entity)((Entity)transientStoreSession.newEntity((Entity)persistentEntity)));
                    xdEvent.setCorrupted(true);
                    string = DebugInfoMethodsKt.getEventDebugInfo(xdEvent);
                }
                catch (Throwable t) {
                    string = "Error: " + t.getMessage();
                }
                return string;
            }
            {
                this.$eventId = string;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Mark events as corrupted if they violate history unwind with direct pass")
    @ManagedOperationParameter(name="issueKey", description="Human readable issue key")
    @NotNull
    public final String markCorruptedEventsWithDirectPass(@NotNull String issueKey) {
        Intrinsics.checkParameterIsNotNull((Object)issueKey, (String)"issueKey");
        return (String)this.transactionalInScope((Function0)new Function0<String>(issueKey){
            final /* synthetic */ String $issueKey;

            @NotNull
            public final String invoke() {
                Entity entity = IssueImpl.fromId((String)this.$issueKey);
                if (entity == null || (entity = (XdIssue)XdExtensionsKt.toXd((Entity)entity)) == null) {
                    throw (Throwable)new IllegalArgumentException("Issue " + this.$issueKey + " not found");
                }
                Entity xdIssue = entity;
                return SequencesKt.joinToString$default(EventRecoveryUtilsKt.markCorruptedEventsBreakingHistoryConsistencyByDirectPass((XdIssue)xdIssue), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
            {
                this.$issueKey = string;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Mark events as corrupted if they violate history unwind with reverse pass")
    @ManagedOperationParameter(name="issueKey", description="Human readable issue key")
    @NotNull
    public final String markCorruptedEventsWithReversePass(@NotNull String issueKey) {
        Intrinsics.checkParameterIsNotNull((Object)issueKey, (String)"issueKey");
        return (String)this.transactionalInScope((Function0)new Function0<String>(issueKey){
            final /* synthetic */ String $issueKey;

            @NotNull
            public final String invoke() {
                Entity entity = IssueImpl.fromId((String)this.$issueKey);
                if (entity == null || (entity = (XdIssue)XdExtensionsKt.toXd((Entity)entity)) == null) {
                    throw (Throwable)new IllegalArgumentException("Issue " + this.$issueKey + " not found");
                }
                Entity xdIssue = entity;
                return SequencesKt.joinToString$default(EventRecoveryUtilsKt.markCorruptedEventsBreakingHistoryConsistencyByReversePass((XdIssue)xdIssue), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
            {
                this.$issueKey = string;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Mark events as corrupted if they have inverted timestamps")
    @ManagedOperationParameter(name="issueKey", description="Human readable issue key")
    @NotNull
    public final String markCorruptedEventsBreakingTimestamps(@NotNull String issueKey) {
        Intrinsics.checkParameterIsNotNull((Object)issueKey, (String)"issueKey");
        return (String)this.transactionalInScope((Function0)new Function0<String>(issueKey){
            final /* synthetic */ String $issueKey;

            @NotNull
            public final String invoke() {
                Entity entity = IssueImpl.fromId((String)this.$issueKey);
                if (entity == null || (entity = (XdIssue)XdExtensionsKt.toXd((Entity)entity)) == null) {
                    throw (Throwable)new IllegalArgumentException("Issue " + this.$issueKey + " not found");
                }
                Entity xdIssue = entity;
                return SequencesKt.joinToString$default(EventRecoveryUtilsKt.markCorruptedEventsBreakingTimestampOrder((XdIssue)xdIssue), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
            {
                this.$issueKey = string;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Clear corruption marks from events")
    @ManagedOperationParameter(name="issueKey", description="Human readable issue key")
    @NotNull
    public final String clearCorruptedEvents(@NotNull String issueKey) {
        Intrinsics.checkParameterIsNotNull((Object)issueKey, (String)"issueKey");
        return (String)this.transactionalInScope((Function0)new Function0<String>(issueKey){
            final /* synthetic */ String $issueKey;

            @NotNull
            public final String invoke() {
                Entity entity = IssueImpl.fromId((String)this.$issueKey);
                if (entity == null || (entity = (XdIssue)XdExtensionsKt.toXd((Entity)entity)) == null) {
                    throw (Throwable)new IllegalArgumentException("Issue " + this.$issueKey + " not found");
                }
                Entity xdIssue = entity;
                return SequencesKt.joinToString$default(EventRecoveryUtilsKt.clearCorruptedEvents((XdIssue)xdIssue), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
            {
                this.$issueKey = string;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Removed corrupted events")
    @ManagedOperationParameter(name="issueKey", description="Human readable issue key")
    @NotNull
    public final String removeCorruptedEvents(@NotNull String issueKey) {
        Intrinsics.checkParameterIsNotNull((Object)issueKey, (String)"issueKey");
        return (String)this.transactionalInScope((Function0)new Function0<String>(issueKey){
            final /* synthetic */ String $issueKey;

            @NotNull
            public final String invoke() {
                Entity entity = IssueImpl.fromId((String)this.$issueKey);
                if (entity == null || (entity = (XdIssue)XdExtensionsKt.toXd((Entity)entity)) == null) {
                    throw (Throwable)new IllegalArgumentException("Issue " + this.$issueKey + " not found");
                }
                Entity xdIssue = entity;
                return CollectionsKt.joinToString$default((Iterable)EventRecoveryUtilsKt.removeCorruptedEvents((XdIssue)xdIssue), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
            {
                this.$issueKey = string;
                super(0);
            }
        });
    }

    private final String printHistory(@NotNull XdIssue $receiver, boolean verbose) {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.asIterable(BeansKt.getEventRollbackService().reconstructInMemoryReversedEvents($receiver))), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Event, String>(this, verbose){
            final /* synthetic */ EventAudit this$0;
            final /* synthetic */ boolean $verbose;

            @NotNull
            public final String invoke(@NotNull Event it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return EventAudit.access$print(this.this$0, it, this.$verbose);
            }
            {
                this.this$0 = eventAudit;
                this.$verbose = bl;
                super(1);
            }
        }), (int)30, null);
    }

    private final String print(@NotNull Event $receiver, boolean verbose) {
        StringBuilder stringBuilder;
        StringBuilder $receiver2 = stringBuilder = new StringBuilder();
        $receiver2.append(DebugInfoMethodsKt.getDebugInfo($receiver));
        if (verbose) {
            $receiver2.append(CollectionsKt.joinToString$default(DebugInfoMethodsKt.getDeltaDescriptions($receiver), (CharSequence)"\n\t", (CharSequence)"\n\t", null, (int)0, null, null, (int)60, null));
            $receiver2.append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String printMergedHistory(@NotNull XdIssue $receiver) {
        return SequencesKt.joinToString$default(MergeMethodsKt.getDirectEventMerges($receiver), (CharSequence)"\n", null, null, (int)0, null, (Function1)printMergedHistory.1.INSTANCE, (int)30, null);
    }

    public EventAudit() {
        BeanContainer beanContainer = WebLocalScope.getContainer();
        Intrinsics.checkExpressionValueIsNotNull((Object)beanContainer, (String)"WebLocalScope.getContainer()");
        this.container = beanContainer;
        this.lastCreatedEventId$delegate = new LocalScopedDelegate((Function0)lastCreatedEventId.2.INSTANCE);
    }

    public <T> T transactionalInScope(@NotNull Function0<? extends T> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        return (T)ContainerAware.DefaultImpls.transactionalInScope((ContainerAware)this, action);
    }

    @NotNull
    public static final /* synthetic */ String access$printHistory(EventAudit $this, @NotNull XdIssue $receiver, boolean verbose) {
        return $this.printHistory($receiver, verbose);
    }

    @NotNull
    public static final /* synthetic */ String access$printMergedHistory(EventAudit $this, @NotNull XdIssue $receiver) {
        return $this.printMergedHistory($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$print(EventAudit $this, @NotNull Event $receiver, boolean verbose) {
        return $this.print($receiver, verbose);
    }
}

