/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.renderer;

import javax.annotation.PostConstruct;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventCategory;
import jetbrains.youtrack.event.category.legacy.LegacyCustomFieldCategory;
import jetbrains.youtrack.event.renderer.TitleBodyEventRenderer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J0\u0010\u000e\u001a\u00020\f*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J0\u0010\u0016\u001a\u00020\f*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/event/renderer/LegacyEventRenderer;", "Ljetbrains/youtrack/event/renderer/TitleBodyEventRenderer;", "()V", "legacyCustomFieldCategory", "Ljetbrains/youtrack/api/events/EventCategory;", "body", "", "e", "Ljetbrains/youtrack/api/events/Event;", "guard", "", "setup", "", "title", "appendMultipleValuePresentation", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "event", "removed", "category", "Ljetbrains/youtrack/event/category/legacy/LegacyCustomFieldCategory;", "nulValue", "appendSingleValuePresentation", "youtrack-events"})
public final class LegacyEventRenderer
extends TitleBodyEventRenderer {
    @Autowired
    private EventCategory legacyCustomFieldCategory;

    @PostConstruct
    public final void setup() {
        EventCategory eventCategory = this.legacyCustomFieldCategory;
        if (eventCategory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"legacyCustomFieldCategory");
        }
        this.setCategory(eventCategory);
    }

    @Override
    @NotNull
    protected String title(@NotNull Event e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        EventCategory eventCategory = this.getCategory();
        if (eventCategory == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.event.category.legacy.LegacyCustomFieldCategory");
        }
        return ((LegacyCustomFieldCategory)eventCategory).getTitle(e);
    }

    @Override
    @NotNull
    protected String body(@NotNull Event e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        StringBuilder builder = new StringBuilder();
        EventCategory eventCategory = this.getCategory();
        if (eventCategory == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.event.category.legacy.LegacyCustomFieldCategory");
        }
        LegacyCustomFieldCategory cat = (LegacyCustomFieldCategory)eventCategory;
        String nullVal = cat.getNullValuePresentation(e);
        if (cat.isMultiple(e)) {
            this.appendMultipleValuePresentation(builder, e, true, cat, nullVal);
            this.appendMultipleValuePresentation(builder, e, false, cat, nullVal);
        } else {
            this.appendSingleValuePresentation(builder, e, true, cat, nullVal);
            this.appendSingleValuePresentation(builder, e, false, cat, nullVal);
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    private final void appendMultipleValuePresentation(@NotNull StringBuilder $receiver, Event event2, boolean removed, LegacyCustomFieldCategory category, String nulValue) {
        String style = removed ? "removed-value" : "added-value";
        Iterable iterable = removed ? event2.getRemovedLinks() : event2.getAddedLinks();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"if (removed) event.remov\u2026nks else event.addedLinks");
        Iterable entities = iterable;
        boolean first = true;
        for (Entity entity : entities) {
            String value = category.getValuePresentation(event2, entity, nulValue);
            TitleBodyEventRenderer.appendBuilder($receiver, style, value, first, true);
            first = false;
        }
    }

    private final void appendSingleValuePresentation(@NotNull StringBuilder $receiver, Event event2, boolean removed, LegacyCustomFieldCategory category, String nulValue) {
        Entity entity;
        if (removed) {
            Iterable iterable = event2.getRemovedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"event.removedLinks");
            entity = (Entity)CollectionsKt.firstOrNull((Iterable)iterable);
        } else {
            Iterable iterable = event2.getAddedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"event.addedLinks");
            entity = (Entity)CollectionsKt.firstOrNull((Iterable)iterable);
        }
        Entity entity2 = entity;
        boolean first = removed;
        String value = category.getValuePresentation(event2, entity2, nulValue);
        TitleBodyEventRenderer.appendBuilder($receiver, "", value, first, false);
    }

    @Override
    public boolean guard(@NotNull Event e) {
        String newValue;
        String oldValue;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (!super.guard(e)) {
            return false;
        }
        EventCategory eventCategory = this.getCategory();
        if (eventCategory == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.event.category.legacy.LegacyCustomFieldCategory");
        }
        LegacyCustomFieldCategory cat = (LegacyCustomFieldCategory)eventCategory;
        if (cat.isMultiple(e)) {
            Iterable iterable = e.getRemovedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"e.removedLinks");
            oldValue = CollectionsKt.joinToString$default((Iterable)iterable, null, null, null, (int)0, null, (Function1)((Function1)new Function1<Entity, String>(cat, e){
                final /* synthetic */ LegacyCustomFieldCategory $cat;
                final /* synthetic */ Event $e;

                @NotNull
                public final String invoke(Entity it) {
                    return this.$cat.getValuePresentation(this.$e, it, "#0");
                }
                {
                    this.$cat = legacyCustomFieldCategory;
                    this.$e = event2;
                    super(1);
                }
            }), (int)31, null);
            Iterable iterable2 = e.getAddedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"e.addedLinks");
            newValue = CollectionsKt.joinToString$default((Iterable)iterable2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<Entity, String>(cat, e){
                final /* synthetic */ LegacyCustomFieldCategory $cat;
                final /* synthetic */ Event $e;

                @NotNull
                public final String invoke(Entity it) {
                    return this.$cat.getValuePresentation(this.$e, it, "#0");
                }
                {
                    this.$cat = legacyCustomFieldCategory;
                    this.$e = event2;
                    super(1);
                }
            }), (int)31, null);
        } else {
            Iterable iterable = e.getRemovedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"e.removedLinks");
            oldValue = cat.getValuePresentation(e, (Entity)CollectionsKt.firstOrNull((Iterable)iterable), "#0");
            Iterable iterable3 = e.getAddedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable3, (String)"e.addedLinks");
            newValue = cat.getValuePresentation(e, (Entity)CollectionsKt.firstOrNull((Iterable)iterable3), "#0");
        }
        return Intrinsics.areEqual((Object)oldValue, (Object)newValue) ^ true;
    }
}

