/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.rollback;

import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.Iterator;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityStore;
import jetbrains.exodus.query.metadata.AssociationEndCardinality;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.youtrack.event.persistent.EventQueryKt;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.event.persistent.XdEventType;
import jetbrains.youtrack.event.rollback.DebugInfoMethodsKt;
import jetbrains.youtrack.event.rollback.RollbackMethodsKt;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueComment;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00001\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004*\u0001\u0001\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\n\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010\r\u001a\u00020\n\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\u00a8\u0006\u0014"}, d2={"logging", "jetbrains/youtrack/event/rollback/RollbackMethodsKt$logging$1", "Ljetbrains/youtrack/event/rollback/RollbackMethodsKt$logging$1;", "revert", "", "event", "Ljetbrains/youtrack/event/persistent/XdAbstractEvent;", "type", "Ljetbrains/youtrack/event/persistent/XdEventType;", "target", "Ljetbrains/exodus/entitystore/Entity;", "revertToStateAfter", "Ljetbrains/youtrack/persistent/XdIssue;", "stopEvent", "revertToStateAfterTime", "timestamp", "", "revertToStateBefore", "revertToStateBeforeTime", "rollback", "youtrack-events"})
public final class RollbackMethodsKt {
    private static final logging.1 logging = new KLogging(){};

    @Nullable
    public static final XdIssue revertToStateAfterTime(@NotNull XdIssue $receiver, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        XdQuery events2 = EventQueryKt.getEventsReversed$default($receiver, null, 1, null);
        XdIssue result = $receiver;
        Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)events2);
        for (Object element$iv : $receiver$iv) {
            XdAbstractEvent event2 = (XdAbstractEvent)((Object)element$iv);
            if (result == null || event2.getTimestamp() <= timestamp) continue;
            result = RollbackMethodsKt.rollback($receiver, event2);
        }
        return result;
    }

    @Nullable
    public static final XdIssue revertToStateBeforeTime(@NotNull XdIssue $receiver, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        XdQuery events2 = EventQueryKt.getEventsReversed$default($receiver, null, 1, null);
        XdIssue result = $receiver;
        for (XdAbstractEvent event2 : XdQueryKt.asSequence((XdQuery)events2)) {
            if (result == null || event2.getTimestamp() < timestamp) break;
            result = RollbackMethodsKt.rollback($receiver, event2);
        }
        return result;
    }

    @NotNull
    public static final XdIssue revertToStateAfter(@NotNull XdIssue $receiver, @NotNull Entity stopEvent) {
        XdAbstractEvent event2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)stopEvent, (String)"stopEvent");
        XdQuery events2 = EventQueryKt.getEventsReversed$default($receiver, null, 1, null);
        EntityId entityId = stopEvent.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"stopEvent.id");
        EntityId stopId = entityId;
        Iterator iterator = XdQueryKt.asSequence((XdQuery)events2).iterator();
        while (iterator.hasNext() && !Intrinsics.areEqual((Object)(event2 = (XdAbstractEvent)((Object)iterator.next())).getEntityId(), (Object)stopId)) {
            RollbackMethodsKt.rollback($receiver, event2);
        }
        return $receiver;
    }

    @Nullable
    public static final XdIssue revertToStateBefore(@NotNull XdIssue $receiver, @NotNull Entity stopEvent) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)stopEvent, (String)"stopEvent");
        XdAbstractEvent xdEvent = (XdAbstractEvent)XdExtensionsKt.toXd((Entity)stopEvent);
        if (Intrinsics.areEqual((Object)xdEvent.getTarget(), (Object)$receiver.getEntity()) && Intrinsics.areEqual((Object)((Object)xdEvent.getType()), (Object)((Object)XdEventType.Companion.getADD()))) {
            return null;
        }
        RollbackMethodsKt.revertToStateAfter($receiver, stopEvent);
        RollbackMethodsKt.rollback($receiver, xdEvent);
        return $receiver;
    }

    @Nullable
    public static final XdIssue rollback(@NotNull XdIssue $receiver, @NotNull XdAbstractEvent event2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)event2), (String)"event");
        XdEventType type = event2.getType();
        if (Intrinsics.areEqual((Object)((Object)type), (Object)((Object)XdEventType.Companion.getMODIFY_LINK())) || Intrinsics.areEqual((Object)((Object)type), (Object)((Object)XdEventType.Companion.getMODIFY_PROPERTY()))) {
            RollbackMethodsKt.revert(event2, type, event2.getTarget());
        } else if (Intrinsics.areEqual((Object)((Object)type), (Object)((Object)XdEventType.Companion.getADD())) || Intrinsics.areEqual((Object)((Object)type), (Object)((Object)XdEventType.Companion.getREMOVE()))) {
            XdEntity xdTarget = XdExtensionsKt.toXd((Entity)event2.getTarget());
            XdEntity xdEntity = xdTarget;
            if (xdEntity instanceof XdIssue) {
                return null;
            }
            if (xdEntity instanceof XdIssueComment) {
                ((XdIssueComment)xdTarget).setDeleted(Intrinsics.areEqual((Object)((Object)type), (Object)((Object)XdEventType.Companion.getADD())));
            } else if (xdEntity instanceof XdIssueAttachment) {
                ((XdIssueAttachment)xdTarget).setRemoved(Intrinsics.areEqual((Object)((Object)type), (Object)((Object)XdEventType.Companion.getADD())));
            }
        }
        return $receiver;
    }

    private static final void revert(XdAbstractEvent event2, XdEventType type, Entity target) {
        if (Intrinsics.areEqual((Object)((Object)type), (Object)((Object)XdEventType.Companion.getMODIFY_LINK())) ^ true && Intrinsics.areEqual((Object)((Object)type), (Object)((Object)XdEventType.Companion.getMODIFY_PROPERTY())) ^ true) {
            throw (Throwable)new IllegalArgumentException("Can not revert event " + DebugInfoMethodsKt.getEventDebugInfo(event2) + ": incompatible type");
        }
        String string = event2.getMemberName();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("Can not revert event " + DebugInfoMethodsKt.getEventDebugInfo(event2) + ": empty member name");
        }
        String memberName = string;
        if (event2.isPropertyChange()) {
            if (target.getBlobNames().contains(memberName)) {
                Comparable<?> oldValue = event2.getOldPropertyValue((Comparable)((Object)target.getBlobString(memberName)));
                PrimitiveAssociationSemantics.setBlob((Entity)target, (String)memberName, (String)((String)((Object)oldValue)));
            } else {
                Comparable<?> oldValue = event2.getOldPropertyValue(target.getProperty(memberName));
                PrimitiveAssociationSemantics.set((Entity)target, (String)memberName, oldValue);
            }
        } else {
            EntityStore entityStore = target.getStore();
            if (entityStore == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntityStore");
            }
            ModelMetaData modelMetaData = ((TransientEntityStore)entityStore).getModelMetaData();
            if (modelMetaData == null || (modelMetaData = modelMetaData.getEntityMetaData(target.getType())) == null || (modelMetaData = modelMetaData.getAssociationEndMetaData(memberName)) == null) {
                logging.getLogger().warn((Function0)new Function0<String>(target, memberName){
                    final /* synthetic */ Entity $target$inlined;
                    final /* synthetic */ String $memberName$inlined;
                    {
                        this.$target$inlined = entity;
                        this.$memberName$inlined = string;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Trying to revert " + this.$target$inlined.getType() + " link: " + this.$memberName$inlined;
                    }
                });
                return;
            }
            ModelMetaData associationEndMetaData = modelMetaData;
            AssociationEndCardinality associationEndCardinality = associationEndMetaData.getCardinality();
            Intrinsics.checkExpressionValueIsNotNull((Object)associationEndCardinality, (String)"associationEndMetaData.cardinality");
            AssociationEndCardinality cardinality = associationEndCardinality;
            for (Entity addedEntity : event2.getAddedLinks()) {
                if (cardinality.isMultiple()) {
                    DirectedAssociationSemantics.removeToMany((Entity)target, (String)memberName, (Entity)addedEntity);
                    continue;
                }
                DirectedAssociationSemantics.setToOne((Entity)target, (String)memberName, null);
            }
            for (Entity removedEntity : event2.getRemovedLinks()) {
                if (cardinality.isMultiple()) {
                    DirectedAssociationSemantics.createToMany((Entity)target, (String)memberName, (Entity)removedEntity);
                    continue;
                }
                DirectedAssociationSemantics.setToOne((Entity)target, (String)memberName, (Entity)removedEntity);
            }
        }
    }
}

