/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.rollback.snapshot;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.event.persistent.AbstractChangeHandler;
import jetbrains.youtrack.event.persistent.BeansKt;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.event.persistent.XdEventType;
import jetbrains.youtrack.event.rollback.BlobSnapshot;
import jetbrains.youtrack.event.rollback.CorruptedEvent;
import jetbrains.youtrack.event.rollback.LinkSnapshot;
import jetbrains.youtrack.event.rollback.PropSnapshot;
import jetbrains.youtrack.event.rollback.Snapshot;
import jetbrains.youtrack.event.rollback.snapshot.EntityExistenceSnapshot;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/event/rollback/snapshot/EntitySnapshot;", "Ljetbrains/youtrack/event/rollback/Snapshot;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "componentSnapshots", "", "", "getEntity", "()Ljetbrains/exodus/entitystore/Entity;", "existenceSnapshot", "Ljetbrains/youtrack/event/rollback/snapshot/EntityExistenceSnapshot;", "getExistenceSnapshot", "()Ljetbrains/youtrack/event/rollback/snapshot/EntityExistenceSnapshot;", "setExistenceSnapshot", "(Ljetbrains/youtrack/event/rollback/snapshot/EntityExistenceSnapshot;)V", "secondaryEntitiesSnapshots", "rollback", "Ljetbrains/youtrack/api/events/Event;", "event", "Ljetbrains/youtrack/event/persistent/XdAbstractEvent;", "youtrack-events"})
public final class EntitySnapshot
implements Snapshot {
    @NotNull
    private EntityExistenceSnapshot existenceSnapshot;
    private final Map<String, Snapshot> componentSnapshots;
    private final Map<Entity, Snapshot> secondaryEntitiesSnapshots;
    @NotNull
    private final Entity entity;

    @NotNull
    public final EntityExistenceSnapshot getExistenceSnapshot() {
        return this.existenceSnapshot;
    }

    public final void setExistenceSnapshot(@NotNull EntityExistenceSnapshot entityExistenceSnapshot) {
        Intrinsics.checkParameterIsNotNull((Object)entityExistenceSnapshot, (String)"<set-?>");
        this.existenceSnapshot = entityExistenceSnapshot;
    }

    @Override
    @NotNull
    public Event rollback(@NotNull XdAbstractEvent event2) {
        Snapshot snapshot;
        Snapshot snapshot2;
        Snapshot snapshot3;
        Object answer$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)event2), (String)"event");
        Entity target = event2.getTarget();
        if (Intrinsics.areEqual((Object)target, (Object)this.entity) ^ true) {
            Snapshot snapshot4;
            Map<Entity, Snapshot> $receiver$iv = this.secondaryEntitiesSnapshots;
            Snapshot value$iv = $receiver$iv.get(target);
            if (value$iv == null) {
                answer$iv = new EntitySnapshot(target);
                $receiver$iv.put(target, (Snapshot)answer$iv);
                snapshot4 = answer$iv;
            } else {
                snapshot4 = value$iv;
            }
            snapshot3 = snapshot4;
        } else {
            String key$iv;
            Map<String, Snapshot> $receiver$iv;
            Object value$iv;
            String memberName = event2.getMemberName();
            XdEventType xdEventType = event2.getType();
            if (Intrinsics.areEqual((Object)((Object)xdEventType), (Object)((Object)XdEventType.Companion.getADD())) || Intrinsics.areEqual((Object)((Object)xdEventType), (Object)((Object)XdEventType.Companion.getREMOVE()))) {
                snapshot3 = this.existenceSnapshot;
            } else if (Intrinsics.areEqual((Object)((Object)xdEventType), (Object)((Object)XdEventType.Companion.getMODIFY_PROPERTY()))) {
                Object object;
                answer$iv = this.componentSnapshots;
                String string = memberName;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((value$iv = $receiver$iv.get(key$iv = string)) == null) {
                    PropSnapshot propSnapshot;
                    PropSnapshot $receiver = propSnapshot = new PropSnapshot(target, memberName);
                    $receiver.setValue(null);
                    PropSnapshot answer$iv2 = propSnapshot;
                    $receiver$iv.put(key$iv, answer$iv2);
                    object = answer$iv2;
                } else {
                    object = value$iv;
                }
                snapshot3 = (Snapshot)object;
            } else if (Intrinsics.areEqual((Object)((Object)xdEventType), (Object)((Object)XdEventType.Companion.getMODIFY_LINK()))) {
                Object object;
                $receiver$iv = this.componentSnapshots;
                String string = memberName;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((value$iv = $receiver$iv.get(key$iv = string)) == null) {
                    LinkSnapshot answer$iv3 = new LinkSnapshot(target, memberName);
                    $receiver$iv.put(key$iv, answer$iv3);
                    object = answer$iv3;
                } else {
                    object = value$iv;
                }
                snapshot3 = (Snapshot)object;
            } else {
                snapshot3 = null;
            }
        }
        if ((snapshot2 = (snapshot = snapshot3)) == null || (snapshot2 = snapshot2.rollback(event2)) == null) {
            snapshot2 = new CorruptedEvent(event2);
        }
        return snapshot2;
    }

    @NotNull
    public final Entity getEntity() {
        return this.entity;
    }

    public EntitySnapshot(@NotNull Entity entity) {
        Snapshot snapshot;
        String string;
        Map<String, Snapshot> map;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.entity = entity;
        this.existenceSnapshot = new EntityExistenceSnapshot();
        this.componentSnapshots = new HashMap();
        this.secondaryEntitiesSnapshots = new HashMap();
        AbstractChangeHandler<?> abstractChangeHandler = BeansKt.changeHandler(this.entity);
        if (abstractChangeHandler == null) {
            throw (Throwable)new IllegalStateException("can't find change handler for " + this.entity.getType());
        }
        AbstractChangeHandler<?> handler = abstractChangeHandler;
        List list = this.entity.getPropertyNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"entity.propertyNames");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            String propName;
            String string2 = propName = (String)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"propName");
            if (handler.isPropertyIgnored(string2) || handler.isStubChange(propName)) continue;
            map = this.componentSnapshots;
            string = propName;
            snapshot = new PropSnapshot(this.entity, propName);
            map.put(string, snapshot);
        }
        List list2 = this.entity.getBlobNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"entity.blobNames");
        $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            String blobName;
            String string3 = blobName = (String)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"blobName");
            if (handler.isPropertyIgnored(string3) || handler.isStubChange(blobName)) continue;
            map = this.componentSnapshots;
            string = blobName;
            snapshot = new BlobSnapshot(this.entity, blobName);
            map.put(string, snapshot);
        }
    }
}

