/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.NodeBase;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventCategory;
import jetbrains.youtrack.api.events.EventMerge;
import jetbrains.youtrack.api.events.EventSelector;
import jetbrains.youtrack.api.events.EventSource;
import jetbrains.youtrack.api.events.EventSourceCursor;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.event.category.EventCategorizer;
import jetbrains.youtrack.event.source.EventId;
import jetbrains.youtrack.event.source.EventIdKt;
import jetbrains.youtrack.event.source.EventMergeSource;
import jetbrains.youtrack.event.source.MultiSourceCursorRange;
import jetbrains.youtrack.event.source.MultiSourceEventProvider;
import jetbrains.youtrack.event.source.SourceEvent;
import jetbrains.youtrack.gaprest.BeansKt;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="multiSourceEventProvider")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001dJ\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J:\u0010$\u001a\b\u0012\u0004\u0012\u0002H%0\u0016\"\b\b\u0000\u0010%*\u00020\u0013*\b\u0012\u0004\u0012\u0002H%0\u00162\u0016\b\u0002\u0010&\u001a\u0010\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\u0011\u0018\u00010'H\u0002J%\u0010(\u001a\u00020\r*\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010*H\u0002\u00a2\u0006\u0002\u0010,R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ljetbrains/youtrack/event/source/MultiSourceEventProvider;", "", "()V", "categorizer", "Ljetbrains/youtrack/event/category/EventCategorizer;", "eventMergeSource", "Ljetbrains/youtrack/event/source/EventMergeSource;", "sources", "", "Ljetbrains/youtrack/api/events/EventSource;", "createCursorRange", "Ljetbrains/youtrack/event/source/MultiSourceCursorRange;", "selector", "Ljetbrains/youtrack/api/events/EventSelector;", "cursorPresentation", "", "reverse", "", "findEvent", "Ljetbrains/youtrack/api/events/Event;", "id", "getMultipleIssueEvents", "Lkotlin/sequences/Sequence;", "getMultipleIssueSourceEvents", "Ljetbrains/youtrack/event/source/SourceEvent;", "getSingleIssueEventMerges", "", "Ljetbrains/youtrack/api/events/EventMerge;", "sourceTypes", "", "getSingleIssueEvents", "getSingleIssueSourceEventWindow", "event", "windowSize", "", "getSingleIssueSourceEvents", "filterAccessible", "T", "filter", "Lkotlin/Function1;", "limitTime", "start", "", "end", "(Ljetbrains/youtrack/api/events/EventSelector;Ljava/lang/Long;Ljava/lang/Long;)Ljetbrains/youtrack/api/events/EventSelector;", "youtrack-events"})
public class MultiSourceEventProvider {
    @Autowired
    private List<? extends EventSource> sources;
    @Autowired
    private EventMergeSource eventMergeSource;
    @Autowired
    private EventCategorizer categorizer;

    @NotNull
    public final Iterable<EventMerge> getSingleIssueEventMerges(@NotNull EventSelector selector, @Nullable Set<String> sourceTypes) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        EventCategorizer eventCategorizer = this.categorizer;
        if (eventCategorizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"categorizer");
        }
        EventCategory defaultCategory = eventCategorizer.getDefaultCategory();
        EventMergeSource eventMergeSource = this.eventMergeSource;
        if (eventMergeSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
        }
        return SequencesKt.asIterable((Sequence)SequencesKt.filter(eventMergeSource.getDirectEventMerges(selector, sourceTypes), (Function1)((Function1)new Function1<EventMerge, Boolean>(defaultCategory){
            final /* synthetic */ EventCategory $defaultCategory;

            public final boolean invoke(@NotNull EventMerge it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.isVisible((Function1)new Function1<Event, Boolean>(this){
                    final /* synthetic */ getSingleIssueEventMerges.1 this$0;

                    public final boolean invoke(@NotNull Event event2) {
                        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                        return Intrinsics.areEqual((Object)event2.getCategory(), (Object)this.this$0.$defaultCategory) ^ true;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.$defaultCategory = eventCategory;
                super(1);
            }
        })));
    }

    @NotNull
    public final Sequence<Event> getSingleIssueEvents(@NotNull EventSelector selector, boolean reverse) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        EventMergeSource eventMergeSource = this.eventMergeSource;
        if (eventMergeSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
        }
        return SequencesKt.filter((Sequence)SequencesKt.map(eventMergeSource.getEvents(selector, reverse), (Function1)getSingleIssueEvents.1.INSTANCE), (Function1)getSingleIssueEvents.2.INSTANCE);
    }

    @NotNull
    public final Sequence<SourceEvent> getSingleIssueSourceEvents(@NotNull EventSelector selector, @NotNull String cursorPresentation, boolean reverse) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)cursorPresentation, (String)"cursorPresentation");
        EventMergeSource eventMergeSource = this.eventMergeSource;
        if (eventMergeSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
        }
        EventSourceCursor cursor = eventMergeSource.createCursor(selector, cursorPresentation, reverse);
        EventMergeSource eventMergeSource2 = this.eventMergeSource;
        if (eventMergeSource2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
        }
        return eventMergeSource2.getSourceEvents(selector, reverse, (Function1<? super SourceEvent, Boolean>)((Function1)new Function1<SourceEvent, Boolean>(cursor){
            final /* synthetic */ EventSourceCursor $cursor;

            public final boolean invoke(@NotNull SourceEvent it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$cursor.match((Event)it) && it.isVisible();
            }
            {
                this.$cursor = eventSourceCursor;
                super(1);
            }
        }));
    }

    @NotNull
    public final List<SourceEvent> getSingleIssueSourceEventWindow(@NotNull EventSelector selector, @NotNull Event event2, boolean reverse, int windowSize) {
        List list;
        List eventsInTime2;
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
        Long l = event2.getTimestamp();
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"event.timestamp");
        long timestamp = l;
        EventSelector inTimeSelector = this.limitTime(selector, timestamp, timestamp);
        EventMergeSource eventMergeSource = this.eventMergeSource;
        if (eventMergeSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
        }
        if ((eventsInTime2 = SequencesKt.toList(eventMergeSource.getSourceEvents(inTimeSelector, reverse, (Function1<? super SourceEvent, Boolean>)((Function1)getSingleIssueSourceEventWindow.eventsInTime.1.INSTANCE)))).size() < windowSize) {
            int beforeSize = (windowSize - eventsInTime2.size()) / 2;
            EventSelector beforeSelector = this.limitTime(selector, null, timestamp - 1L);
            EventMergeSource eventMergeSource2 = this.eventMergeSource;
            if (eventMergeSource2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
            }
            Sequence eventsBeforeReverse2 = SequencesKt.take(eventMergeSource2.getSourceEvents(beforeSelector, true, (Function1<? super SourceEvent, Boolean>)((Function1)getSingleIssueSourceEventWindow.eventsBeforeReverse.1.INSTANCE)), (int)beforeSize);
            int afterSize = windowSize - beforeSize;
            EventSelector afterSelector = this.limitTime(selector, timestamp + 1L, null);
            EventMergeSource eventMergeSource3 = this.eventMergeSource;
            if (eventMergeSource3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
            }
            Sequence eventsAfterDirect2 = SequencesKt.take(eventMergeSource3.getSourceEvents(afterSelector, false, (Function1<? super SourceEvent, Boolean>)((Function1)getSingleIssueSourceEventWindow.eventsAfterDirect.1.INSTANCE)), (int)afterSize);
            list = reverse ? CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)eventsAfterDirect2)), (Iterable)eventsInTime2), (Sequence)eventsBeforeReverse2) : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)eventsBeforeReverse2)), (Iterable)eventsInTime2), (Sequence)eventsAfterDirect2);
        } else {
            list = CollectionsKt.take((Iterable)eventsInTime2, (int)windowSize);
        }
        return list;
    }

    private final EventSelector limitTime(@NotNull EventSelector $receiver, Long start2, Long end) {
        Long l = end;
        Long l2 = start2;
        NodeBase nodeBase = $receiver.getEventNode();
        return new EventSelector($receiver.getIssue(), $receiver.getAuthor(), $receiver.getCategories(), l2, l, nodeBase);
    }

    @NotNull
    public final Sequence<Event> getMultipleIssueEvents(@NotNull EventSelector selector, boolean reverse) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        EventMergeSource eventMergeSource = this.eventMergeSource;
        if (eventMergeSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
        }
        return MultiSourceEventProvider.filterAccessible$default(this, SequencesKt.map(eventMergeSource.getEvents(selector, reverse), (Function1)getMultipleIssueEvents.1.INSTANCE), null, 1, null);
    }

    @NotNull
    public final Sequence<SourceEvent> getMultipleIssueSourceEvents(@NotNull EventSelector selector, @NotNull String cursorPresentation, boolean reverse) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)cursorPresentation, (String)"cursorPresentation");
        EventMergeSource eventMergeSource = this.eventMergeSource;
        if (eventMergeSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
        }
        EventSourceCursor cursor = eventMergeSource.createCursor(selector, cursorPresentation, reverse);
        EventMergeSource eventMergeSource2 = this.eventMergeSource;
        if (eventMergeSource2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
        }
        return this.filterAccessible(SequencesKt.map(eventMergeSource2.getEventsWithSources(selector, reverse), (Function1)getMultipleIssueSourceEvents.1.INSTANCE), (Function1)new Function1<SourceEvent, Boolean>(cursor){
            final /* synthetic */ EventSourceCursor $cursor;

            public final boolean invoke(@NotNull SourceEvent it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$cursor.match((Event)it);
            }
            {
                this.$cursor = eventSourceCursor;
                super(1);
            }
        });
    }

    private final <T extends Event> Sequence<T> filterAccessible(@NotNull Sequence<? extends T> $receiver, Function1<? super T, Boolean> filter) {
        Map issueAccessCache = new LinkedHashMap();
        return SequencesKt.filter($receiver, (Function1)new Function1<T, Boolean>(filter, issueAccessCache){
            final /* synthetic */ Function1 $filter;
            final /* synthetic */ Map $issueAccessCache;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull T event2) {
                Object object;
                void $receiver$iv;
                boolean bl;
                Function1 function1;
                Intrinsics.checkParameterIsNotNull(event2, (String)"event");
                Function1 function12 = this.$filter;
                if (function12 != null) {
                    Function1 it = function1 = function12;
                    bl = (Boolean)it.invoke(event2);
                } else {
                    bl = true;
                }
                boolean preFiltered = bl;
                if (!preFiltered) return false;
                Function1 issue = function1 = event2.getIssue();
                Map $i$a$1$let = this.$issueAccessCache;
                Function1 function13 = issue;
                Intrinsics.checkExpressionValueIsNotNull((Object)function13, (String)"issue");
                Function1 key$iv = function13;
                V value$iv = $receiver$iv.get(key$iv);
                if (value$iv == null) {
                    Boolean answer$iv = XdIssue.isAccessible$default((XdIssue)((XdIssue)XdExtensionsKt.toXd((Entity)issue)), (Operation)Operation.READ, null, (int)2, null);
                    $receiver$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                if ((Boolean)object == false) return false;
                if (!event2.isVisible()) return false;
                return true;
            }
            {
                this.$filter = function1;
                this.$issueAccessCache = map;
                super(1);
            }
        });
    }

    static /* synthetic */ Sequence filterAccessible$default(MultiSourceEventProvider multiSourceEventProvider, Sequence sequence, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: filterAccessible");
        }
        if ((n & 1) != 0) {
            function1 = null;
        }
        return multiSourceEventProvider.filterAccessible(sequence, function1);
    }

    @NotNull
    public final MultiSourceCursorRange createCursorRange(@NotNull EventSelector selector, @NotNull String cursorPresentation, boolean reverse) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)cursorPresentation, (String)"cursorPresentation");
        EventMergeSource eventMergeSource = this.eventMergeSource;
        if (eventMergeSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventMergeSource");
        }
        return eventMergeSource.createCursorRange(selector, cursorPresentation, reverse);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Event findEvent(@NotNull String id) {
        void $receiver$iv$iv;
        Entity entity;
        Object it;
        Entity entity2;
        EntityId it2;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        EventId eventId = EventIdKt.toEventId(id);
        EntityId entityId = eventId.getXdTargetId();
        if (entityId != null) {
            EntityId entityId2;
            it2 = entityId2 = entityId;
            entity2 = XdExtensionsKt.getSession((TransientEntityStore)((TransientEntityStore)BeansKt.getTransientEntityStore())).getEntity(it2);
        } else {
            entity2 = null;
        }
        Entity targetEntity = entity2;
        EntityId entityId3 = eventId.getXdEventId();
        if (entityId3 != null) {
            it = it2 = entityId3;
            entity = XdExtensionsKt.getSession((TransientEntityStore)((TransientEntityStore)BeansKt.getTransientEntityStore())).getEntity(it);
        } else {
            entity = null;
        }
        Entity eventEntity = entity;
        List<? extends EventSource> list = this.sources;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sources");
        }
        Iterable $receiver$iv = list;
        it = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Event event2;
            Object element$iv$iv = element$iv$iv$iv;
            EventSource it3 = (EventSource)element$iv$iv;
            if (it3.findEvent(targetEntity, eventEntity) == null) continue;
            Event it$iv$iv = event2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (Event)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }
}

