/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.github.persistence.BitBucketChangeDTO;
import jetbrains.youtrack.integration.github.persistence.CredentialsDto;
import jetbrains.youtrack.integration.github.persistence.GithubCloneChangesProcessorImpl;
import jetbrains.youtrack.integration.github.rest.BitBucketRest;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;

public class BitBucketChangesProcessorImpl
extends GithubCloneChangesProcessorImpl {
    private static String __ENTITY_TYPE__ = "BitBucketChangesProcessor";

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(QueryOperations.getFirst((Iterable)QueryOperations.queryGetAll((String)"BitBucketServer")), _entityType_);
        return entity;
    }

    public void process(_FunctionTypes._return_P1_E0<? extends Iterable<CommonChangeDTO>, ? super Entity> changesProvider, Entity entity) {
        if (!this.isEnabled(entity)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Repo disabled. Return", entity);
            return;
        }
        this.doProcess(changesProvider, entity);
        this.setSynchrinizedAt(entity);
    }

    public void processChange(CommonChangeDTO c, Entity entity) {
        String branch = c.branch;
        String logicalBranch = ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneChangesProcessor")).matchesBranchSpec(branch, entity);
        if (logicalBranch != null) {
            c.branch = logicalBranch;
            super.processChange(c, entity);
        } else {
            ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneChangesProcessor")).logBranchDoesNotMatch(c.version, branch, entity);
        }
    }

    @Override
    protected long doCreateHook(Entity entity) {
        return ((BitBucketChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"BitBucketChangesProcessor")).getRest(entity).createHook((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"password", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"path", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"apiKey"), (String)"key", String.class, null));
    }

    @Override
    protected void doDeleteHook(CredentialsDto credentials2, Entity entity) {
        ((BitBucketChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"BitBucketChangesProcessor")).getRest(entity).deleteHook((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"hookId", Long.class, null), credentials2.getLogin(), credentials2.getPassword(), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"path", String.class, null));
    }

    @Override
    public String getUrlString(String hash, Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"url", String.class, null) + (((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"url", String.class, null)).endsWith("/") ? "" : "/") + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"path", String.class, null) + "/commits/" + hash;
    }

    @Override
    public boolean isCommitThere(String hash, Entity entity) {
        return ((BitBucketChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"BitBucketChangesProcessor")).getRest(entity).getCommit((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"password", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"path", String.class, null), hash) != null;
    }

    @Override
    public void setCredentials(CredentialsDto credentials2, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"login", (Comparable)((Object)credentials2.getLogin()), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"password", (Comparable)((Object)credentials2.getPassword()), String.class);
    }

    @Override
    public CredentialsDto getCredentials(Entity entity) {
        return new CredentialsDto((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"password", String.class, null));
    }

    private BitBucketRest getRest(Entity entity) {
        return new BitBucketRest((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"url", String.class, null), AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"sslKey"));
    }

    public CommonChangeDTO toDto(Entity change, Entity entity) {
        return new BitBucketChangeDTO(change);
    }

    public static Entity constructor() {
        return ((BitBucketChangesProcessorImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }
}

