/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.github.persistence.BitBucketChangeDTO;
import jetbrains.youtrack.integration.github.persistence.GithubCloneServerImpl;
import jetbrains.youtrack.integration.github.rest.BitBucketAbstractCommit;
import jetbrains.youtrack.integration.github.rest.BitBucketCommit;
import jetbrains.youtrack.integration.github.rest.BitBucketCommits;
import jetbrains.youtrack.integration.github.rest.BitBucketRest;
import jetbrains.youtrack.integration.github.rest.BitBucketSingleCommit;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.NoUserReasonImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BitBucketServerImpl
extends GithubCloneServerImpl {
    private static String __ENTITY_TYPE__ = "BitBucketServer";
    public static final boolean DISABLE_BITBUCKET_INTEGRATION = Boolean.getBoolean("jetbrains.youtrack.disableBitBucketIntegration");
    public static final String URL = "https://bitbucket.org";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(([a-z0-9!#$%&'*+\\/=?^_`{|}~.-]+)@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*)", 2);
    protected static Log log = LogFactory.getLog(BitBucketServerImpl.class);

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(URL, _entityType_);
        return entity;
    }

    @Override
    public void process(Entity processor, Object payload, final Entity entity) {
        BitBucketCommits bbcs = (BitBucketCommits)payload;
        if (!((String)PrimitiveAssociationSemantics.get((Entity)processor, (String)"path", String.class, null)).equalsIgnoreCase(bbcs.repository.owner + "/" + bbcs.repository.slug)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Changes processor " + (String)PrimitiveAssociationSemantics.get((Entity)processor, (String)"path", String.class, null) + " does not match the reporsitory " + bbcs.repository.owner + "/" + bbcs.repository.slug));
            }
            return;
        }
        final Wrappers._T commits = new Wrappers._T(bbcs.commits);
        if (ListSequence.fromList((List)((List)commits.value)).count() > 1) {
            final String branch = ((BitBucketCommit)ListSequence.fromList((List)((List)commits.value)).last()).branch;
            ListSequence.fromList((List)((List)commits.value)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<BitBucketCommit>(){

                public boolean accept(BitBucketCommit it) {
                    return it.branch == null;
                }
            }).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<BitBucketCommit>(){

                public void visit(BitBucketCommit it) {
                    it.branch = branch;
                }
            });
        }
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"ChangesProcessor")).process((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Iterable<CommonChangeDTO>, Entity>(){

            public Iterable<CommonChangeDTO> invoke(final Entity cp) {
                ISequence dtos = ListSequence.fromList((List)((List)commits.value)).select((_FunctionTypes._return_P1_E0)new ISelector<BitBucketCommit, CommonChangeDTO>(){

                    public CommonChangeDTO select(BitBucketCommit it) {
                        return ((BitBucketServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"BitBucketServer")).toDto(it, cp, it.author, it.rawAuthor, true, entity);
                    }
                }).toListSequence().where((_FunctionTypes._return_P1_E0)new IWhereFilter<CommonChangeDTO>(){

                    public boolean accept(CommonChangeDTO it) {
                        return it != null;
                    }
                });
                commits.value = null;
                return dtos;
            }
        }, processor);
    }

    private CommonChangeDTO toDto(BitBucketAbstractCommit bbc, Entity cp, String author, String rawauthor, boolean enforceCommittersGroup, Entity entity) {
        Entity proc = DnqUtils.cast((Object)cp, (String)"BitBucketChangesProcessor");
        Tuples._2<Entity, Entity> u = ((BitBucketServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"BitBucketServer")).resolveUser(proc, author, rawauthor, entity);
        if (EntityOperations.equals((Entity)((Entity)u._0()), null)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)cp, (String)"ChangesProcessor")).logDebug("Could not find YouTrack user for " + (author == null || author.length() == 0 ? "" : author) + " (" + rawauthor + ")", cp);
        } else if (enforceCommittersGroup && EntityOperations.equals((Entity)((Entity)u._1()), (Object)NoUserReasonImpl.VCS_NOT_IN_COMMITTERS_GROUP.get())) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)cp, (String)"ChangesProcessor")).logInfo("Skipping commit " + bbc.getHash() + " by " + (author == null || author.length() == 0 ? "" : author) + " (" + rawauthor + ") since they do not belong to the committers group", cp);
            return null;
        }
        return new BitBucketChangeDTO(null, (Entity)u._0(), (Entity)u._1(), bbc, cp);
    }

    public Tuples._2<Entity, Entity> resolveUser(Entity bbcp, String author, String rawAuthor, Entity entity) {
        if (rawAuthor == null || rawAuthor.length() == 0) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.BITBUCKET_NO_USER_INFO_PROVIDED.get());
        }
        String email = ((BitBucketServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"BitBucketServer")).extractEmail(rawAuthor, entity);
        if (email == null || email.length() == 0) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.BITBUCKET_NO_RAW_EMAIL.get());
        }
        BitBucketRest rest = ((BitBucketServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"BitBucketServer")).getRest(entity);
        String username = rest.findUserLogin((String)PrimitiveAssociationSemantics.get((Entity)bbcp, (String)"login", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)bbcp, (String)"password", String.class, null), email);
        if (username == null) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.BITBUCKET_NO_USER_BY_EMAIL.get());
        }
        if (!username.equalsIgnoreCase(author)) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.BITBUCKET_NO_USER_BY_EMAIL.get());
        }
        return ((GithubCloneServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneServer")).resolveUser(email, bbcp, NoUserReasonImpl.BITBUCKET_NO_USER_FOUND_IN_YOUTRACK.get(), NoUserReasonImpl.BITBUCKET_USER_NOT_UNIQUE.get(), NoUserReasonImpl.VCS_NOT_IN_COMMITTERS_GROUP.get(), entity);
    }

    private String extractEmail(String rawAuthor, Entity entity) {
        Matcher matcher = EMAIL_PATTERN.matcher(rawAuthor);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public CommonChangeDTO getChange(Iterable<Entity> processors, String version, Entity entity) {
        BitBucketRest rest = ((BitBucketServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"BitBucketServer")).getRest(entity);
        for (Entity processor : processors) {
            Entity cp = DnqUtils.cast((Object)processor, (String)"BitBucketChangesProcessor");
            BitBucketSingleCommit commit = rest.getCommit((String)PrimitiveAssociationSemantics.get((Entity)cp, (String)"login", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)cp, (String)"password", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)cp, (String)"path", String.class, null), version);
            if (commit == null) continue;
            return ((BitBucketServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"BitBucketServer")).toDto(commit, processor, commit.author.user == null ? null : commit.author.user.username, commit.author.raw, false, entity);
        }
        return null;
    }

    @Override
    public String getType(Entity entity) {
        return "Bitbucket";
    }

    public boolean isEnabled(Entity entity) {
        return !DISABLE_BITBUCKET_INTEGRATION;
    }

    private BitBucketRest getRest(Entity entity) {
        return new BitBucketRest((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null), AssociationSemantics.getToOne((Entity)entity, (String)"sslKey"));
    }

    public static Entity constructor() {
        return ((BitBucketServerImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }
}

