/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.github.persistence.CredentialsDto;
import jetbrains.youtrack.integration.github.persistence.GitLabChangeDTO;
import jetbrains.youtrack.integration.github.persistence.GithubCloneChangesProcessorImpl;
import jetbrains.youtrack.integration.github.rest.GitLabRest;
import jetbrains.youtrack.integration.github.rest.GitLabRestV4;
import jetbrains.youtrack.integration.github.rest.JerseyClientExceptionWrapper;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;

public class GitLabChangesProcessorImpl
extends GithubCloneChangesProcessorImpl {
    private static String __ENTITY_TYPE__ = "GitLabChangesProcessor";

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(QueryOperations.getFirst((Iterable)QueryOperations.queryGetAll((String)"GitLabServer")), _entityType_);
        return entity;
    }

    @Override
    public void setCredentials(CredentialsDto credentials2, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"token", (Comparable)((Object)credentials2.getToken()), String.class);
    }

    @Override
    public CredentialsDto getCredentials(Entity entity) {
        return new CredentialsDto((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"token", String.class, null));
    }

    @Override
    protected long doCreateHook(Entity entity) {
        try {
            if (PrimitiveAssociationSemantics.get((Entity)entity, (String)"id", String.class, null) == null) {
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"id", (Comparable)((Object)((GitLabChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GitLabChangesProcessor")).getRest(entity).getRepoId((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"token", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"path", String.class, null))), String.class);
                if (PrimitiveAssociationSemantics.get((Entity)entity, (String)"id", String.class, null) == null) {
                    throw new LocalizedLogicException((Localization)new LocalizationObject("GitLabChangesProcessor.The_specified_URL_does_not_point_to_a_GitLab_repository", new Object[0]));
                }
            }
            return ((GitLabChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GitLabChangesProcessor")).getRest(entity).createHook((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"token", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"id", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"apiKey"), (String)"key", String.class, null));
        }
        catch (JerseyClientExceptionWrapper e) {
            if (e.getCode() == 422) {
                throw new LocalizedLogicException((Localization)new LocalizationObject("GitLabChangesProcessor.Received_the_following_error_when_creating_a_hook_{0}_The_most_probable_reason_is_described_{1}", new Object[]{e.getLocalizedMessage(), BaseHtmlStringUtil.html((Object)((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("GitLabChangesProcessor.{0}here{1}", new Object[]{"<a href='https://youtrack.jetbrains.com/issue/JT-48855#focus=streamItem-27-3084237-0-0' class=\"ring-link\">", "</>"}))}));
            }
            if (e.getCode() == 404) {
                throw new LocalizedLogicException((Localization)new LocalizationObject("GitLabChangesProcessor.Received_{0}_from_GitLab_server_Please_make_sure_the_URL_is_correct_and_the_user_has_access_to_the_repository", new Object[]{"NOT_FOUND"}));
            }
            throw new LocalizedLogicException((Localization)new LocalizationObject("GitLabChangesProcessor.Received_the_following_error_when_creating_a_hook_{0}", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @Override
    protected void doDeleteHook(CredentialsDto credentials2, Entity entity) {
        ((GitLabChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GitLabChangesProcessor")).getRest(entity).deleteHook(credentials2.getToken(), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"id", String.class, null), (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"hookId", Long.class, null));
    }

    @Override
    public boolean isCommitThere(String hash, Entity entity) {
        return ((GitLabChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GitLabChangesProcessor")).getRest(entity).getCommit((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"token", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"id", String.class, null), hash) != null;
    }

    @Override
    public String getUrlString(String hash, Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"url", String.class, null) + (((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"url", String.class, null)).endsWith("/") ? "" : "/") + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"path", String.class, null) + "/commit/" + hash;
    }

    private GitLabRest getRest(Entity entity) {
        return GitLabRestV4.get((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"url", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"token", String.class, null), AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"sslKey"));
    }

    public CommonChangeDTO toDto(Entity change, Entity entity) {
        return new GitLabChangeDTO(change);
    }

    public static Entity constructor() {
        return ((GitLabChangesProcessorImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }
}

