/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.service.UserFields;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.github.persistence.CredentialsDto;
import jetbrains.youtrack.integration.github.persistence.GithubCloneServerImpl;
import jetbrains.youtrack.integration.misc.BranchSpec;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;

public class GithubCloneChangesProcessorImpl
extends ChangesProcessorImpl {
    private static String __ENTITY_TYPE__ = "GithubCloneChangesProcessor";

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(Entity server, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"server", (Entity)server);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"committers", (Entity)((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneChangesProcessor")).findCommittersGroup(entity));
        return entity;
    }

    public void setCredentials(CredentialsDto credentials2, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public CredentialsDto getCredentials(Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public void createHook(Entity entity) {
        if (this.isEnabled(entity)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Creating hook", entity);
            try {
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"hookId", (Comparable)Long.valueOf(((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneChangesProcessor")).doCreateHook(entity)), Long.class);
            }
            catch (Exception e) {
                if (e instanceof LogicException) {
                    throw (LogicException)e;
                }
                throw new LocalizedLogicException((Localization)new LocalizationObject("GithubCloneChangesProcessor.Failed_to_create_a_hook_The_following_error_occured_{0}", new Object[]{e.getMessage()}), e);
            }
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Hook created", entity);
        } else {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("The integration is disabled", entity);
        }
    }

    protected long doCreateHook(Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public void deleteHook(CredentialsDto credentials2, Entity entity) {
        if ((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"hookId", Long.class, null) != 0L) {
            try {
                ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneChangesProcessor")).doDeleteHook(credentials2 == null ? this.getCredentials(entity) : credentials2, entity);
            }
            catch (Exception e) {
                ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logException(e, "Exception while deleting a hook", false, false, entity);
            }
        }
    }

    protected void doDeleteHook(CredentialsDto credentials2, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public boolean isCommitThere(String hash, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public String getUrlString(String hash, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public String getChangeHref(CommonChangeDTO changeDto, Entity entity) {
        return ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneChangesProcessor")).getUrlString(changeDto.version, entity);
    }

    public String matchesBranchSpec(String branchName, Entity entity) {
        if (GithubCloneChangesProcessorImpl.isEmpty_1tfshw_a0a0l((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"branch", String.class, null))) {
            return branchName;
        }
        return BranchSpec.match((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"branch", String.class, null)), (String)(branchName == null || branchName.length() == 0 ? "" : branchName.toLowerCase()));
    }

    public String getOneLineBrachSpec(Entity entity) {
        if (GithubCloneChangesProcessorImpl.isEmpty_1tfshw_a0a0a21_0((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"branch", String.class, null)) || GithubCloneChangesProcessorImpl.isEmpty_1tfshw_a0a0a21(GithubCloneChangesProcessorImpl.trim_1tfshw_a0a0a0m((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"branch", String.class, null)))) {
            return "";
        }
        return ((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"branch", String.class, null)).replace("\n", "|");
    }

    public void logBranchDoesNotMatch(String revisions, String branch, Entity entity) {
        boolean multiple = revisions.indexOf(",") > -1;
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Skipped commit" + (multiple ? "s " : " ") + revisions + " since " + (multiple ? "their" : "its") + " branch (" + branch + ") does not match the spec " + ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneChangesProcessor")).getOneLineBrachSpec(entity), entity);
    }

    protected String getLogPrefix(Entity entity) {
        String branchSpec = ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneChangesProcessor")).getOneLineBrachSpec(entity);
        return "[" + ((GithubCloneServerImpl)DnqUtils.getPersistentClassInstance((Entity)DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"GithubCloneServer"), (String)"GithubCloneServer")).getType(DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"GithubCloneServer")) + " Integration " + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"shortName", String.class, null) + "<-" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"path", String.class, null) + (branchSpec == null || branchSpec.length() == 0 ? "" : " (branch spec: " + branchSpec + ")") + "]: ";
    }

    public Entity findCommittersGroup(Entity entity) {
        Iterable groups = ((UserFields)ServiceLocator.getBean((String)"userFields")).getAssigneeGroups(AssociationSemantics.getToOne((Entity)entity, (String)"project"));
        if (QueryOperations.getSize((Iterable)groups) == 1) {
            return QueryOperations.getFirst((Iterable)groups);
        }
        return (Entity)ServiceLocator.getBean((String)"allUsersGroup");
    }

    protected boolean isCommiter(Entity user, Entity entity) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isInGroup(AssociationSemantics.getToOne((Entity)entity, (String)"committers"), user);
    }

    public static Entity constructor(Entity server) {
        return ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(server, __ENTITY_TYPE__);
    }

    public static boolean isEmpty_1tfshw_a0a0l(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_1tfshw_a0a0a21(String str) {
        return str == null || str.length() == 0;
    }

    public static String trim_1tfshw_a0a0a0m(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean isEmpty_1tfshw_a0a0a21_0(String str) {
        return str == null || str.length() == 0;
    }
}

