/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.rest;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.ssl.SSLContextFactory;
import jetbrains.youtrack.integration.github.rest.BitBucketRest;
import jetbrains.youtrack.integration.github.rest.ExtendedRepositoryService;
import jetbrains.youtrack.integration.github.rest.GithubException;
import jetbrains.youtrack.integration.github.rest.WebHook;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.RepositoryHook;
import org.eclipse.egit.github.core.UserPlan;
import org.eclipse.egit.github.core.client.DateFormatter;
import org.eclipse.egit.github.core.client.EventFormatter;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.event.Event;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.RepositoryService;

public class GitHubRest {
    public static final String HOOK_NAME = "web";
    public static final String COMMTITTERS = "committers";
    public static final String BRANCH = "branch";
    protected static Log log = LogFactory.getLog(GitHubRest.class);
    private String url;
    private Entity sslKey;

    public GitHubRest(String url, Entity sslKey) {
        this.url = url;
        this.sslKey = sslKey;
    }

    public long createHook(Entity repo) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating a hook in " + (String)PrimitiveAssociationSemantics.get((Entity)repo, (String)"path", String.class, null)));
        }
        try {
            RepositoryService service = this.getRepositoryService((String)PrimitiveAssociationSemantics.get((Entity)repo, (String)"oauthToken", String.class, null));
            Repository repository = service.getRepository(GitHubRest.getOwner(repo), GitHubRest.getName(repo));
            RepositoryHook result = service.createHook((IRepositoryIdProvider)repository, this.getHook(repo));
            return result.getId();
        }
        catch (RequestException e) {
            if (e.getStatus() == 404) {
                throw new GithubException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("GitHubRest.You_do_not_have_admin_permission_on_the_repository", new Object[0]), e);
            }
            throw new GithubException((Exception)((Object)e));
        }
        catch (IOException ex) {
            throw new GithubException(ex);
        }
    }

    public void deleteHook(Entity repo, String token) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Deleting a hook in " + (String)PrimitiveAssociationSemantics.get((Entity)repo, (String)"path", String.class, null)));
        }
        RepositoryService service = this.getRepositoryService(token);
        try {
            service.deleteHook((IRepositoryIdProvider)service.getRepository(GitHubRest.getOwner(repo), GitHubRest.getName(repo)), (int)((Long)PrimitiveAssociationSemantics.get((Entity)repo, (String)"hookId", Long.class, null)).longValue());
        }
        catch (IOException exception) {
            throw new GithubException(exception);
        }
    }

    public boolean getHookSettingsForRepo(Entity repo) {
        RepositoryHook hook = this.getHook((String)PrimitiveAssociationSemantics.get((Entity)repo, (String)"oauthToken", String.class, null), GitHubRest.getOwner(repo), GitHubRest.getName(repo));
        if (hook != null) {
            PrimitiveAssociationSemantics.set((Entity)repo, (String)"hookId", (Comparable)Long.valueOf(hook.getId()), Long.class);
            PrimitiveAssociationSemantics.set((Entity)repo, (String)"enabled", (Comparable)Boolean.valueOf(hook.isActive()), Boolean.class);
            return true;
        }
        return false;
    }

    public Iterable<String> getBranches(String token, String path) throws GithubException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Retrieving branches from " + path));
        }
        RepositoryService service = this.getRepositoryService(token);
        try {
            List branches2 = service.getBranches((IRepositoryIdProvider)service.getRepository(GitHubRest.getOwner(path), GitHubRest.getName(path)));
            return ListSequence.fromList((List)ListSequence.fromListWithValues(new ArrayList(), (Iterable)branches2)).select((_FunctionTypes._return_P1_E0)new ISelector<RepositoryBranch, String>(){

                public String select(RepositoryBranch it) {
                    return it.getName();
                }
            });
        }
        catch (IOException exception) {
            throw new GithubException(exception);
        }
    }

    public RepositoryHook getHook(String token, String ownerName, String repoName) throws GithubException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Retrieving hook settings for " + ownerName + "/" + repoName));
        }
        RepositoryService service = this.getRepositoryService(token);
        try {
            return (RepositoryHook)ListSequence.fromList((List)ListSequence.fromListWithValues(new ArrayList(), (Iterable)service.getHooks((IRepositoryIdProvider)service.getRepository(ownerName, repoName)))).where((_FunctionTypes._return_P1_E0)new IWhereFilter<RepositoryHook>(){

                public boolean accept(RepositoryHook it) {
                    return GitHubRest.eq_b5nep7_a0a0a0a0a0a0a2a4(it.getName(), GitHubRest.HOOK_NAME);
                }
            }).first();
        }
        catch (IOException exception) {
            throw new GithubException(exception);
        }
    }

    private RepositoryHook getHook(Entity repo) {
        WebHook hook = new WebHook();
        hook.setName(HOOK_NAME);
        hook.setActive((Boolean)PrimitiveAssociationSemantics.get((Entity)repo, (String)"enabled", Boolean.class, null));
        if ((Long)PrimitiveAssociationSemantics.get((Entity)repo, (String)"hookId", Long.class, null) != 0L) {
            hook.setId((Long)PrimitiveAssociationSemantics.get((Entity)repo, (String)"hookId", Long.class, null));
        }
        IMapSequence config = MapSequence.fromMapAndKeysArray(new HashMap(), (Object[])new String[]{"url", "content_type", "insecure_ssl", "secret"}).withValues((Object[])new String[]{BitBucketRest.getLandingUrl() + "rest/vcsHooksReceiver/github?apiKey=" + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)repo, (String)"apiKey"), (String)"key", String.class, null), "json", "1", (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)repo, (String)"apiKey"), (String)"key", String.class, null)});
        hook.setConfig((Map)config);
        hook.setEvents(new String[]{"push", "pull_request"});
        return hook;
    }

    private RepositoryService getRepositoryService(String token) {
        return new ExtendedRepositoryService(this.getClient(token));
    }

    private CommitService getCommitService(String token) {
        return new CommitService(this.getClient(token));
    }

    private GitHubClient getClient(String oauthToken) {
        GitHubClient client = this.createClient(this.url);
        client.setOAuth2Token(oauthToken);
        return client;
    }

    private GitHubClient createClient(String githubUrl) {
        try {
            URL url = new URL(githubUrl);
            String host = url.getHost();
            if (host.equals("github.com") || host.equals("gist.github.com")) {
                return new GitHubClient("api.github.com"){

                    protected HttpURLConnection createConnection(String url) throws IOException {
                        return GitHubRest.this.setupConnection(super.createConnection(url));
                    }
                };
            }
            return new GitHubCli(url);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Invalid github url");
        }
    }

    public RepositoryCommit getCommit(final Entity repo, String sha) {
        CommitService commitService = this.getCommitService((String)PrimitiveAssociationSemantics.get((Entity)repo, (String)"oauthToken", String.class, null));
        try {
            RepositoryCommit commit = commitService.getCommit(new IRepositoryIdProvider(){

                public String generateId() {
                    return (String)PrimitiveAssociationSemantics.get((Entity)repo, (String)"path", String.class, null);
                }
            }, sha);
            return commit;
        }
        catch (IOException exception) {
            if (exception instanceof RequestException && ((RequestException)((Object)exception)).getStatus() != 404 && log.isWarnEnabled()) {
                log.warn((Object)("Exception when getting a github commit " + sha + " in " + (String)PrimitiveAssociationSemantics.get((Entity)repo, (String)"path", String.class, null)), (Throwable)exception);
            }
            return null;
        }
    }

    private HttpURLConnection setupConnection(HttpURLConnection connection) throws IOException {
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(100000);
        return connection;
    }

    private static String getOwner(Entity repo) {
        return GitHubRest.getOwner((String)PrimitiveAssociationSemantics.get((Entity)repo, (String)"path", String.class, null));
    }

    private static String getName(Entity repo) {
        return GitHubRest.getName((String)PrimitiveAssociationSemantics.get((Entity)repo, (String)"path", String.class, null));
    }

    private static String getOwner(String repoPath) {
        return GitHubRest.splitAndCheck(repoPath)[0];
    }

    private static String getName(String repoPath) {
        return GitHubRest.splitAndCheck(repoPath)[1];
    }

    private static String[] splitAndCheck(String repoPath) throws IllegalArgumentException {
        String[] segments = repoPath.split("/");
        if (segments.length != 2) {
            throw new IllegalArgumentException("Invalid repository path format: " + repoPath);
        }
        return segments;
    }

    private static boolean eq_b5nep7_a0a0a0a0a0a0a2a4(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    public class GitHubCli
    extends GitHubClient {
        public GitHubCli(URL url) {
            super(url.getHost(), url.getPort(), url.getProtocol());
            this.gson = this.buildGson();
        }

        protected HttpURLConnection createConnection(String url) throws IOException {
            HttpURLConnection connection = super.createConnection(url);
            if (connection instanceof HttpsURLConnection) {
                SSLContext sslContext = ((SSLContextFactory)ServiceLocator.getBean((String)"sslContextFactory")).createContext(GitHubRest.this.sslKey);
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            return GitHubRest.this.setupConnection(connection);
        }

        private Gson buildGson() {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(Date.class, (Object)new DateFormatter());
            builder.registerTypeAdapter(Event.class, (Object)new EventFormatter());
            builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
            builder.serializeNulls();
            builder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

                public boolean shouldSkipField(FieldAttributes p0) {
                    return false;
                }

                public boolean shouldSkipClass(Class<?> c) {
                    return c == UserPlan.class;
                }
            }});
            return builder.create();
        }
    }
}

