/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.rest;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.List;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import jetbrains.charisma.rest.JacksonObjectMapperProvider;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.ssl.SSLContextFactory;
import jetbrains.youtrack.integration.github.rest.BitBucketRest;
import jetbrains.youtrack.integration.github.rest.GitLabBranch;
import jetbrains.youtrack.integration.github.rest.GitLabBranches;
import jetbrains.youtrack.integration.github.rest.GitLabCommit;
import jetbrains.youtrack.integration.github.rest.GitLabHook;
import jetbrains.youtrack.integration.github.rest.GitLabProject;
import jetbrains.youtrack.integration.github.rest.GitLabProjects;
import jetbrains.youtrack.integration.github.rest.GitLabUser;
import jetbrains.youtrack.integration.github.rest.GitLabUsers;
import jetbrains.youtrack.integration.github.rest.JerseyClientExceptionWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import webr.framework.controller.CentralManager;

public class GitLabRest {
    private static final int TIMEOUT = 300;
    protected static final int PER_PAGE = Integer.getInteger("jetbrains.youtrack.vcs.gitlab.repos_page_size", 100);
    protected static Log log = LogFactory.getLog(GitLabRest.class);
    protected WebTarget wr;

    public GitLabRest(String url, jetbrains.exodus.entitystore.Entity sslKey) {
        ClientBuilder config = ClientBuilder.newBuilder();
        ((ClientBuilder)config.register(JacksonObjectMapperProvider.class)).register(JacksonFeature.class);
        config.property("jersey.config.client.connectTimeout", (Object)300000);
        config.property("jersey.config.client.readTimeout", (Object)300000);
        config.sslContext(((SSLContextFactory)ServiceLocator.getBean((String)"sslContextFactory")).createContext(sslKey));
        this.wr = config.build().target(url);
    }

    protected String apiPrefix() {
        return "api/v3/";
    }

    public Iterable<String> getBranches(String token, String path) {
        GitLabBranches branches2 = BitBucketRest.get(this.addHeaders(this.wr.path(this.apiPrefix() + "projects/" + path + "/repository/branches"), token), GitLabBranches.class);
        return ListSequence.fromList((List)branches2).select((_FunctionTypes._return_P1_E0)new ISelector<GitLabBranch, String>(){

            public String select(GitLabBranch it) {
                return it.name;
            }
        });
    }

    public String getRepoId(String token, final String path) {
        GitLabProject project;
        block22: {
            ISequence pathSegments;
            block21: {
                pathSegments = Sequence.fromArray((Object[])path.split("/"));
                project = null;
                if (Sequence.fromIterable((Iterable)pathSegments).count() == 2) {
                    try {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Trying to retrieve " + path + " as a user owned project"));
                        }
                        String username = (String)Sequence.fromIterable((Iterable)pathSegments).first();
                        Iterable users = BitBucketRest.get(this.addHeaders(this.wr.path(this.apiPrefix() + "users").queryParam("username", new Object[]{username}), token), GitLabUsers.class);
                        if (Sequence.fromIterable((Iterable)users).isEmpty()) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)"Retrieved users set is empty; seems to be a group repository");
                            }
                        } else if (Sequence.fromIterable((Iterable)users).count() > 1) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Retrieved more than one users with username " + username));
                            }
                        } else {
                            long userId = ((GitLabUser)Sequence.fromIterable((Iterable)users).first()).id;
                            GitLabProjects glps = BitBucketRest.get(this.addHeaders(this.addCommonSearchParams(this.wr.path(this.apiPrefix() + "users/" + userId + "/projects"), (String)Sequence.fromIterable((Iterable)pathSegments).last()), token), GitLabProjects.class);
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Retrieved a whole lot of " + glps.size() + " project infos"));
                            }
                            if ((project = (GitLabProject)Sequence.fromIterable((Iterable)glps).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<GitLabProject>(){

                                public boolean accept(GitLabProject it) {
                                    return it.path_with_namespace.equalsIgnoreCase(path);
                                }
                            })) == null && log.isErrorEnabled()) {
                                log.error((Object)("Found no matching project among retrieved. Will try to treat " + path + " as a group project"));
                            }
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof JerseyClientExceptionWrapper && ((JerseyClientExceptionWrapper)e).getCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Received 404, thus " + path + " seems to be a group project"));
                            }
                        }
                        if (!log.isInfoEnabled()) break block21;
                        log.info((Object)("Received an unknown error will try to treat " + path + " as a group project"), (Throwable)e);
                    }
                }
            }
            if (project != null) {
                return project.id;
            }
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Trying to retrieve " + path + " as a group owned project"));
                }
                String groupFullName = IterableUtils.join((Iterable)Sequence.fromIterable((Iterable)pathSegments).cut(1), (String)"%2F");
                GitLabProjects glps = BitBucketRest.get(this.addHeaders(this.addCommonSearchParams(this.wr.path(this.apiPrefix() + "groups/" + groupFullName + "/projects"), (String)Sequence.fromIterable((Iterable)pathSegments).last()), token), GitLabProjects.class);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Retrieved a whole lot of " + glps.size() + " project infos"));
                }
                if ((project = (GitLabProject)Sequence.fromIterable((Iterable)glps).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<GitLabProject>(){

                    public boolean accept(GitLabProject it) {
                        return it.path_with_namespace.equalsIgnoreCase(path);
                    }
                })) == null && log.isErrorEnabled()) {
                    log.error((Object)("Found no project matching " + path + "among retrieved"));
                }
            }
            catch (Exception e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Received an error while trying to retrieve " + path + " as a group project"), (Throwable)e);
                }
                if (!(e instanceof JerseyClientExceptionWrapper)) break block22;
                throw (JerseyClientExceptionWrapper)e;
            }
        }
        return project == null ? null : project.id;
    }

    public WebTarget addCommonSearchParams(WebTarget wt, String search) {
        return wt.queryParam("search", new Object[]{search}).queryParam("simple", new Object[]{"true"}).queryParam("per_page", new Object[]{"100"});
    }

    public long createHook(String token, String projectId, String hookReceiverId) {
        String url = BitBucketRest.getLandingUrl() + "rest/vcsHooksReceiver/gitlab?apiKey=" + hookReceiverId;
        return BitBucketRest.post((Invocation.Builder)this.addHeaders((WebTarget)this.wr.path((String)new StringBuilder().append((String)this.apiPrefix()).append((String)"projects/").append((String)projectId).append((String)"/hooks").toString()), (String)token), (Entity)Entity.entity((Object)new StringBuilder().append((String)"push_events=true&url=").append((String)url).toString(), (String)"application/x-www-form-urlencoded"), GitLabHook.class).id;
    }

    public void deleteHook(String token, String projectId, long id) {
        BitBucketRest.delete(this.addHeaders(this.wr.path(this.apiPrefix() + "projects/" + projectId + "/hooks/" + id), token));
    }

    public GitLabCommit getCommit(String token, String projectId, String hash) {
        try {
            return BitBucketRest.get(this.addHeaders(this.wr.path(this.apiPrefix() + "projects/" + projectId + "/repository/commits/" + hash), token), GitLabCommit.class);
        }
        catch (JerseyClientExceptionWrapper e) {
            if (e.getCode() != Response.Status.NOT_FOUND.getStatusCode() && log.isWarnEnabled()) {
                log.warn((Object)("Exception when getting a gitlab commit " + hash + " in " + projectId), (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Exception when getting a gitlab commit " + hash + " in " + projectId), (Throwable)e);
            }
            return null;
        }
    }

    protected Invocation.Builder addHeaders(WebTarget wr, String token) {
        return wr.request().header("PRIVATE-TOKEN", (Object)token).header("user-agent", (Object)(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getApplicationName() + "/" + ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion() + " (build #" + ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationBuild() + "). Base URL: " + (String)PrimitiveAssociationSemantics.get((jetbrains.exodus.entitystore.Entity)((jetbrains.exodus.entitystore.Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"baseUrl", String.class, null)));
    }
}

