/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.google.gson.Gson;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.IOException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.statistics.StatisticsService;
import jetbrains.youtrack.integration.github.persistence.GithubCloneServerImpl;
import jetbrains.youtrack.integration.github.rest.BitBucketCommits;
import jetbrains.youtrack.integration.github.rest.GitHubPushPayload;
import jetbrains.youtrack.integration.github.rest.GitLabHookPayload;
import jetbrains.youtrack.integration.vcs.VcsServerImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.egit.github.core.client.GsonUtils;

@Path(value="/vcsHooksReceiver")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class VcsHooksReceiverResource
implements Resource {
    protected static Log log = LogFactory.getLog(VcsHooksReceiverResource.class);

    @POST
    @Path(value="/bitbucket")
    public Response post_Bitbucket(@QueryParam(value="apiKey") String apiKey, @QueryParam(value="payload") String payload, String bean) {
        if (bean != null && bean.length() > 0) {
            payload = bean;
        }
        return this.receive(apiKey, QueryOperations.getFirst((Iterable)QueryOperations.queryGetAll((String)"BitBucketServer")), (Iterable<Entity>)QueryOperations.queryGetAll((String)"BitBucketChangesProcessor"), payload, this.getJsonUnmarshaller(BitBucketCommits.class));
    }

    @POST
    @Path(value="/gitlab")
    public Response post_Gitlab(@QueryParam(value="apiKey") String apiKey, String bean) {
        return this.receive(apiKey, QueryOperations.getFirst((Iterable)QueryOperations.queryGetAll((String)"GitLabServer")), (Iterable<Entity>)QueryOperations.queryGetAll((String)"GitLabChangesProcessor"), bean, this.getJsonUnmarshaller(GitLabHookPayload.class));
    }

    @POST
    @Path(value="/github")
    public Response post_Github(@QueryParam(value="apiKey") String apiKey, final String bean) {
        return this.receive(apiKey, QueryOperations.getFirst((Iterable)QueryOperations.queryGetAll((String)"GithubServer")), (Iterable<Entity>)QueryOperations.queryGetAll((String)"GithubRepo"), bean, (_FunctionTypes._return_P2_E0<? extends Object, ? super String, ? super String>)new _FunctionTypes._return_P2_E0<Object, String, String>(){

            public Object invoke(String payload, String serverType) {
                Gson gson = GsonUtils.getGson();
                try {
                    return gson.fromJson(bean, GitHubPushPayload.class);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Error parsing " + serverType + " hook post"), (Throwable)e);
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Could not parse the request. " + e.getMessage())).build();
                }
            }
        });
    }

    private Response receive(String apiKey, Entity server, Iterable<Entity> processors, String payload, _FunctionTypes._return_P2_E0<? extends Object, ? super String, ? super String> unmarshaller) {
        String featureName = server.getType() + ".hookCalled";
        ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance(new StatisticsFeatureDescription("vcs", featureName));
        if (log.isInfoEnabled()) {
            log.info((Object)featureName);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Payload is as follows");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)payload);
        }
        if (!((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)server, (String)"VcsServer")).isEnabled(server)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(((GithubCloneServerImpl)DnqUtils.getPersistentClassInstance((Entity)server, (String)"GithubCloneServer")).getType(server) + " integration disabled"));
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)(((GithubCloneServerImpl)DnqUtils.getPersistentClassInstance((Entity)server, (String)"GithubCloneServer")).getType(server) + " integration is disabled")).build();
        }
        if (payload == null || payload.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Empty payload").build();
        }
        Entity processor = QueryOperations.getFirst((Iterable)QueryOperations.query(processors, (String)"GithubCloneChangesProcessor", (NodeBase)new LinksEqualDecorator("apiKey", (NodeBase)new PropertyEqual("key", (Comparable)((Object)apiKey)), "ApiKey")));
        if (EntityOperations.equals((Entity)processor, null)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("[" + ((GithubCloneServerImpl)DnqUtils.getPersistentClassInstance((Entity)server, (String)"GithubCloneServer")).getType(server) + " integration]: No processor found for API key " + apiKey));
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No processor found for API key").build();
        }
        Object ret = unmarshaller.invoke((Object)payload, (Object)((GithubCloneServerImpl)DnqUtils.getPersistentClassInstance((Entity)server, (String)"GithubCloneServer")).getType(server));
        if (ret instanceof Response) {
            return (Response)ret;
        }
        ((GithubCloneServerImpl)DnqUtils.getPersistentClassInstance((Entity)server, (String)"GithubCloneServer")).process(processor, ret, server);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private _FunctionTypes._return_P2_E0<? extends Object, ? super String, ? super String> getJsonUnmarshaller(final Class payloadClass) {
        return new _FunctionTypes._return_P2_E0<Object, String, String>(){

            public Object invoke(String payload, String serverType) {
                ObjectMapper wrapperMapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector());
                try {
                    return wrapperMapper.readValue(payload, payloadClass);
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Error parsing " + serverType + " hook post"), (Throwable)e);
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Could not parse the request. " + e.getMessage())).build();
                }
            }
        };
    }
}

