/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.imageTool.utils;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import jetbrains.mps.webr.stateless.template.runtime.TemplateBuilderContext;

public class JSONBuilder {
    private TemplateBuilderContext builderContext;
    private List<String> closeChar = ListSequence.fromList(new ArrayList());
    private List<Boolean> isFirst = ListSequence.fromList(new ArrayList());
    private boolean valueExpected = false;

    public JSONBuilder(TemplateBuilderContext builderContext) {
        this.builderContext = builderContext;
    }

    public JSONBuilder arr() {
        this.commaIfRequired();
        this.builderContext.append("[");
        ListSequence.fromList(this.closeChar).addElement((Object)"]");
        ListSequence.fromList(this.isFirst).addElement((Object)true);
        this.valueExpected = false;
        return this;
    }

    public JSONBuilder obj() {
        this.commaIfRequired();
        this.builderContext.append("{");
        ListSequence.fromList(this.closeChar).addElement((Object)"}");
        ListSequence.fromList(this.isFirst).addElement((Object)true);
        this.valueExpected = false;
        return this;
    }

    public JSONBuilder end() {
        this.builderContext.append((String)ListSequence.fromList(this.closeChar).removeLastElement());
        ListSequence.fromList(this.isFirst).removeLastElement();
        this.valueExpected = false;
        return this;
    }

    private void commaIfRequired() {
        if (ListSequence.fromList(this.isFirst).isNotEmpty() && !this.valueExpected) {
            if (((Boolean)ListSequence.fromList(this.isFirst).last()).booleanValue()) {
                ListSequence.fromList(this.isFirst).setElement(ListSequence.fromList(this.isFirst).count() - 1, (Object)false);
            } else {
                this.builderContext.append(", ");
            }
        }
    }

    public JSONBuilder name(String name) {
        this.commaIfRequired();
        this.builderContext.append("\"");
        this.builderContext.append(JsStringUtil.stringLiteral((Object)name));
        this.builderContext.append("\": ");
        this.valueExpected = true;
        return this;
    }

    public JSONBuilder value(String value) {
        if (value != null) {
            this.builderContext.append("\"");
            this.builderContext.append(JsStringUtil.stringLiteral((Object)value));
            this.builderContext.append("\"");
        } else {
            this.builderContext.append("null");
        }
        this.valueExpected = false;
        return this;
    }

    public JSONBuilder value(int value) {
        this.builderContext.append(String.valueOf(value));
        this.valueExpected = false;
        return this;
    }

    public JSONBuilder value(boolean value) {
        this.builderContext.append(String.valueOf(value));
        this.valueExpected = false;
        return this;
    }

    public JSONBuilder endValue() {
        this.valueExpected = false;
        return this;
    }
}

