var attachActionsController;


var AttachActionsController = {};
AttachActionsController = function (errorMessageOnAppletCall) {
  this.onAttachDefaultCallbacks = [];
  this.configurations = {};
  if (!!attachActionsController) {
    console.error("AttachActionsController is inited twice");
  }

  attachActionsController = this;
  this.init();
};
AttachActionsController.prototype.init = function () {
  var self = this;
  $(document).keydown(function (e) {
    if (Webr.component.panel.Dialog.isModalVisible() || charisma.smartui.ViewImageAttachment.isVisible() || !AttachActionsController.onlyOneIssue()) {
      return true;
    }

    var actionName = AttachActionsController.keyEventToActionName(e);
    if (actionName) {
      self.attach(actionName);
      return false;
    }

    return true;
  });
    

  $(window.document).on('click', ".yt-attach", function () {
    if (AttachActionsController.onlyOneIssue()) {
      self.attach(AttachActionsController.classToActionName($(this)), null, null, $(this).attr("iid"));
      return false;
    }

  });
};
AttachActionsController.prototype.doAttach = function (action, callback, issueId, commentId) {
  if (!issueId) {
    issueId = commonController.getFocusedIssueId();
  }

  var self = this;
  if (action == AttachActionsController.UPLOAD_FILE || action == AttachActionsController.UPLOAD_FILE_SECURILY) {
    attachFileDialog.show(function () {
      self.invokeCallbacks(callback);
    }, (action == AttachActionsController.UPLOAD_FILE_SECURILY), issueId, commentId);
  } else {
    imageAttachAndEditDialog.show(function () {
      self.invokeCallbacks(callback);
    }, issueId, commentId);
  }

};
AttachActionsController.prototype.attach = function (action, callback, issueId, commentId) {
  this.doAttach(action, callback, issueId, commentId);
};
AttachActionsController.prototype.invokeCallbacks = function (callback) {
  if (!!callback) {
    callback();
    return ;
  }

  for (var i = 0; i < this.onAttachDefaultCallbacks.length; ++i) {
    (this.onAttachDefaultCallbacks[i])();
  }

};
AttachActionsController.prototype.addDefaultCallback = function (onAttach) {
  this.onAttachDefaultCallbacks.push(onAttach);
};
AttachActionsController.UPLOAD_FILE = "UPLOAD_FILE";
AttachActionsController.UPLOAD_FILE_SECURILY = "UPLOAD_FILE_SECURILY";
AttachActionsController.TAKE_SCREENSHOT = "TAKE_SCREENSHOT";
AttachActionsController.PASTE_IMAGE = "PASTE_IMAGE";
AttachActionsController.PASTE_IMAGE_NO_PREVIEW = "PASTE_IMAGE_NO_PREVIEW";
AttachActionsController.getAppletActionsTypes = function () {
  var types = {};
  types[AttachActionsController.TAKE_SCREENSHOT] = "takeScreenshot";
  types[AttachActionsController.PASTE_IMAGE] = "pasteFromClipboard";
  types[AttachActionsController.PASTE_IMAGE_NO_PREVIEW] = "pasteFromClipboardNoPreview";
  return types;
};
AttachActionsController.classToActionName = function (target) {
  if (target.hasClass('yt-attach_file')) {
    return AttachActionsController.UPLOAD_FILE;
  }

  if (target.hasClass('yt-attach_file-securely')) {
    return AttachActionsController.UPLOAD_FILE_SECURILY;
  }

  if (target.hasClass('yt-attach_screenshot')) {
    return AttachActionsController.TAKE_SCREENSHOT;
  }

  if (target.hasClass('yt-attach_clipboard')) {
    return AttachActionsController.PASTE_IMAGE;
  }

  return AttachActionsController.PASTE_IMAGE_NO_PREVIEW;
};
AttachActionsController.keyEventToActionName = function (evt) {
  if (Webr.util.Key.isApplicable(evt, SmartUIShortCuts["AddFile"])) {
    return AttachActionsController.UPLOAD_FILE;
  }

  if (Webr.util.Key.isApplicable(evt, SmartUIShortCuts["TakeScreenshot"])) {
    return AttachActionsController.TAKE_SCREENSHOT;
  }

  if (Webr.util.Key.isApplicable(evt, SmartUIShortCuts["PasteFromClipboard"])) {
    return AttachActionsController.PASTE_IMAGE;
  }

  if (Webr.util.Key.isApplicable(evt, SmartUIShortCuts["PasteFromClipboardNoPreview"])) {
    return AttachActionsController.PASTE_IMAGE_NO_PREVIEW;
  }

  return undefined;
};
AttachActionsController.APPLET_ACTION_TYPES = AttachActionsController.getAppletActionsTypes();
AttachActionsController.onlyOneIssue = function () {
  return (commonController) && commonController.getFocusedIssueId();
};




