var imageAttachAndEditDialog;
var attachmentInputInstance;
var ImageAttachAndEditDialog = {};
ImageAttachAndEditDialog = function (windowId) {
  ImageAttachAndEditDialog.superclass.constructor.call(this, "#imageAttachAndEditDialog", null);
  this.windowId = windowId;
  imageAttachAndEditDialog = this;
};
{
  var F = new Function();
  F.prototype = charisma.BaseDialog.prototype;
  ImageAttachAndEditDialog.prototype = new F();
  ImageAttachAndEditDialog.prototype.constructor = ImageAttachAndEditDialog;
  ImageAttachAndEditDialog.superclass = charisma.BaseDialog.prototype;
}

ImageAttachAndEditDialog.prototype.init = function (id) {
  ImageAttachAndEditDialog.superclass.init.call(this, id);
  var it = this;
  attachmentInputInstance = new AttachmentInput({target: $(".dragzone-component"), enableFireFoxImagePaste: true, enableChromeImagePaste: true, onProcessBase64: function (data, name) {
    it.close();
    it.callImageEditor(data, name);
  }, onError: function (errorKey) {
    Webr.event.PopupMessage.SYSTEM.show(AttachActionsErrors[errorKey], 5000);
  }});
};
ImageAttachAndEditDialog.prototype.show = function (callback, issueId, commentId) {
  ImageAttachAndEditDialog.superclass.show.call(this);
  $(document.body).addClass('yt-attach-input-drop');
  this.restClient = new Webr.rest.Client(Webr.Event.rootUrl, Ajax.ajaxSettings());
  this.issueId = issueId;
  this.commentId = commentId;
  this.callback = callback;
  attachmentInputInstance.init();
};
ImageAttachAndEditDialog.prototype.close = function () {
  attachmentInputInstance.unbind();
  $(document.body).removeClass('yt-attach-input-drop');
  ImageAttachAndEditDialog.superclass.close.call(this);
};
ImageAttachAndEditDialog.prototype.callImageEditor = function (data, name) {
  var it = this;
  var extensionPosition = name.lastIndexOf(".");
  if (extensionPosition > 0) {
    name = name.substring(0, extensionPosition);
  }

  var settings = {onSave: function (resultDataUrl, imageName, groupIds, userIds) {
    AttachActionsUtils.saveBase64({content: resultDataUrl, defaultFileName: imageName, permittedGroupIds: groupIds, permittedUserIds: userIds, windowId: it.windowId, success: it.callback, issueId: it.issueId, commentId: it.commentId, success: it.callback});
  }, issue: it.issueId, imageSrc: data, imageName: name, imageIsAlreadyAttached: false};
  imageToolDialog.show(settings);
};
