/*
 Copyright 2017 JetBrains s.r.o.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

exports.defaultLinkTypeMapping = {
  Blocks: {name: 'Depend', inversion: false},
  Relates: {name: 'Relates', inversion: false},
  Related: {name: 'Relates', inversion: false}, // can be found in some jira instances with pretty old data
  Duplicate: {name: 'Duplicate', inversion: true},
  Subtask: {name: 'Subtask', inversion: false}
};

exports.skipEventsOn = [
  'WorklogId'//skip due to artificially created change 'worklog'
];

exports.weirdChangeFieldIds = {
  'Fix Version': 'fixVersions',
  'Version': 'versions',
  'Link': 'issuelinks',
  'Parent': 'parent'
};

exports.ignorableUpdates = [
  'reporter',
  'labels',
  'votes'
];

exports.stateColors = {
  'undefined': 1,
  'new': 15,
  'done': 3,
  'indeterminate': 13
};

exports.permissionKeys = {
  'BROWSE' : ['BROWSE'],
  'CREATE_ISSUE': ['CREATE_ISSUE'],
  'PROJECT_ADMIN': ['PROJECT_ADMIN', 'ADMINISTER_PROJECTS'],
  'VIEW_VOTERS_AND_WATCHERS': ['VIEW_VOTERS_AND_WATCHERS'],
  'MANAGE_WATCHER_LIST': ['MANAGE_WATCHER_LIST', 'MANAGE_WATCHERS']
};