/*
 Copyright 2017 JetBrains s.r.o.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

var params = require('@jetbrains/youtrack-scripting-api/environment').parameters;
var paramsToArray = function (prefix) {
  return params.get().getPairs().toArray().filter(function (param) {
    return param.key.indexOf(prefix) > -1;
  }).map(function (param) {
    return param.key.substr(prefix.length);
  });
};

['url', 'login', 'password', 'sslKeyName', 'issueId'].forEach(function (propName) {
  Object.defineProperty(exports, propName, {
    enumerable: true,
    get: function() {
      return params.get().get(propName);
    }
  });
});

Object.defineProperty(exports, 'projects', {
  enumerable: true,
  get: function() {
    return paramsToArray('projectKey.');
  }
});

Object.defineProperty(exports, 'useAdminPermission', {
  enumerable: true,
  get: function() {
    return params.get().get('useAdminPermission') === 'true';
  }
});

Object.defineProperty(exports, 'issuesBulkSize', {
  enumerable: true,
  get: function() {
    return parseInt(params.get().get('issuesBulkSize'));
  }
});