/*
 Copyright 2017 JetBrains s.r.o.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

var env = require('@jetbrains/youtrack-scripting-api/environment');
var importContext = require('./importContext');
var importSettings = require('./importSettings');

var errorMessage = null;
var version5plus = true;
console.log('Requesting jira at ' + importSettings.url);
var failureHandler = function (failure) {
  if (failure.response) {
    var errorJson = null;
    try {
      errorJson = JSON.parse(failure.response);
    } catch (e) {
      // ignore, html can be here, not json
    }
    errorMessage = (errorJson ? failure.code + ' ' + errorJson.errorMessages : 'Jira replied with status code ' + failure.code);
    if (failure.code === 404) {
      version5plus = false;
    }
  } else if (failure.exception) {
    errorMessage = failure.exception;
  }
  env.status.setOutput('connectionMessage', null);
};

env.status.setOutput('connectionMessage', 'Retrieving global permissions');
var permissions = importContext.jiraClient.getGlobalPermissions(failureHandler);

var projects = null;
if (!errorMessage) {
  env.status.setOutput('connectionMessage', 'Retrieving projects');
  importContext.jiraClient.getProjects(function (ps) {
    var i = 1;
    projects = ps.filter(function (p) {
      env.status.setOutput('connectionMessage', 'Retrieving per project permissions. ' + i++ + ' of ' + ps.length + ' projects have been processed');
      var inaccessibleProject = false;
      p.$permissions = importContext.jiraClient.getProjectPermissions(p.key, function (result) {
        if (result.code === 404) {
          inaccessibleProject = true;
        } else {
          failureHandler(result);
        }
      });
      if (!p.$permissions['BROWSE']) {
        inaccessibleProject = true;
      }
      return !inaccessibleProject;
    });
  }, failureHandler);
  env.status.setOutput('connectionMessage', null);
}

exports.hasAdminPermission = permissions && permissions['ADMINISTER'] && permissions['ADMINISTER'].havePermission;
exports.testResult = errorMessage;
exports.version5plus = version5plus;
exports.projects = projects;