/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jabber.bot.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.dnq.lang.PersistentClassesKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.CommandService;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.commands.PredefinedCommandType;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.statistics.BeansKt;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.jabber.bot.EmptyIssuesAndCommandGenerator;
import jetbrains.youtrack.jabber.bot.IssuesAndCommand;
import jetbrains.youtrack.jabber.bot.JabberMessageListener;
import jetbrains.youtrack.jabber.bot.LastNotificationIssueMessageSplitter;
import jetbrains.youtrack.jabber.bot.MessageSplitter;
import jetbrains.youtrack.jabber.bot.StateLessMessageSplitter;
import jetbrains.youtrack.jabber.bot.XdJabberBotState;
import jetbrains.youtrack.jabber.bot.processors.ApplyCommandToIssueProcessor;
import jetbrains.youtrack.jabber.bot.processors.IMessageProcessor;
import jetbrains.youtrack.parser.base.SuggestItem;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0002J,\u0010(\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\n2\b\u0010*\u001a\u0004\u0018\u00010\n2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\nH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ljetbrains/youtrack/jabber/bot/processors/ApplyCommandToIssueProcessor;", "Ljetbrains/youtrack/jabber/bot/processors/IMessageProcessor;", "()V", "commandService", "Ljetbrains/youtrack/api/commands/CommandService;", "getCommandService", "()Ljetbrains/youtrack/api/commands/CommandService;", "setCommandService", "(Ljetbrains/youtrack/api/commands/CommandService;)V", "commentCommand", "", "getCommentCommand", "()Ljava/lang/String;", "feature", "Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "getFeature", "()Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "messageListener", "Ljetbrains/youtrack/jabber/bot/JabberMessageListener;", "getMessageListener", "()Ljetbrains/youtrack/jabber/bot/JabberMessageListener;", "setMessageListener", "(Ljetbrains/youtrack/jabber/bot/JabberMessageListener;)V", "ordinal", "", "getOrdinal", "()I", "splitters", "", "Ljetbrains/youtrack/jabber/bot/MessageSplitter;", "getValidCommands", "", "Ljetbrains/youtrack/api/commands/ICommand;", "commandList", "Ljetbrains/youtrack/api/commands/ICommandList;", "processCommandListWithError", "", "body", "context", "Ljetbrains/charisma/smartui/persistent/Context;", "processCorrectCommandList", "comment", "additionalMessage", "tryProcess", "", "message", "Companion", "youtrack-jabber-bot"})
public final class ApplyCommandToIssueProcessor
implements IMessageProcessor {
    private final List<MessageSplitter> splitters = CollectionsKt.listOf((Object[])new MessageSplitter[]{new StateLessMessageSplitter(), new LastNotificationIssueMessageSplitter(), new EmptyIssuesAndCommandGenerator()});
    @Autowired
    @NotNull
    public JabberMessageListener messageListener;
    @Autowired
    @NotNull
    public CommandService commandService;
    private final int ordinal = 5;
    @NotNull
    private final StatisticsFeatureDescription feature = new StatisticsFeatureDescription("jabber", "applyCommandRequest");
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JabberMessageListener getMessageListener() {
        JabberMessageListener jabberMessageListener = this.messageListener;
        if (jabberMessageListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
        }
        return jabberMessageListener;
    }

    public final void setMessageListener(@NotNull JabberMessageListener jabberMessageListener) {
        Intrinsics.checkParameterIsNotNull((Object)jabberMessageListener, (String)"<set-?>");
        this.messageListener = jabberMessageListener;
    }

    @NotNull
    public final CommandService getCommandService() {
        CommandService commandService = this.commandService;
        if (commandService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandService");
        }
        return commandService;
    }

    public final void setCommandService(@NotNull CommandService commandService) {
        Intrinsics.checkParameterIsNotNull((Object)commandService, (String)"<set-?>");
        this.commandService = commandService;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @NotNull
    public final String getCommentCommand() {
        String string = PredefinedCommandType.comment.getName(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getServerLocale());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PredefinedCommandType.co\u2026e(localizer.serverLocale)");
        return string;
    }

    @NotNull
    public final StatisticsFeatureDescription getFeature() {
        return this.feature;
    }

    @Override
    public boolean tryProcess(@NotNull String message) {
        ICommandList commandList;
        CharSequence charSequence;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Entity entity = jetbrains.charisma.persistent.BeansKt.getCurrentUser().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"currentUser.get()");
        XdJabberBotState state = XdJabberBotState.Companion.getState(entity);
        IssuesAndCommand issuesAndCommand = null;
        for (MessageSplitter splitter : this.splitters) {
            issuesAndCommand = splitter.splitMessage(message, state);
            if (issuesAndCommand != null && issuesAndCommand.isError()) {
                JabberMessageListener jabberMessageListener = this.messageListener;
                if (jabberMessageListener == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
                }
                String string2 = issuesAndCommand.getErrorMessage();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                jabberMessageListener.sendMessageToUser(string2);
                return true;
            }
            if (issuesAndCommand == null || issuesAndCommand.isEmpty()) continue;
            break;
        }
        BeansKt.getStatisticsService().incForUser(this.feature);
        Context context = new Context();
        IssuesAndCommand issuesAndCommand2 = issuesAndCommand;
        if (issuesAndCommand2 == null) {
            Intrinsics.throwNpe();
        }
        context.setSelectedIssues((Iterable)issuesAndCommand2.getIssues());
        String command = issuesAndCommand.getCommand();
        state.cleanExpiredParams();
        String string3 = command;
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        int commentStartIndex = StringsKt.indexOf$default((CharSequence)string5, (String)this.getCommentCommand(), (int)0, (boolean)false, (int)6, null);
        String comment = null;
        if (commentStartIndex != -1) {
            charSequence = command;
            int n = commentStartIndex + this.getCommentCommand().length() + 1;
            String string6 = ((String)charSequence).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            comment = string6;
            charSequence = command;
            n = 0;
            int n2 = commentStartIndex + this.getCommentCommand().length();
            String string7 = ((String)charSequence).substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            command = string7;
        }
        if ((charSequence = (CharSequence)command) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            if (XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.asQuery((Iterable)context.getSelectedIssues(), (XdEntityType)((XdEntityType)XdIssue.Companion)))) {
                Iterable iterable = context.getSelectedIssues();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"context.selectedIssues");
                String issueIds2 = CollectionsKt.joinToString$default((Iterable)iterable, null, null, null, (int)0, null, (Function1)tryProcess.issueIds.1.INSTANCE, (int)31, null);
                JabberMessageListener jabberMessageListener = this.messageListener;
                if (jabberMessageListener == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
                }
                jabberMessageListener.sendMessageToUser(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ApplyCommandToIssuesProcessor.Command_required_For_example_type_<br/>", new Object[0]) + "<br/>" + issueIds2 + ' ' + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("youtrack.state.fixed", new Object[0]) + " <br/> " + JabberMessageListener.Companion.getHelpMessage());
            } else {
                JabberMessageListener jabberMessageListener = this.messageListener;
                if (jabberMessageListener == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
                }
                jabberMessageListener.sendMessageToUser(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ApplyCommandToIssuesProcessor.Command_required_For_example_type_<br/>_XX-1_fixed_<br/>", new Object[0]) + "<br/> XX-1 " + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("youtrack.state.fixed", new Object[0]) + " <br/>" + JabberMessageListener.Companion.getHelpMessage());
            }
            return true;
        }
        CommandService commandService = this.commandService;
        if (commandService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandService");
        }
        if ((commandList = commandService.parse(command, (IContext)context)).hasErrors()) {
            ICommandList iCommandList = commandList;
            Intrinsics.checkExpressionValueIsNotNull((Object)iCommandList, (String)"commandList");
            this.processCommandListWithError(iCommandList, command, context);
        } else {
            ICommandList iCommandList = commandList;
            Intrinsics.checkExpressionValueIsNotNull((Object)iCommandList, (String)"commandList");
            if (CollectionUtilKt.isNotEmpty((Iterable)iCommandList.getCommands())) {
                this.processCorrectCommandList(commandList, comment, issuesAndCommand.getAdditionalMessage(), context);
            }
        }
        return true;
    }

    private final void processCommandListWithError(ICommandList commandList, String body, Context context) {
        Object element$iv2;
        block9: {
            Iterable iterable = commandList.getCells();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"commandList.cells");
            Iterable $receiver$iv = iterable;
            for (Object element$iv2 : $receiver$iv) {
                ICell it;
                ICell iCell = it = (ICell)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)iCell, (String)"it");
                if (!iCell.isError()) continue;
                break block9;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        ICell firstErrorCell = (ICell)element$iv2;
        if (Intrinsics.areEqual((Object)firstErrorCell.getClass().getName(), (Object)"UnexpectedEofCell")) {
            Object element$iv32;
            block10: {
                ICommandList updatedCommandList;
                CommandService commandService = this.commandService;
                if (commandService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"commandService");
                }
                ICommandList iCommandList = updatedCommandList = commandService.parse(body + " ", (IContext)context);
                Intrinsics.checkExpressionValueIsNotNull((Object)iCommandList, (String)"updatedCommandList");
                Iterable iterable = iCommandList.getCells();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"updatedCommandList.cells");
                Iterable $receiver$iv = iterable;
                for (Object element$iv32 : $receiver$iv) {
                    ICell it;
                    ICell iCell = it = (ICell)element$iv32;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iCell, (String)"it");
                    if (!iCell.isError()) continue;
                    break block10;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            firstErrorCell = (ICell)element$iv32;
        }
        String suggestions = "";
        ICell iCell = firstErrorCell;
        Intrinsics.checkExpressionValueIsNotNull((Object)iCell, (String)"firstErrorCell");
        Iterable iterable = firstErrorCell.getSuggestions(iCell.getEnd());
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"firstErrorCell.getSuggestions(firstErrorCell.end)");
        List suggestionsSequence = CollectionsKt.take((Iterable)iterable, (int)JabberMessageListener.Companion.getMAX_SUGGESTIONS());
        try {
            for (int cursor = firstErrorCell.getEnd(); suggestionsSequence.isEmpty() && cursor > firstErrorCell.getStart(); --cursor) {
                Iterable iterable2 = firstErrorCell.getSuggestions(cursor);
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"firstErrorCell.getSuggestions(cursor)");
                suggestionsSequence = CollectionsKt.take((Iterable)iterable2, (int)JabberMessageListener.Companion.getMAX_SUGGESTIONS());
            }
        }
        catch (Throwable e) {
            Companion.getLogger().warn(e, (Function0)processCommandListWithError.2.INSTANCE);
        }
        Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)suggestionsSequence);
        for (Object element$iv4 : $receiver$iv) {
            SuggestItem it = (SuggestItem)element$iv4;
            StringBuilder stringBuilder = new StringBuilder().append(suggestions);
            SuggestItem suggestItem = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)suggestItem, (String)"it");
            suggestions = stringBuilder.append(suggestItem.getOption()).append(" (").append(it.getDescription()).append(")<br/>").toString();
        }
        JabberMessageListener jabberMessageListener = this.messageListener;
        if (jabberMessageListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
        }
        jabberMessageListener.sendMessageToUser(firstErrorCell.getText() + (!StringsKt.isBlank((CharSequence)suggestions) ? jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ApplyCommandToIssuesProcessor._Possible_options_<br/>", new Object[0]) + "<br/> " + suggestions : "") + "<br/>" + (StringsKt.isBlank((CharSequence)suggestions) ? jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ApplyCommandToIssuesProcessor.You_can_type_help_or_to_view_help", new Object[0]) : jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ApplyCommandToIssuesProcessor.Or_you_can_type_help_or_to_view_help", new Object[0])));
    }

    /*
     * WARNING - void declaration
     */
    private final void processCorrectCommandList(ICommandList commandList, String comment, String additionalMessage, Context context) {
        CharSequence charSequence;
        Object object;
        Iterator $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = context.getSelectedIssues();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"context.selectedIssues");
        Iterable iterable2 = $receiver$iv = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Entity entity = (Entity)item$iv$iv;
            object = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            charSequence = ((IssueImpl)PersistentClassesKt.asPersistentClass((Entity)v1)).getId((Entity)it);
            object.add(charSequence);
        }
        List issueIds2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        try {
            commandList.execute();
        }
        catch (LogicException e) {
            JabberMessageListener jabberMessageListener = this.messageListener;
            if (jabberMessageListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
            }
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            jabberMessageListener.sendMessageToUser(string);
            return;
        }
        catch (Throwable e) {
            Companion.getLogger().error(e, (Function0)processCorrectCommandList.1.INSTANCE);
            JabberMessageListener jabberMessageListener = this.messageListener;
            if (jabberMessageListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
            }
            jabberMessageListener.sendMessageToUser(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ApplyCommandToIssuesProcessor.Cannot_apply_your_command_because_of_exception_<br/>", new Object[0]) + "<br/>" + JabberMessageListener.Companion.getHelpMessage());
            return;
        }
        if (comment != null && !commandList.hasDeleteIssueCommand()) {
            Iterable iterable3 = context.getSelectedIssues();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable3, (String)"context.selectedIssues");
            $receiver$iv = iterable3;
            for (Object element$iv : $receiver$iv) {
                Entity it;
                Entity entity = it = (Entity)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"it");
                ((IssueImpl)PersistentClassesKt.asPersistentClass((Entity)entity)).addComment(comment, it);
            }
        }
        DnqUtils.getCurrentTransientSession().flush();
        String commandsResultDescriptor = "";
        Iterable<ICommand> $receiver$iv2 = this.getValidCommands(commandList);
        Object object2 = $receiver$iv2.iterator();
        while (object2.hasNext()) {
            ICommand element$iv;
            ICommand it = element$iv = object2.next();
            StringBuilder stringBuilder = new StringBuilder().append(commandsResultDescriptor);
            JabberMessageListener jabberMessageListener = this.messageListener;
            if (jabberMessageListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
            }
            commandsResultDescriptor = stringBuilder.append(jabberMessageListener.commandToString(it)).append(" <br/>}").toString();
        }
        String string = issueIds2.size() > 1 ? jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ApplyCommandToIssuesProcessor.Command_successfully_applied_to_issues", new Object[0]) : jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ApplyCommandToIssuesProcessor.Command_successfully_applied_to_issue", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (issueIds.size > 1)\n \u2026sfully_applied_to_issue\")");
        String successMessageStart = string;
        JabberMessageListener jabberMessageListener = this.messageListener;
        if (jabberMessageListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
        }
        object2 = additionalMessage;
        charSequence = new StringBuilder().append(successMessageStart).append(CollectionsKt.joinToString$default((Iterable)issueIds2, null, null, null, (int)0, null, null, (int)63, null)).append(commandsResultDescriptor).append(' ');
        object = jabberMessageListener;
        boolean bl = object2 == null || StringsKt.isBlank((CharSequence)object2);
        ((JabberMessageListener)object).sendMessageToUser(((StringBuilder)charSequence).append(!bl ? "<br/>" + additionalMessage : "").toString());
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<ICommand> getValidCommands(ICommandList commandList) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = commandList.getCommands();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"commandList.commands");
        Iterable iterable2 = $receiver$iv = iterable;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ICommand it;
            ICommand iCommand = it = (ICommand)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)iCommand, (String)"it");
            if (!(iCommand.getCommandExecutor() != null || it.isError())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/jabber/bot/processors/ApplyCommandToIssueProcessor$Companion;", "Lmu/KLogging;", "()V", "youtrack-jabber-bot"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

