/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jabber.bot.processors;

import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.jabber.bot.JabberMessageListener;
import jetbrains.youtrack.jabber.bot.processors.IMessageProcessor;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/jabber/bot/processors/BannedUserMessageProcessor;", "Ljetbrains/youtrack/jabber/bot/processors/IMessageProcessor;", "()V", "feature", "Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "getFeature", "()Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "messageListener", "Ljetbrains/youtrack/jabber/bot/JabberMessageListener;", "getMessageListener", "()Ljetbrains/youtrack/jabber/bot/JabberMessageListener;", "setMessageListener", "(Ljetbrains/youtrack/jabber/bot/JabberMessageListener;)V", "ordinal", "", "getOrdinal", "()I", "tryProcess", "", "message", "", "Companion", "youtrack-jabber-bot"})
public final class BannedUserMessageProcessor
implements IMessageProcessor {
    private final int ordinal = 0;
    @Autowired
    @NotNull
    public JabberMessageListener messageListener;
    @NotNull
    private final StatisticsFeatureDescription feature = new StatisticsFeatureDescription("jabber", "bannedUserRequest");
    public static final Companion Companion = new Companion(null);

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @NotNull
    public final JabberMessageListener getMessageListener() {
        JabberMessageListener jabberMessageListener = this.messageListener;
        if (jabberMessageListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
        }
        return jabberMessageListener;
    }

    public final void setMessageListener(@NotNull JabberMessageListener jabberMessageListener) {
        Intrinsics.checkParameterIsNotNull((Object)jabberMessageListener, (String)"<set-?>");
        this.messageListener = jabberMessageListener;
    }

    @NotNull
    public final StatisticsFeatureDescription getFeature() {
        return this.feature;
    }

    @Override
    public boolean tryProcess(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Entity entity = BeansKt.getCurrentUser().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"currentUser.get()");
        if (((XdUser)XdExtensionsKt.toXd((Entity)entity)).getBanned()) {
            jetbrains.youtrack.api.statistics.BeansKt.getStatisticsService().incForUser(this.feature);
            JabberMessageListener jabberMessageListener = this.messageListener;
            if (jabberMessageListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
            }
            Entity entity2 = BeansKt.getCurrentUser().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"currentUser.get()");
            String string = new XdUser(entity2).getJabberAccountName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            jabberMessageListener.sendMessageToUser(Companion.getUserIsBannedMessage(string));
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/jabber/bot/processors/BannedUserMessageProcessor$Companion;", "", "()V", "getUserIsBannedMessage", "", "userAccount", "youtrack-jabber-bot"})
    public static final class Companion {
        @NotNull
        public final String getUserIsBannedMessage(@NotNull String userAccount) {
            Intrinsics.checkParameterIsNotNull((Object)userAccount, (String)"userAccount");
            String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("BannedUserMessageProcessr.User_with_jabber_account", new Object[]{userAccount});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026er_account\", userAccount)");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

