/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jabber.bot.processors;

import java.util.Locale;
import java.util.Set;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.jabber.bot.JabberMessageListener;
import jetbrains.youtrack.jabber.bot.processors.HardcodedMessageProcessor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/jabber/bot/processors/HelpMessageProcessor;", "Ljetbrains/youtrack/jabber/bot/processors/HardcodedMessageProcessor;", "()V", "applyCommandExample", "", "getApplyCommandExample", "()Ljava/lang/String;", "feature", "Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "getFeature", "()Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "helpText", "getHelpText", "messageListener", "Ljetbrains/youtrack/jabber/bot/JabberMessageListener;", "getMessageListener", "()Ljetbrains/youtrack/jabber/bot/JabberMessageListener;", "ordinal", "", "getOrdinal", "()I", "searchRequestExample", "getSearchRequestExample", "getPossibleMessagesInLocale", "", "locale", "Ljava/util/Locale;", "internalProcess", "", "message", "youtrack-jabber-bot"})
public class HelpMessageProcessor
extends HardcodedMessageProcessor {
    @NotNull
    private final StatisticsFeatureDescription feature = new StatisticsFeatureDescription("jabber", "helpRequest");
    private final int ordinal = 1;

    @NotNull
    public final StatisticsFeatureDescription getFeature() {
        return this.feature;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @NotNull
    public final JabberMessageListener getMessageListener() {
        String name$iv = "jabberListener";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.jabber.bot.JabberMessageListener");
        }
        return (JabberMessageListener)object;
    }

    @Override
    @NotNull
    public Set<String> getPossibleMessagesInLocale(@NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        return SetsKt.setOf((Object[])new String[]{"/?", '/' + BeansKt.getLocalizer().getMsgInLocale("jetbrains.youtrack.jabberbot.help", locale, new Object[0])});
    }

    @Override
    protected void internalProcess(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.getMessageListener().sendMessageToUser(this.getHelpText());
        jetbrains.youtrack.api.statistics.BeansKt.getStatisticsService().incForUser(this.feature);
    }

    private final String getHelpText() {
        String applyCommand = BeansKt.getLocalizer().localizedMsg("HelpMessageProcessor.Command_syntax_parts_in_brackets_are_optional_issueID_command_comment_comment_s_text", new Object[0]) + "<br/>" + BeansKt.getLocalizer().localizedMsg("Youtrack.jabber.help.for_example", new Object[0]) + " " + this.getApplyCommandExample() + " " + BeansKt.getLocalizer().localizedMsg("youtrack.jabber.help.comment.text", new Object[0]) + "<br/>";
        String searchRequest = BeansKt.getLocalizer().localizedMsg("HelpMessageProcessor.To_search_for_issues_type_your_query_starting_with_/_For_example_{0}", new Object[0]) + this.getSearchRequestExample() + "<br/>";
        return applyCommand + searchRequest + BeansKt.getLocalizer().localizedMsg("HelpMessageProcessor.To_get_issue_details_type_/_followed_by_it_s_ID_For_example_/TST-154", new Object[0]);
    }

    private final String getApplyCommandExample() {
        return "txt-1 " + BeansKt.getLocalizer().localizedMsg("youtrack.state.open", new Object[0]) + " " + BeansKt.getLocalizer().localizedMsg("youtrack.priority.critical", new Object[0]) + " " + BeansKt.getLocalizer().localizedMsg("youtrack.supplied_field.fix_versions.name", new Object[0]) + " 4.2 " + BeansKt.getLocalizer().localizedMsg("predefined_command_type.comment", new Object[0]) + " ";
    }

    private final String getSearchRequestExample() {
        return "#" + BeansKt.getLocalizer().localizedMsg("youtrack.states.unresolved", new Object[0]) + " " + BeansKt.getLocalizer().localizedMsg("youtrack.supplied_field.priority.name", new Object[0]) + ":" + BeansKt.getLocalizer().localizedMsg("youtrack.priority.major", new Object[0]) + ", " + BeansKt.getLocalizer().localizedMsg("youtrack.priority.critical", new Object[0]);
    }
}

