/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jira.oldImport;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import jetbrains.charisma.persistent.UserActionJobContainer;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.imports.persistent.ImportImpl;
import jetbrains.youtrack.imports.persistent.ImportStateImpl;
import jetbrains.youtrack.imports.persistent.ImportStatusImpl;
import jetbrains.youtrack.imports.persistent.ObsoleteImportScriptRunner;
import jetbrains.youtrack.imports.sandbox.PersistentEvalParamsAdapter;
import jetbrains.youtrack.imports.sandbox.PersistentEvalStatusAdapter;
import jetbrains.youtrack.jira.oldImport.ConnectionStatus;
import jetbrains.youtrack.jira.oldImport.JiraApi;
import jetbrains.youtrack.jira.oldImport.JiraImportUtil;
import jetbrains.youtrack.jira.oldImport.ProjectInfo;
import jetbrains.youtrack.jira.oldImport.ProjectPermissionInfo;
import jetbrains.youtrack.scripts.persistence.EvaluationStatus;
import jetbrains.youtrack.scripts.persistence.ScriptFullName;
import jetbrains.youtrack.scripts.persistence.SimpleEvalStatus;
import jetbrains.youtrack.scripts.sandbox.AbstractEvaluationParameters;
import jetbrains.youtrack.scripts.sandbox.SimpleEvalParams;

public class JiraRestApi
implements JiraApi {
    private static final String WF_PACKAGE_NAME = "jetbrains/youtrack/imports/jira";
    private static ScriptFullName IMPORT_SCRIPT_FULL_NAME = new ScriptFullName("jetbrains/youtrack/imports/jira", "import");
    private static ScriptFullName TEST_CONNECTION_SCRIPT_FULL_NAME = new ScriptFullName("jetbrains/youtrack/imports/jira", "testConnection");
    private volatile String connectionError;
    private volatile Iterable<ProjectInfo> projects;
    private volatile boolean hasAdmPerm;
    private volatile SimpleEvalStatus status;
    private Entity myJis;
    private Entity myJimp;

    public JiraRestApi() {
        this.setJimp(((JiraImportUtil)ServiceLocator.getBean((String)"jiraImportUtil")).getOrCreateJiraImport());
    }

    @Override
    public String getConnectionMessage() {
        if (this.connectionError != null) {
            return this.connectionError;
        }
        return this.status == null || this.status.getOutput("connectionMessage") == null ? null : this.status.getOutput("connectionMessage").toString();
    }

    @Override
    public void cancelConnection() {
        ((ObsoleteImportScriptRunner)ServiceLocator.getBean((String)"importScriptRunner")).stop(TEST_CONNECTION_SCRIPT_FULL_NAME);
    }

    @Override
    public String getProgressMessage() {
        Entity status = AssociationSemantics.getToOne((Entity)this.getJimp(), (String)"status");
        Comparable stage = ((ImportStatusImpl)DnqUtils.getPersistentClassInstance((Entity)status, (String)"ImportStatus")).get("stage", status);
        Comparable lastIssueId = ((ImportStatusImpl)DnqUtils.getPersistentClassInstance((Entity)status, (String)"ImportStatus")).get("lastImportedIssueId", status);
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("JiraRestApi.{_0}{_1}{_2}", new Object[]{((ImportImpl)DnqUtils.getPersistentClassInstance((Entity)this.getJimp(), (String)"Import")).isInState(ImportStateImpl.FAILED.get(), this.getJimp()), ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("JiraRestApi.Import_failed_with_error_{0}", new Object[]{((ImportStatusImpl)DnqUtils.getPersistentClassInstance((Entity)status, (String)"ImportStatus")).get("errorMessage", status)}), stage != null, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("JiraRestApi.Current_import_stage_{0}", new Object[]{stage}), lastIssueId != null, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("JiraRestApi.Last_imported_issue_id_is_{0}", new Object[]{lastIssueId})});
    }

    @Override
    public Iterable<ProjectInfo> getProjects() {
        return this.projects;
    }

    @Override
    public boolean hasAdminPermission() {
        return this.hasAdmPerm;
    }

    public void resetAll() {
        this.status = null;
        this.clear();
        this.setJimp(((JiraImportUtil)ServiceLocator.getBean((String)"jiraImportUtil")).getOrCreateJiraImport());
    }

    private void reset() {
        this.status = new SimpleEvalStatus();
        this.clear();
    }

    private void clear() {
        this.connectionError = null;
        this.projects = null;
        this.hasAdmPerm = false;
    }

    public void testConnection() {
        if (this.getConnectionStatus() != ConnectionStatus.PENDING && JiraRestApi.isNotEmpty_9dx9fg_a0a0a0a8((String)PrimitiveAssociationSemantics.get((Entity)this.getJis(), (String)"jiraUrl", String.class, null)) && JiraRestApi.isNotEmpty_9dx9fg_a0a0a0i((String)PrimitiveAssociationSemantics.get((Entity)this.getJis(), (String)"jiraLogin", String.class, null)) && JiraRestApi.isNotEmpty_9dx9fg_a0a0a8((String)PrimitiveAssociationSemantics.get((Entity)this.getJis(), (String)"jiraPassword", String.class, null))) {
            this.reset();
            ((Executor)ServiceLocator.getBean((String)"quartzThreadExecutor")).execute(new Runnable(){

                @Override
                public void run() {
                    JiraRestApi.this.doTestConnection();
                }
            });
        }
    }

    private void doTestConnection() {
        final Wrappers._T params = new Wrappers._T();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                params.value = MapSequence.fromMapAndKeysArray(new HashMap(), (Object[])new String[]{"url", "login", "password", "sslKeyName"}).withValues((Object[])new String[]{(String)PrimitiveAssociationSemantics.get((Entity)JiraRestApi.this.getJis(), (String)"jiraUrl", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)JiraRestApi.this.getJis(), (String)"jiraLogin", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)JiraRestApi.this.getJis(), (String)"jiraPassword", String.class, null), !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)JiraRestApi.this.getJis(), (String)"sslKey"), null) ? (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)JiraRestApi.this.getJis(), (String)"sslKey"), (String)"name", String.class, null) : null});
            }
        });
        ((ObsoleteImportScriptRunner)ServiceLocator.getBean((String)"importScriptRunner")).run(TEST_CONNECTION_SCRIPT_FULL_NAME, (AbstractEvaluationParameters)new SimpleEvalParams((Map)params.value), (EvaluationStatus)this.status);
        if (this.status.isFailed()) {
            if (this.status.getOutput("timedOut") != null) {
                this.connectionError = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("JiraRestApi.Connection_timed_out", new Object[0]);
            }
            return;
        }
        if (!((Boolean)this.status.getOutput("version5plus")).booleanValue()) {
            this.connectionError = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("JiraRestApi.Incompatible_Jira_version_only_Jira_5_is_allowed", new Object[0]);
            return;
        }
        this.connectionError = this.status.getOutput("testResult") == null ? null : this.status.getOutput("testResult").toString();
        this.hasAdmPerm = this.status.getOutput("hasAdminPermission") == null ? false : (Boolean)this.status.getOutput("hasAdminPermission");
        Object projects = this.status.getOutput("projects");
        this.projects = projects != null ? ListSequence.fromList((List)((List)projects)).select((_FunctionTypes._return_P1_E0)new ISelector<Object, Map<String, Object>>(){

            public Map<String, Object> select(Object it) {
                return (Map)it;
            }
        }).select((_FunctionTypes._return_P1_E0)new ISelector<Map<String, Object>, ProjectInfo>(){

            public ProjectInfo select(Map<String, Object> project) {
                return new ProjectInfo((String)MapSequence.fromMap(project).get((Object)"key"), (String)MapSequence.fromMap(project).get((Object)"name"), (Iterable<ProjectPermissionInfo>)MapSequence.fromMap((Map)((Map)MapSequence.fromMap(project).get((Object)"$permissions"))).select((_FunctionTypes._return_P1_E0)new ISelector<IMapping<String, Boolean>, ProjectPermissionInfo>(){

                    public ProjectPermissionInfo select(IMapping<String, Boolean> it) {
                        return new ProjectPermissionInfo((String)it.key(), (Boolean)it.value());
                    }
                }));
            }
        }) : Sequence.fromIterable(Collections.emptyList());
    }

    @Override
    public void stopImport() {
        ((ObsoleteImportScriptRunner)ServiceLocator.getBean((String)"importScriptRunner")).stop(IMPORT_SCRIPT_FULL_NAME);
    }

    public boolean isRest() {
        return true;
    }

    @Override
    public void startImport() {
        ((Executor)ServiceLocator.getBean((String)"quartzThreadExecutor")).execute(new Runnable(){

            @Override
            public void run() {
                PersistentEvalParamsAdapter params = new PersistentEvalParamsAdapter(AssociationSemantics.getToOne((Entity)JiraRestApi.this.getJimp(), (String)"params"));
                params.put("issuesBulkSize", System.getProperty("jetbrains.youtrack.import.issuesBulkSize", "50"));
                ((ObsoleteImportScriptRunner)ServiceLocator.getBean((String)"importScriptRunner")).run(IMPORT_SCRIPT_FULL_NAME, (AbstractEvaluationParameters)params, (EvaluationStatus)new PersistentEvalStatusAdapter(JiraRestApi.this.getJimp(), AssociationSemantics.getToOne((Entity)JiraRestApi.this.getJimp(), (String)"status")));
            }
        });
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        if (((UserActionJobContainer)ServiceLocator.getBean((String)"userActionJobContainer")).getNotFinishedJobForParams(new Entity[]{this.getJis()}) != null) {
            return ConnectionStatus.CLEARING;
        }
        if (this.status == null) {
            return ConnectionStatus.UNKNOWN;
        }
        if (this.connectionError != null) {
            return ConnectionStatus.FAILED;
        }
        if (this.status.isFailed()) {
            return ConnectionStatus.CANCELLED;
        }
        if (this.projects == null) {
            return ConnectionStatus.PENDING;
        }
        return ConnectionStatus.OK;
    }

    public Entity getJis() {
        return this.myJis;
    }

    public void setJis(Entity value) {
        this.myJis = value;
    }

    public Entity getJimp() {
        return this.myJimp;
    }

    public void setJimp(Entity value) {
        this.myJimp = value;
    }

    public static boolean isNotEmpty_9dx9fg_a0a0a0a8(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_9dx9fg_a0a0a0i(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_9dx9fg_a0a0a8(String str) {
        return str != null && str.length() > 0;
    }
}

