<#escape x as x?html>
<html>
    <#include "markup_styles.ftl">
    <#assign after = change.after>
    <#assign before = change.before>
    <p style="font-size: 14px;
              color: #000000;
              margin: 0.5em 0 0.4em 0;">
        <#if only_via_duplicate><@l10n>Ein Duplikat eines Tickets auf Ihrer Beobachtungsliste wurde geändert.</@l10n></#if>
        <#assign priority = change.after.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000">
        <#else>
            <#assign issueTypeStyle = "">
        </#if>
        <#assign type = after.Type>
        <#if from==to>
            <#if type?has_content>
                <@l10n>
                    <em style="${issueTypeStyle}">${type}</em> wurde von <em>Ihnen</em>
                    aktualisiert in Projekt <em>${after.project.name}</em> am ${change.getWhen(to)}.
                </@l10n>
            <#else>
                <@l10n>
                    <em style="${issueTypeStyle}">Ticket</em> wurde von <em>Ihnen</em>
                    aktualisiert in Projekt <em>${after.project.name}</em> am ${change.getWhen(to)}.
                </@l10n>
            </#if>
        <#else>
            <#if type?has_content>
                <@l10n>
                    <em style="${issueTypeStyle}">${type}</em> wurde von <em>${from.getVisibleName()}</em>
                    aktualisiert in Projekt <em>${after.project.name}</em> am ${change.getWhen(to)}.
                </@l10n>
            <#else>
                <@l10n>
                    <em style="${issueTypeStyle}">Ticket</em> wurde von <em>${from.getVisibleName()}</em>
                    aktualisiert in Projekt <em>${after.project.name}</em> am ${change.getWhen(to)}.
                </@l10n>
            </#if>
        </#if>
        <#if after.isResolved() && before?has_content && !before.isResolved()>
            <#assign duplicate = Utils.getDuplicate(after)>
            <#if duplicate?has_content>
                <@l10n>Ticket wurde als Duplikat von <a href="${Utils.getUrl(duplicate)}">${duplicate.getId()}</a> gelöst.</@l10n>
           <#else>
                <#assign state = after.State>
                <#if state?has_content && !(state?is_enumerable)>
                    <@l10n>Ticket wurde mit dem Status ${state} gelöst.</@l10n>
                <#else>
                    <@l10n>Ticket wurde gelöst.</@l10n>
                </#if>
            </#if>
        </#if>
    </p>
    <div style="background-color: #efefef">
        <#include "issue_header.ftl">
    </div>
    <#include "issue_change.ftl">
    <#include "footer.ftl">
</html>
</#escape>