<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>

    <#if reason.message?has_content>
        <@l10n>You (<b>${to.login}</b>) received this message because ${reason.message}.</@l10n>
    <#else>
        <#assign tagsCount = reason.tagReasons?size>
        <#assign savedSearchesCount = reason.savedSearchReasons?size>
        <#assign mentionsCount = reason.mentionReasons?size>
        <#assign onlyMention = (savedSearchesCount == 0) && (tagsCount == 0)>

        <#if onlyMention>
            <#if only_via_duplicate>
                <@l10n>
                    You (<b>${to.login}</b>) received this message because you had enabled the option
                    <b>Receive notifications on changes in duplicates cluster</b> and you were <b>mentioned</b>.
                </@l10n>
            <#else>
                <@l10n>
                    You (<b>${to.login}</b>) received this message because you were <b>mentioned</b>.
                </@l10n>
            </#if>
        <#else>
            <#if only_via_duplicate>
                <@l10n>
                    You (<b>${to.login}</b>) received this message because you had enabled the option
                    <b>Receive notifications on changes in duplicates cluster</b> and notifications for:
                </@l10n>
            <#else>
                <@l10n>
                    You (<b>${to.login}</b>) received this message because you had enabled notifications for:
                </@l10n>
            </#if>

            <@l10n>
            <#list reason.savedSearchReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (savedSearchesCount > 1)>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            saved searches;
                        <#else>
                            saved searches.
                        </#if>
                    <#else>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            saved search;
                        <#else>
                            saved search.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <@l10n>
            <#list reason.tagReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (tagsCount > 1)>
                        <#if (mentionsCount > 0)>
                            tags;
                        <#else>
                            tags.
                        </#if>
                    <#else>
                        <#if (mentionsCount > 0)>
                            tag;
                        <#else>
                            tag.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <#if (mentionsCount > 0) >
                <@l10n><b>@Mention</b> in a comment or an issue description.</@l10n>
            </#if>
        </#if>
    </#if>
    <@l10n>To unsubscribe, you can
    <a href="${Utils.getSettingUrlWithMute(to,issue)}">mute notifications for this issue</a> or
    <a href="${Utils.getSettingUrl(to)}">edit your notification preferences.</a></@l10n>
</#escape>