<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>

    <#if reason.message?has_content>
        <@l10n>Vous (<b>${to.login}</b>) avez reçu ce message parce que ${reason.message}.</@l10n>
    <#else>
        <#assign tagsCount = reason.tagReasons?size>
        <#assign savedSearchesCount = reason.savedSearchReasons?size>
        <#assign mentionsCount = reason.mentionReasons?size>
        <#assign onlyMention = (savedSearchesCount == 0) && (tagsCount == 0)>

        <#if onlyMention>
            <#if only_via_duplicate>
                <@l10n>
                    Vous (<b>${to.login}</b>) avez reçu ce message parce que vous avez activé l'option
                    <b>Recevoir des notifications lors de modifications dans le cluster de doublons</b> et que vous étiez <b>mentionné</b>.
                </@l10n>
            <#else>
                <@l10n>
                    Vous (<b>${to.login}</b>) avez reçu ce message parce que vous étiez <b>mentionné</b>.
                </@l10n>
            </#if>
        <#else>
            <#if only_via_duplicate>
                <@l10n>
                    Vous (<b>${to.login}</b>) avez reçu ce message parce que vous avez activé l'option
                    <b>Recevoir des notifications lors de modifications dans le cluster de doublons</b> et les notifications pour :
                </@l10n>
            <#else>
                <@l10n>
                    Vous (<b>${to.login}</b>) avez reçu ce message parce que vous avez activé les notifications pour :
                </@l10n>
            </#if>

            <@l10n>
            <#list reason.savedSearchReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (savedSearchesCount > 1)>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            recherches enregistrées ;
                        <#else>
                            recherches enregistrées.
                        </#if>
                    <#else>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            recherche enregistrée ;
                        <#else>
                            recherche enregistrée.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <@l10n>
            <#list reason.tagReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (tagsCount > 1)>
                        <#if (mentionsCount > 0)>
                            balises ;
                        <#else>
                            balises.
                        </#if>
                    <#else>
                        <#if (mentionsCount > 0)>
                            balise ;
                        <#else>
                            balise .
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <#if (mentionsCount > 0) >
                <@l10n><b>@Mention</b> dans un commentaire ou une description de ticket.</@l10n>
            </#if>
        </#if>
    </#if>
    <@l10n>Pour vous désinscrire, vous pouvez 
    <a href="${Utils.getSettingUrlWithMute(to,issue)}">rendre les notifications silencieuses pour ce ticket</a> ou
    <a href="${Utils.getSettingUrl(to)}">modifier vos préférences de notification.</a></@l10n>
</#escape>