<#ftl attributes={"description":"Overview of the issue update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text}
                margin: 14px 0 19px ${styles.icon_width}px;">
        <#assign bold = "font-weight: bold;">
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000;" + bold>
        <#else>
            <#assign issueTypeStyle = bold>
        </#if>
        <#assign type = issue.Type>
        <#assign time = change.getWhen()>
        <#if type?has_content>
            <#assign issueName = type>
        <#else>
            <#assign issueName = "Issue">
        </#if>
        <#if change.hasEvent("CREATED")>
            <#if type?has_content>
                <@l10n>新しい<span style="${issueTypeStyle}">${type}</span>がプロジェクト<span style="${bold}">${issue.project.name}</span>に作成されました</@l10n>
            <#else>
                <@l10n>新しい<span style="${issueTypeStyle}">課題</span>がプロジェクト<span style="${bold}">${issue.project.name}</span>に作成されました</@l10n>
            </#if>
        <#else>
            <#if from==to>
                <#if type?has_content>
                    <@l10n>
                        プロジェクト${issue.project.name}で<span style="${bold}">あなた</span>が
                        ${time}に<span style="${issueTypeStyle}">${type}</span>を更新しました。
                    </@l10n>
                <#else>
                    <@l10n>
                        プロジェクト${issue.project.name}で<span style="${bold}">あなた</span>が
                        ${time}に<span style="${issueTypeStyle}">課題</span>を更新しました。
                    </@l10n>
                </#if>
            <#else>
                <#if type?has_content>
                    <@l10n>
                        プロジェクト${issue.project.name}で<span style="${bold}">${from.getVisibleName()}</span>さんが
                        ${time}に<span style="${issueTypeStyle}">${type}</span>を更新しました。
                    </@l10n>
                <#else>
                    <@l10n>
                        プロジェクト${issue.project.name}で<span style="${bold}">${from.getVisibleName()}</span>さんが
                        ${time}に<span style="${issueTypeStyle}">課題</span>を更新しました。
                    </@l10n>
                </#if>
            </#if>
        </#if>
    </div>
</#escape>