<#escape x as x?html>
<html>
    <#include "markup_styles.ftl">
    <p style="font-size: 14px;
              color: #000000;
              margin: 0.5em 0 0.4em 0;">
        <#if only_via_duplicate><@l10n>あなたがウォッチしている課題の複製が変更されました。</@l10n></#if>
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000">
        <#else>
            <#assign issueTypeStyle = "">
        </#if>
        <#assign type = issue.Type>
        <#if from == to>
            <#if type?has_content>
                <@l10n>
                    プロジェクト<em>${issue.project.name}</em>で
                    <em style="${issueTypeStyle}">${type}</em>が自分自身に割り当てられました
                </@l10n>
            <#else>
                <@l10n>
                    プロジェクト<em>${issue.project.name}</em>で
                    <em style="${issueTypeStyle}">課題</em>が自分自身に割り当てられました
                </@l10n>
            </#if>
        <#else>
            <#if type?has_content>
                <@l10n>
                    プロジェクト<em>${issue.project.name}</em>で
                    <em style="${issueTypeStyle}">${type}</em>が${from.getVisibleName()}さんによって<em>あなた</em>に割り当てられました
                </@l10n>
            <#else>
                <@l10n>
                    プロジェクト<em>${issue.project.name}</em>で<em style="${issueTypeStyle}">課題</em>が${from.getVisibleName()}さんによって
                    <em>あなた</em>に割り当てられました
                </@l10n>
            </#if>
        </#if>
    </p>
    <div style="background-color: #efefef">
        <#include "issue_header.ftl">
    </div>
    <#if change.before?has_content>
        <#include "issue_change.ftl">
    <#else>
        <#include "issue.ftl">
    </#if>
    <#include "footer.ftl">
</html>
</#escape>