<#escape x as x?html>
<html>
    <#import "styles.ftl" as styles>

    <table style="${styles.table} margin: 16px 0;">
        <tr>
            <td style="width: ${styles.icon_width}px;
                       padding: 0;
                       vertical-align: top;">
                <div style="padding: 2px 0 0 14px;">
                    <#include "icon_warning.ftl">
                </div>
            </td>
            <td style="padding: 0; vertical-align: top;">
                <div style="${styles.overview_text}">
                    <@l10n>
                        On ${vcsChange.humanReadableDate}, YouTrack processed a change that was applied by the VCS user <b>${vcsChange.userName}</b>.
                        The commit message contains a command that references an issue in the ${issue.project.name} project.
                        Unfortunately, the referenced issue was not updated because of the following problem:
                    </@l10n>
                        <br/>
                    <#assign noUserReason = vcsChange.noUserReason>
                    <#if noUserReason?has_content>
                        ${noUserReason}
                    <#else>
                        <@l10n>YouTrack couldn't find a user account that matches the change author for an unknown reason</@l10n>
                    </#if>
                </div>
            </td>
        </tr>
    </table>

    <#include "issue_header.ftl">

    <div style="margin-top: 16px">
        <table style="${styles.table} background: #f0f0f0;">
            <tr>
                <td style="${styles.event_title};">
                    <#include "icon_cross.ftl">
                </td>
                <td style="padding: 12px 0;">
                    ${vcsChange.text}
                </td>
                <td style="padding: 12px 16px;">
                    <a title="${issue.project.name}"
                       style="color: #1466c6; float: right;"
                       href="${vcsChange.changeUrl}">
                        ${vcsChange.version}
                    </a>
                </td>
            </tr>
        </table>
    </div>
    <div style="margin-left: ${styles.icon_width}px; padding: 4px 0 8px;">
	    <#include "vcs_failure_footer.ftl">
    </div>
</html>
</#escape>