<#ftl attributes={"description":"Overview of the issue update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text}
                margin: 14px 0 19px ${styles.icon_width}px;">
        <#assign bold = "font-weight: bold;">
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000;" + bold>
        <#else>
            <#assign issueTypeStyle = bold>
        </#if>
        <#assign type = issue.Type>
        <#assign time = change.getWhen()>
        <#if type?has_content>
            <#assign issueName = type>
        <#else>
            <#assign issueName = "Issue">
        </#if>
        <#if change.hasEvent("CREATED")>
            <#if type?has_content>
                <@l10n>Новая задача (<span style="${issueTypeStyle}">${type}</span>) в проекте <span style="${bold}">${issue.project.name}</span></@l10n>
            <#else>
                <@l10n>Новая <span style="${issueTypeStyle}">задача</span> в проекте <span style="${bold}">${issue.project.name}</span></@l10n>
            </#if>
        <#else>
            <#if from==to>
                <#if type?has_content>
                    <@l10n>
                        Задача (<span style="${issueTypeStyle}">${type}</span>) была обновлена <span style="${bold}">вами</span>
                        в проекте ${issue.project.name} в ${time}.
                    </@l10n>
                <#else>
                    <@l10n>
                        <span style="${issueTypeStyle}">Задача</span> была обновлена <span style="${bold}">вами</span>
                        в проекте ${issue.project.name} в ${time}.
                    </@l10n>
                </#if>
            <#else>
                <#if type?has_content>
                    <@l10n>
                        Задача (<span style="${issueTypeStyle}">${type}</span>) была обновлена пользователем <span style="${bold}">${from.getVisibleName()}</span>
                        в проекте ${issue.project.name} в ${time}.
                    </@l10n>
                <#else>
                    <@l10n>
                        <span style="${issueTypeStyle}">Задача</span> была обновлена пользователем <span style="${bold}">${from.getVisibleName()}</span>
                        в проекте ${issue.project.name} в ${time}.
                    </@l10n>
                </#if>
            </#if>
        </#if>
    </div>
</#escape>