/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.persistence.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.youtrack.mailbox.persistence.XdMailboxRule;
import jetbrains.youtrack.mailbox.persistence.listeners.MailRuleRegexValidator$updatedSyncBeforeConstraints$1;
import jetbrains.youtrack.persistent.listeners.LocalXdListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0012\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/mailbox/persistence/listeners/MailRuleRegexValidator;", "Ljetbrains/youtrack/persistent/listeners/LocalXdListener;", "Ljetbrains/youtrack/mailbox/persistence/XdMailboxRule;", "()V", "addedSyncBeforeConstraints", "", "added", "updatedSyncBeforeConstraints", "old", "current", "validateRegex", "regexList", "", "Companion", "youtrack-mailbox"})
public final class MailRuleRegexValidator
extends LocalXdListener<XdMailboxRule> {
    public static final Companion Companion = new Companion(null);

    public void updatedSyncBeforeConstraints(@NotNull XdMailboxRule old, @NotNull XdMailboxRule current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        if (ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)MailRuleRegexValidator$updatedSyncBeforeConstraints$1.INSTANCE))) {
            this.validateRegex(current.getAutoReplyRegexes());
        }
    }

    public void addedSyncBeforeConstraints(@NotNull XdMailboxRule added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        this.validateRegex(added.getAutoReplyRegexes());
    }

    /*
     * WARNING - void declaration
     */
    private final void validateRegex(String regexList) {
        Object object = regexList;
        if (object != null && (object = StringsKt.lines((CharSequence)((CharSequence)object))) != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv = (Iterable)object;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                CharSequence charSequence = it;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                String pattern = (String)element$iv;
                try {
                    Pattern.compile(pattern);
                }
                catch (PatternSyntaxException e) {
                    Companion.getLogger().info("Invalid mailbox rule regex pattern detected: " + e.getMessage());
                    throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Not a valid regex pattern: " + pattern, null, 2, null));
                }
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/mailbox/persistence/listeners/MailRuleRegexValidator$Companion;", "Lmu/KLogging;", "()V", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

