/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.persistent;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueCommentImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.persistent.IssueTagImpl;
import jetbrains.charisma.smartui.watchFolder.StarService;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.CommandService;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.service.MarkupRenderFactory;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.statistics.StatisticsService;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.mailbox.fetch.AttachmentCollectorPartsVisitor;
import jetbrains.youtrack.mailbox.fetch.EmailFetcher;
import jetbrains.youtrack.mailbox.fetch.FetchedMessage;
import jetbrains.youtrack.mailbox.fetch.MessageIdUtils;
import jetbrains.youtrack.mailbox.fetch.SubjectParser;
import jetbrains.youtrack.mailbox.notifications.NotificationsService;
import jetbrains.youtrack.mailbox.persistent.AutoCreateUserPolicyImpl;
import jetbrains.youtrack.mailbox.persistent.DefaultUserPolicyImpl;
import jetbrains.youtrack.mailbox.persistent.FromPolicyImpl;
import jetbrains.youtrack.mailbox.persistent.MailboxFetcher;
import jetbrains.youtrack.mailbox.persistent.MailboxImpl;
import jetbrains.youtrack.mailbox.persistent.MailboxLifecycle;
import jetbrains.youtrack.mailbox.persistent.PredefinedUserPolicyImpl;
import jetbrains.youtrack.mailbox.persistent.SeenMessageStatusImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeFieldType;
import webr.framework.url.UrlUtil;

public class MailRuleImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "MailRule";
    public static final String FROM_VARIABLE = "${from}";
    public static final String REPLY_TO_VARIABLE = "${reply-to}";
    public static final String TO_VARIABLE = "${to}";
    public static final String CC_VARIABLE = "${cc}";
    protected static Log log = LogFactory.getLog(MailRuleImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        AggregationAssociationSemantics.setManyToOne((Entity)QueryOperations.getFirst((Iterable)QueryOperations.queryGetAll((String)"Mailbox")), (String)"rules", (String)"mailbox", (Entity)entity);
        if (!EntityOperations.equals((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), null)) {
            DirectedAssociationSemantics.setToOne((Entity)entity, (String)"maintainer", (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
        }
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"filterAutoReplies", (Comparable)Boolean.valueOf(true), Boolean.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"filterByRegexes", (Comparable)Boolean.valueOf(true), Boolean.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"starRecipients", (Comparable)Boolean.valueOf(true), Boolean.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"deleteAfterFetch", (Comparable)Boolean.valueOf(false), Boolean.class);
        AggregationAssociationSemantics.setOneToOne((Entity)entity, (String)"fromPolicy", (String)"mailMapping", (Entity)AutoCreateUserPolicyImpl.constructor());
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"fewUsersWarning", (Comparable)Boolean.valueOf(false), Boolean.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"originalTimestamps", (Comparable)Boolean.valueOf(true), Boolean.class);
        return entity;
    }

    public String getWarningText(Entity entity) {
        String logName = ConfigurationUtil.isYoutrackHosted() ? "<a href='" + UrlUtil.getActionUrl((String)"ExportLog", (String)"exportMailboxLog", (boolean)true, (boolean)true, (QueryParameter[])new QueryParameter[0]) + "'>mailbox.log</a>" : "'mailbox.log'";
        String result = "";
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"checkLogWarning", Boolean.class, null)).booleanValue()) {
            result = result + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MailRule.There_were_problems_with_processing_one_or_more_e-mail_messages_during_last_fetch", new Object[0]) + "<br/>" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MailRule.Please_check_{mailbox}_for_details", new Object[]{logName});
        }
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"checkLogWarning", Boolean.class, null)).booleanValue() && ((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fewUsersWarning", Boolean.class, null)).booleanValue()) {
            result = result + "<br/>";
        }
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fewUsersWarning", Boolean.class, null)).booleanValue()) {
            result = result + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MailRule.You_are_running_out_of_user_account_slots_allowed_by_your_license", new Object[0]) + "<br/>" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MailRule.Please_check_mailbox_integration_parameters_<br/>you_might_want_to_change_Reporter_settings_of_Mail_rule", new Object[0]);
        }
        return result;
    }

    public void process(EmailFetcher folderFetcher, final Entity entity) {
        final Wrappers._boolean needToCheckLog = new Wrappers._boolean(false);
        final MailboxFetcher fetcher = new MailboxFetcher(AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"));
        folderFetcher.foreachMessage((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"folder", String.class, null), (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"deleteAfterFetch", Boolean.class, null) == false, (_FunctionTypes._return_P1_E0<? extends Boolean, ? super Message>)new _FunctionTypes._return_P1_E0<Boolean, Message>(){

            public Boolean invoke(Message message) {
                boolean processed;
                block10: {
                    String id;
                    processed = false;
                    try {
                        id = MessageIdUtils.getMessageId(message);
                    }
                    catch (FolderClosedException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Folder was closed.Interrupting fetching mailbox " + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"), (String)"host", String.class, null) + " and folder " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"folder", String.class, null)), (Throwable)e);
                        }
                        ((MailboxLifecycle)ServiceLocator.getBean((String)"mailboxLifecycle")).cancel(AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"));
                        return false;
                    }
                    if (MailRuleImpl.this.isAcceptable(fetcher, id, message, entity)) {
                        FetchedMessage fetchedMessage = null;
                        try {
                            fetchedMessage = new FetchedMessage(message, id, (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"doNotDiscardBracketsContents", Boolean.class, null) == false);
                            if (MailRuleImpl.this.processMessage(fetcher, fetchedMessage, entity)) {
                                if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"deleteAfterFetch", Boolean.class, null)).booleanValue()) {
                                    message.setFlag(Flags.Flag.DELETED, true);
                                }
                                processed = true;
                            }
                        }
                        catch (Exception e) {
                            needToCheckLog.value = true;
                            DnqUtils.getCurrentTransientSession().revert();
                            ((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"), (String)"Mailbox")).updateStatus(new LocalizationObject("MailRule.Error_on_fetching_messages_for_store_associated_with_project_{0}", new Object[]{PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"name", String.class, (Object)IssueFolderImpl.getNullName())}), e, AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"));
                            if (fetchedMessage == null || !(e instanceof MessagingException)) break block10;
                            try {
                                ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).invalidEmailFormat(fetcher, fetchedMessage, (MessagingException)((Object)e), entity);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                return processed;
            }
        });
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"checkLogWarning", (Comparable)Boolean.valueOf(needToCheckLog.value), Boolean.class);
        DnqUtils.getCurrentTransientSession().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMessage(MailboxFetcher fetcher, FetchedMessage message, Entity entity) throws MessagingException {
        try {
            ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).checkFromField(message, entity);
        }
        catch (MessagingException e) {
            ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).invalidEmailFormat(fetcher, message, e, entity);
            return false;
        }
        if (((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).isFilteredMessage(message, entity)) {
            ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).registerFilteredMessage(fetcher, message, entity);
            return false;
        }
        Tuples._2<Entity, String> author = this.resolveAuthor(message, entity);
        if (EntityOperations.equals((Entity)((Entity)author._0()), null)) {
            ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).unresolvedAuthor(fetcher, message, entity);
            return false;
        }
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)author._0()), (String)"User")).isBanned((Entity)author._0())) {
            ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).bannedAuthor(fetcher, message, (Entity)author._0(), entity);
            return false;
        }
        Entity issue = this.findAssociatedIssue(fetcher, message, entity);
        try {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal(author._0());
            if (this.isYoutrackNotification(message, entity)) {
                ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).attachYoutrackNotification(fetcher, message, issue, entity);
                boolean bl = true;
                return bl;
            }
            if (!EntityOperations.equals((Entity)issue, null) && this.isAutoReply(message, entity)) {
                ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).attachAutoReply(fetcher, message, issue, entity);
                boolean bl = false;
                return bl;
            }
            if (!EntityOperations.equals((Entity)issue, null) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)author._0()), (String)"User")).hasPermission(Permission.CREATE_COMMENT, AssociationSemantics.getToOne((Entity)entity, (String)"project"), (Entity)author._0()) && ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isAccessible(Operation.READ, (Entity)author._0(), issue)) {
                ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance((StatisticsFeatureDescription)ServiceLocator.getBean((String)"createdComment"));
                boolean bl = this.createComment(fetcher, (Entity)author._0(), (String)author._1(), issue, message, entity);
                return bl;
            }
            if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)author._0()), (String)"User")).hasPermission(Permission.CREATE_ISSUE, AssociationSemantics.getToOne((Entity)entity, (String)"project"), (Entity)author._0())) {
                ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance((StatisticsFeatureDescription)ServiceLocator.getBean((String)"createdIssue"));
                boolean bl = this.createIssue(fetcher, (Entity)author._0(), (String)author._1(), message, entity);
                return bl;
            }
            ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).noPermissionsUser(fetcher, message, AssociationSemantics.getToOne((Entity)entity, (String)"maintainer"), (Entity)author._0(), AssociationSemantics.getToOne((Entity)entity, (String)"project"), entity);
            boolean bl = false;
            return bl;
        }
        finally {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
        }
    }

    private void checkFromField(FetchedMessage message, Entity entity) throws MessagingException {
        message.getMessage().getFrom();
    }

    private boolean isAcceptable(MailboxFetcher fetcher, String id, Message message, Entity entity) {
        try {
            if (!this.matchesTo(message, entity)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"), (String)"Mailbox")).toDebugString(AssociationSemantics.getToOne((Entity)entity, (String)"mailbox")) + "[Message] [" + id + "] -X message recipients doesn't match 'to' filter"));
                }
                return false;
            }
        }
        catch (MessagingException exception) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"), (String)"Mailbox")).toDebugString(AssociationSemantics.getToOne((Entity)entity, (String)"mailbox")) + "[Message] [" + id + "] -X corrupted message"), (Throwable)exception);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Full stack trace", (Throwable)exception);
            }
            return false;
        }
        Entity seenMessage2 = fetcher.findMessage(id);
        if (!EntityOperations.equals((Entity)seenMessage2, null) && !((Boolean)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)seenMessage2, (String)"status"), (String)"retry", Boolean.class, (Object)false)).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"), (String)"Mailbox")).toDebugString(AssociationSemantics.getToOne((Entity)entity, (String)"mailbox")) + "[Message] [" + id + "] -X already fetched, refetching is prohibited"));
            }
            return false;
        }
        return true;
    }

    private boolean matchesTo(Message m, final Entity entity) throws MessagingException {
        boolean matches = true;
        if (MailRuleImpl.isNotEmpty_ns4w0p_a0b0h((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"to", String.class, null))) {
            matches = false;
            Object[] recipients = m.getRecipients(Message.RecipientType.TO);
            if (recipients != null) {
                matches = Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])recipients)).any((_FunctionTypes._return_P1_E0)new IWhereFilter<Address>(){

                    public boolean accept(Address it) {
                        String address = ((InternetAddress)it).getAddress();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"), (String)"Mailbox")).toDebugString(AssociationSemantics.getToOne((Entity)entity, (String)"mailbox")) + "Checking recipient <" + address + "> against the filter <" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"to", String.class, null) + ">"));
                        }
                        return address.equalsIgnoreCase(((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"to", String.class, null)).trim());
                    }
                });
            }
        }
        return matches;
    }

    private boolean isAutoReply(FetchedMessage message, Entity entity) throws MessagingException {
        boolean autoreply = false;
        Message m = message.getMessage();
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"filterAutoReplies", Boolean.class, null)).booleanValue()) {
            if (MailRuleImpl.headerMatches(m, "From", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.contains("mailer-daemon@") || header2.startsWith("System Administrator");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "Auto-Submitted", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.contains("auto-");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "Precedence", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.equals("auto_reply");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "X-Precedence", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.equals("auto_reply");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "X-Autorespond", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return true;
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "X-Autogenerated", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.equals("Forward") || header2.equals("Group") || header2.equals("Letter") || header2.equals("Mirror") || header2.equals("Redirect") || header2.equals("Reply");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "X-FC-MachineGenerated", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.equals("true");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "X-Mail-Autoreply", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return true;
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "X-Autoreply", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return true;
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "X-POST-MessageClass", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.equals("9; Autoresponder");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "Delivered-To", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.equals("Autoresponder");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "Content-Type", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.equalsIgnoreCase("multipart/report; report-type=delivery-status");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "Subject", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return header2.startsWith("Delivery Status Notification") || header2.startsWith("Undeliverable") || header2.startsWith("Returned Mail:") || header2.contains("autoreply") || header2.contains("Account signup");
                }
            })) {
                autoreply = true;
            } else if (MailRuleImpl.headerMatches(m, "X-Charisma", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return true;
                }
            }) || MailRuleImpl.headerMatches(m, "X-Mailer", (_FunctionTypes._return_P1_E0<? extends Boolean, ? super String>)new _FunctionTypes._return_P1_E0<Boolean, String>(){

                public Boolean invoke(String header2) {
                    return "YouTrack".equals(header2);
                }
            })) {
                autoreply = true;
            }
        }
        return autoreply;
    }

    private boolean isFilteredMessage(FetchedMessage message, Entity entity) throws MessagingException {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"filterByRegexes", Boolean.class, null)).booleanValue() && PrimitiveAssociationSemantics.get((Entity)entity, (String)"autoReplyRegexes", String.class, null) != null) {
            String[] regexes;
            for (String regex : regexes = ((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"autoReplyRegexes", String.class, null)).split("\n")) {
                Pattern p = Pattern.compile(regex);
                Matcher matcher = p.matcher(message.getSubject());
                if (matcher.find()) {
                    return true;
                }
                String text = message.getStrippedTextBody(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getFromEmails(message, entity), (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"plainTextDescription", Boolean.class, null));
                try {
                    text = ((MarkupRenderFactory)ServiceLocator.getBean((String)"markupRenderFactory")).createBuilder().removeMarkup(text);
                    text = ((MarkupRenderFactory)ServiceLocator.getBean((String)"markupRenderFactory")).createBuilder().markdown(true).removeMarkup(text);
                    matcher = p.matcher(text);
                    if (!matcher.find()) continue;
                    return true;
                }
                catch (Throwable t) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Cannot unwikify message text: " + text.substring(0, 4096) + "..."), t);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isYoutrackNotification(FetchedMessage message, Entity entity) {
        try {
            String id = MessageIdUtils.getMessageId(message.getMessage());
            return id == null ? false : ((jetbrains.youtrack.api.notifications.MessageIdUtils)ServiceLocator.getBean((String)"messageIdUtils")).isYoutrackGeneratedMessageId(id);
        }
        catch (FolderClosedException e) {
            return false;
        }
    }

    private Entity findAssociatedIssue(MailboxFetcher fetcher, FetchedMessage message, Entity entity) throws MessagingException {
        for (String relatedId : Sequence.fromIterable(message.getRelatedIds()).concat(Sequence.fromIterable((Iterable)Sequence.singleton((Object)message.getId())))) {
            Entity seenMessage2 = fetcher.findRelatedMessage(relatedId);
            Entity seenMessageIssue = !EntityOperations.equals((Entity)seenMessage2, null) ? AssociationSemantics.getToOne((Entity)seenMessage2, (String)"issue") : null;
            if (EntityOperations.equals((Entity)seenMessageIssue, null) || ((Boolean)PrimitiveAssociationSemantics.get((Entity)seenMessageIssue, (String)"deleted", Boolean.class, null)).booleanValue()) continue;
            return seenMessageIssue;
        }
        Iterable projects = QueryOperations.union((Iterable)QueryOperations.singleton((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project")), (Iterable)Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"Project")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Project")).isArchived(it);
            }
        }));
        Entity issue = null;
        for (Entity project : projects) {
            String issueId;
            if (!EntityOperations.equals(issue, null) || (issueId = SubjectParser.getSubjectIssueId((String)PrimitiveAssociationSemantics.get((Entity)project, (String)"shortName", String.class, null), message.getRawSubject())) == null || issueId.length() <= 0) continue;
            issue = IssueImpl.fromId((String)issueId);
        }
        return issue;
    }

    private Tuples._2<Entity, String> resolveAuthor(FetchedMessage message, Entity entity) throws MessagingException {
        Tuples._2<Entity, String> author = ((FromPolicyImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"fromPolicy"), (String)"FromPolicy")).resolveUser(message.getFromName(), message.getFromEmail(), AssociationSemantics.getToOne((Entity)entity, (String)"fromPolicy"));
        if (EntityOperations.equals((Entity)((Entity)author._0()), null)) {
            ((NotificationsService)ServiceLocator.getBean((String)"mailboxNotificationService")).notifyCantResolveUser(AssociationSemantics.getToOne((Entity)entity, (String)"project"), message, AssociationSemantics.getToOne((Entity)entity, (String)"maintainer"));
        }
        return author;
    }

    private String getDebugInfo(FetchedMessage message, Entity entity) {
        return ((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"mailbox"), (String)"Mailbox")).toDebugString(AssociationSemantics.getToOne((Entity)entity, (String)"mailbox")) + "[Message] " + message.toDebugString();
    }

    private boolean createIssue(MailboxFetcher fetcher, Entity author, String password2, FetchedMessage message, Entity entity) throws MessagingException {
        final Entity issue = IssueImpl.constructor((Entity)author, (Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"));
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"originalTimestamps", Boolean.class, null)).booleanValue() && DateTimeOperations.compare((Long)message.getRecievedDate(), (CompareType)CompareType.LT, (Long)((Long)PrimitiveAssociationSemantics.get((Entity)issue, (String)"created", null)), (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            PrimitiveAssociationSemantics.set((Entity)issue, (String)"created", (Comparable)message.getRecievedDate());
            PrimitiveAssociationSemantics.set((Entity)issue, (String)"updated", (Comparable)message.getRecievedDate());
        }
        final String summary = MailRuleImpl.isEmpty_ns4w0p_a0a0c0o(message.getSubject()) ? ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MailRule.Email_issue_from_{author_name}", new Object[]{PrimitiveAssociationSemantics.get((Entity)author, (String)"fullName", String.class, null)}) : message.getSubject();
        PrimitiveAssociationSemantics.set((Entity)issue, (String)"summary", (Comparable)((Object)summary), String.class);
        String wikiAdaptedTextBody = message.getBody((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"plainTextDescription", Boolean.class, null));
        AttachmentCollectorPartsVisitor attachmentsVisitor = message.getAttachments((Set<String>)SetSequence.fromSet(new HashSet()));
        if (attachmentsVisitor != null) {
            for (Entity attach : ListSequence.fromList(attachmentsVisitor.getAttachments())) {
                ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).addAttachment(attach, issue);
                wikiAdaptedTextBody = ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).replaceAttachRefs(wikiAdaptedTextBody, attach, attachmentsVisitor, entity);
            }
        }
        PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)issue, (String)"description", (String)wikiAdaptedTextBody);
        Entity linkedIssue = QueryOperations.getFirst((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"issues")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return summary.equals(PrimitiveAssociationSemantics.get((Entity)it, (String)"summary", String.class, null)) && !EntityOperations.equals((Entity)it, (Object)issue);
            }
        }));
        boolean couldNotLink = false;
        if (!EntityOperations.equals((Entity)linkedIssue, null)) {
            String command = "relates to " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)linkedIssue, (String)"Issue")).getId(linkedIssue);
            ICommandList commandList = ((CommandService)ServiceLocator.getBean((String)"commandService")).parse(command, issue);
            if (commandList.hasErrors()) {
                couldNotLink = true;
            } else {
                commandList.execute(false);
            }
        }
        boolean notifyAboutCommandFailure = ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).shouldNotifyAboutCommandFailure(fetcher, message, entity);
        if (this.applyCommand((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"newIssueCommand", String.class, null), issue, message, notifyAboutCommandFailure, entity)) {
            this.addWatchers(message, issue, entity);
            fetcher.issueCreated(message, issue);
            DnqUtils.getCurrentTransientSession().flush();
            if (log.isInfoEnabled()) {
                log.info((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -> created issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue)));
            }
            if (!EntityOperations.equals((Entity)linkedIssue, null) && couldNotLink && log.isWarnEnabled()) {
                log.warn((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " couldn't create link between " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " and " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)linkedIssue, (String)"Issue")).getId(linkedIssue)));
            }
            ((NotificationsService)ServiceLocator.getBean((String)"mailboxNotificationService")).notifyAboutIssue(issue, author, password2, AssociationSemantics.getToOne((Entity)entity, (String)"maintainer"), message, wikiAdaptedTextBody);
            return true;
        }
        DnqUtils.getCurrentTransientSession().revert();
        if (notifyAboutCommandFailure) {
            fetcher.commandFailed(message, (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"newIssueCommand", String.class, null));
            if (log.isWarnEnabled()) {
                log.warn((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -X didn't create issue, command [" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"newIssueCommand", String.class, null) + "] was not applied to just created issue"));
            }
            DnqUtils.getCurrentTransientSession().flush();
        }
        return false;
    }

    private boolean shouldNotifyAboutCommandFailure(MailboxFetcher fetcher, FetchedMessage message, Entity entity) {
        Entity seenMessage2 = fetcher.findMessage(message.getId());
        return EntityOperations.equals((Entity)seenMessage2, null) || !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)seenMessage2, (String)"status"), (Object)SeenMessageStatusImpl.COMMAND_FAILED.get());
    }

    private boolean createComment(MailboxFetcher fetcher, Entity author, String password2, Entity issue, FetchedMessage message, Entity entity) throws MessagingException {
        StringBuilder builder = new StringBuilder();
        if (MailRuleImpl.isNotEmpty_ns4w0p_a0a2a61(message.getSubject()) && !message.getSubject().endsWith((String)PrimitiveAssociationSemantics.get((Entity)issue, (String)"summary", String.class, null))) {
            builder.append("==").append(message.getSubject()).append("==\n");
        }
        String wikiAdaptedTextBody = message.getStrippedTextBody(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getFromEmails(message, entity), (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"plainTextDescription", Boolean.class, null));
        StringBuilder attachmentsBuilder = new StringBuilder();
        AttachmentCollectorPartsVisitor attachmentsVisitor = message.getAttachments((Set<String>)SetSequence.fromSetWithValues(new HashSet(), (Iterable)Sequence.fromIterable((Iterable)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getAttachments(issue)).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

            public String select(Entity it) {
                return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, null);
            }
        })));
        if (attachmentsVisitor != null) {
            for (Object attach : ListSequence.fromList(attachmentsVisitor.getAttachments())) {
                ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).addAttachment((Entity)attach, issue);
                attachmentsBuilder.append("[file:").append(((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)attach, (String)"PersistentFile")).getName((Entity)attach)).append("] ");
                wikiAdaptedTextBody = ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).replaceAttachRefs(wikiAdaptedTextBody, (Entity)attach, attachmentsVisitor, entity);
            }
        }
        builder.append(wikiAdaptedTextBody);
        if (builder.length() > 0) {
            Entity comment = IssueCommentImpl.constructor((String)builder.toString(), (Entity)author, (Entity)issue);
            if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"originalTimestamps", Boolean.class, null)).booleanValue() && DateTimeOperations.compare((Long)message.getRecievedDate(), (CompareType)CompareType.LT, (Long)((Long)PrimitiveAssociationSemantics.get((Entity)comment, (String)"created", null)), (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
                PrimitiveAssociationSemantics.set((Entity)comment, (String)"created", (Comparable)message.getRecievedDate());
            }
            if (attachmentsVisitor != null) {
                for (Entity attachment : ListSequence.fromList(attachmentsVisitor.getAttachments())) {
                    ((IssueCommentImpl)DnqUtils.getPersistentClassInstance((Entity)comment, (String)"IssueComment")).addAttachment(attachment, comment);
                }
            }
            boolean notifyAboutCommandFailure = ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).shouldNotifyAboutCommandFailure(fetcher, message, entity);
            if (this.applyCommand((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"newCommentCommand", String.class, null), issue, message, notifyAboutCommandFailure, entity)) {
                this.addWatchers(message, issue, entity);
                fetcher.commentCreated(message, comment);
                if (log.isInfoEnabled()) {
                    log.info((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -> created comment in issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)comment, (String)"issue"), (String)"Issue")).getId(AssociationSemantics.getToOne((Entity)comment, (String)"issue"))));
                }
                DnqUtils.getCurrentTransientSession().flush();
                if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"originalTimestamps", Boolean.class, null)).booleanValue()) {
                    PrimitiveAssociationSemantics.set((Entity)issue, (String)"updated", (Comparable)message.getRecievedDate());
                    DnqUtils.getCurrentTransientSession().flush();
                }
                ((NotificationsService)ServiceLocator.getBean((String)"mailboxNotificationService")).notifyAboutComment(comment, author, password2, AssociationSemantics.getToOne((Entity)entity, (String)"maintainer"), message, wikiAdaptedTextBody);
                return true;
            }
            DnqUtils.getCurrentTransientSession().revert();
            if (notifyAboutCommandFailure) {
                fetcher.commandFailed(message, (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"newCommentCommand", String.class, null), issue);
                if (log.isWarnEnabled()) {
                    log.warn((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -X didn't create comment, command [" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"newCommentCommand", String.class, null) + "] was not applied to issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue)));
                }
                DnqUtils.getCurrentTransientSession().flush();
            }
            return false;
        }
        DnqUtils.getCurrentTransientSession().revert();
        ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).invalidEmailFormat(fetcher, message, null, entity);
        return false;
    }

    private void attachAutoReply(MailboxFetcher fetcher, FetchedMessage message, Entity issue, Entity entity) throws MessagingException {
        fetcher.autoReply(message, issue);
        ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance((StatisticsFeatureDescription)ServiceLocator.getBean((String)"createdAutoReply"));
        DnqUtils.getCurrentTransientSession().flush();
        if (log.isInfoEnabled()) {
            log.info((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -> included in issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " thread as autoreply"));
        }
    }

    private void attachYoutrackNotification(MailboxFetcher fetcher, FetchedMessage message, Entity issue, Entity entity) throws MessagingException {
        fetcher.youtrackNotification(message, issue);
        DnqUtils.getCurrentTransientSession().flush();
        if (log.isInfoEnabled()) {
            log.info((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -> included in issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " thread as Youtrack notification"));
        }
    }

    private void registerFilteredMessage(MailboxFetcher fetcher, FetchedMessage message, Entity entity) throws MessagingException {
        fetcher.filteredMessage(message);
        DnqUtils.getCurrentTransientSession().flush();
        if (log.isInfoEnabled()) {
            log.info((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -> marked as filtered"));
        }
    }

    private void invalidEmailFormat(MailboxFetcher fetcher, FetchedMessage message, @Nullable MessagingException e, Entity entity) throws MessagingException {
        fetcher.invalidEmailFormat(message);
        DnqUtils.getCurrentTransientSession().flush();
        if (log.isWarnEnabled()) {
            log.warn((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -X invalid email format"), (Throwable)e);
        }
    }

    private void unresolvedAuthor(MailboxFetcher fetcher, FetchedMessage message, Entity entity) throws MessagingException {
        fetcher.unresolvedUser(message);
        ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance((StatisticsFeatureDescription)ServiceLocator.getBean((String)"reportedNotFound"));
        DnqUtils.getCurrentTransientSession().flush();
        if (log.isWarnEnabled()) {
            log.warn((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -X could not resolve message author"));
        }
    }

    private void bannedAuthor(MailboxFetcher fetcher, FetchedMessage message, Entity author, Entity entity) throws MessagingException {
        fetcher.fromBannedUser(message, author);
        ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance((StatisticsFeatureDescription)ServiceLocator.getBean((String)"messageFromBannedUser"));
        DnqUtils.getCurrentTransientSession().flush();
        if (log.isWarnEnabled()) {
            log.warn((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -X message author [" + (String)PrimitiveAssociationSemantics.get((Entity)author, (String)"login", String.class, (Object)"<no user>") + "] is banned"));
        }
    }

    private void noPermissionsUser(MailboxFetcher fetcher, FetchedMessage message, Entity maintainer, Entity author, Entity project, Entity entity) throws MessagingException {
        fetcher.noPermissionsUser(message, author);
        ((NotificationsService)ServiceLocator.getBean((String)"mailboxNotificationService")).notifyResolvedUserHasNoRightsToCreateIssue(project, message, maintainer, author);
        DnqUtils.getCurrentTransientSession().flush();
        if (log.isWarnEnabled()) {
            log.warn((Object)(((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getDebugInfo(message, entity) + " -X message author [" + (String)PrimitiveAssociationSemantics.get((Entity)author, (String)"login", String.class, (Object)"<no user>") + "] has no permission to create issue"));
        }
    }

    private Set<String> getFromEmails(FetchedMessage message, Entity entity) throws MessagingException {
        ISetSequence fromEmails = SetSequence.fromSet(new LinkedHashSet());
        String ruleNotificationsFromEmail = ((MailRuleImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"MailRule")).getNotificationsFromEmail(entity);
        if (ruleNotificationsFromEmail != null && ruleNotificationsFromEmail.length() > 0) {
            SetSequence.fromSet((Set)fromEmails).addElement((Object)ruleNotificationsFromEmail);
        }
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"enableSmtp", Boolean.class, null)).booleanValue() && MailRuleImpl.isNotEmpty_ns4w0p_a0a4a42((String)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"smtpFrom", String.class, null))) {
            SetSequence.fromSet((Set)fromEmails).addElement(PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"smtpFrom", String.class, null));
        }
        for (String relatedId : Sequence.fromIterable(message.getRelatedIds())) {
            Entity seenMessage2 = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"SeenMessage", (NodeBase)new PropertyEqual("id", (Comparable)((Object)relatedId))));
            if (EntityOperations.equals((Entity)seenMessage2, null) || !MailRuleImpl.isNotEmpty_ns4w0p_a0a1a6a42((String)PrimitiveAssociationSemantics.get((Entity)seenMessage2, (String)"fromEmail", String.class, null))) continue;
            SetSequence.fromSet((Set)fromEmails).addElement(PrimitiveAssociationSemantics.get((Entity)seenMessage2, (String)"fromEmail", String.class, null));
        }
        return fromEmails;
    }

    private String replaceAttachRefs(String text, Entity attachment, AttachmentCollectorPartsVisitor attachmentsVisitor, Entity entity) {
        String fileName = (String)PrimitiveAssociationSemantics.get((Entity)attachment, (String)"name", String.class, null);
        if (fileName.indexOf("\\E") < 0 && ((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)attachment, (String)"PersistentFile")).isImage(attachment)) {
            Matcher matcher;
            Pattern pattern;
            String contentId = attachmentsVisitor.getContentId(fileName);
            if (contentId != null && contentId.length() > 0) {
                pattern = Pattern.compile("\\[?cid:\\Q" + contentId + "\\E\\]?", 2);
                matcher = pattern.matcher(text);
                fileName = Matcher.quoteReplacement(fileName);
                text = matcher.replaceAll("!" + fileName + "!");
            }
            pattern = Pattern.compile("\\[image:\\s*\\Q" + fileName + "\\E\\]", 2);
            matcher = pattern.matcher(text);
            fileName = Matcher.quoteReplacement(fileName);
            text = matcher.replaceAll("!" + fileName + "!");
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyCommand(String commandText, Entity issue, FetchedMessage message, boolean notifyAboutCommandFailure, Entity entity) throws MessagingException {
        if (MailRuleImpl.isEmpty_ns4w0p_a0a0ab(commandText == null ? null : commandText.trim())) {
            return true;
        }
        String command = commandText.replace(FROM_VARIABLE, message.getFromEmail().replace("\"", "\\\"")).replace(REPLY_TO_VARIABLE, message.getReplyTo().replace("\"", "\\\"")).replace(TO_VARIABLE, message.getRecipients(MimeMessage.RecipientType.TO).replace("\"", "\\\"")).replace(CC_VARIABLE, message.getRecipients(MimeMessage.RecipientType.CC).replace("\"", "\\\""));
        try {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)AssociationSemantics.getToOne((Entity)entity, (String)"maintainer"));
            ICommandList commandList = ((CommandService)ServiceLocator.getBean((String)"commandService")).parse(command, issue);
            commandList.execute(false);
            if (commandList.hasErrors()) {
                if (notifyAboutCommandFailure) {
                    ((NotificationsService)ServiceLocator.getBean((String)"mailboxNotificationService")).notifyCantExecuteCommand(commandList, AssociationSemantics.getToOne((Entity)entity, (String)"project"), message, AssociationSemantics.getToOne((Entity)entity, (String)"maintainer"));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
        }
    }

    private void addWatchers(FetchedMessage message, Entity issue, Entity entity) throws MessagingException {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"starRecipients", Boolean.class, null)).booleanValue()) {
            for (String recipient : Sequence.fromIterable(message.getRecipients())) {
                Entity user2 = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("email", (Comparable)((Object)recipient))));
                if (EntityOperations.equals((Entity)user2, null)) continue;
                IssueTagImpl.addTag((Entity)issue, (Entity)user2, (String)((StarService)ServiceLocator.getBean((String)"starService")).getStarName());
            }
        }
    }

    private String getNotificationsFromEmail(Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"to", String.class, null);
    }

    public String getFromPolicyPresentation(Entity entity) {
        if (DnqUtils._instanceOf((Object)AssociationSemantics.getToOne((Entity)entity, (String)"fromPolicy"), (String)"AutoCreateUserPolicy")) {
            return AutoCreateUserPolicyImpl.PRESENTATION;
        }
        if (DnqUtils._instanceOf((Object)AssociationSemantics.getToOne((Entity)entity, (String)"fromPolicy"), (String)"DefaultUserPolicy")) {
            return DefaultUserPolicyImpl.PRESENTATION;
        }
        return PredefinedUserPolicyImpl.PRESENTATION;
    }

    @Nullable
    public Entity getFromPolicyUser(Entity entity) {
        if (DnqUtils._instanceOf((Object)AssociationSemantics.getToOne((Entity)entity, (String)"fromPolicy"), (String)"AutoCreateUserPolicy")) {
            return null;
        }
        if (DnqUtils._instanceOf((Object)AssociationSemantics.getToOne((Entity)entity, (String)"fromPolicy"), (String)"DefaultUserPolicy")) {
            return AssociationSemantics.getToOne((Entity)DnqUtils.as((Object)AssociationSemantics.getToOne((Entity)entity, (String)"fromPolicy"), (String)"DefaultUserPolicy"), (String)"user");
        }
        return AssociationSemantics.getToOne((Entity)DnqUtils.as((Object)AssociationSemantics.getToOne((Entity)entity, (String)"fromPolicy"), (String)"PredefinedUserPolicy"), (String)"user");
    }

    public void setFromPolicyFromPresentationAndUser(String policyPresentation, Entity user2, Entity entity) {
        if (policyPresentation.equals(AutoCreateUserPolicyImpl.PRESENTATION)) {
            AggregationAssociationSemantics.setOneToOne((Entity)entity, (String)"fromPolicy", (String)"mailMapping", (Entity)AutoCreateUserPolicyImpl.constructor());
        } else if (policyPresentation.equals(DefaultUserPolicyImpl.PRESENTATION)) {
            AggregationAssociationSemantics.setOneToOne((Entity)entity, (String)"fromPolicy", (String)"mailMapping", (Entity)DefaultUserPolicyImpl.constructor(user2));
        } else if (policyPresentation.equals(PredefinedUserPolicyImpl.PRESENTATION)) {
            AggregationAssociationSemantics.setOneToOne((Entity)entity, (String)"fromPolicy", (String)"mailMapping", (Entity)PredefinedUserPolicyImpl.constructor(user2));
        }
    }

    public static Entity constructor() {
        return ((MailRuleImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    private static boolean headerMatches(Message message, String headerName, _FunctionTypes._return_P1_E0<? extends Boolean, ? super String> predicate) throws MessagingException {
        String[] headers = message.getHeader(headerName);
        if (headers != null) {
            for (String header2 : headers) {
                if (!((Boolean)predicate.invoke((Object)header2)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNotEmpty_ns4w0p_a0b0h(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty_ns4w0p_a0a0c0o(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty_ns4w0p_a0a2a61(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_ns4w0p_a0a4a42(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_ns4w0p_a0a1a6a42(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty_ns4w0p_a0a0ab(String str) {
        return str == null || str.length() == 0;
    }
}

