/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.sendMail;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.youtrack.api.notifications.NotificationCase;
import jetbrains.youtrack.api.notifications.NotificationComponentType;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationHeader;
import jetbrains.youtrack.core.persistent.XdNotificationsConfig;
import jetbrains.youtrack.mailbox.persistence.XdSeenMessage;
import jetbrains.youtrack.mailbox.sendMail.EmailSender$WhenMappings;
import jetbrains.youtrack.mailbox.sendMail.EmailSender$sendMail$seenMessage$1;
import jetbrains.youtrack.mailbox.sendMail.UnregisteredUserEmailNotificationJob;
import jetbrains.youtrack.notifications.NotificationServiceKt;
import jetbrains.youtrack.notifications.sending.BeansKt;
import jetbrains.youtrack.notifications.sending.NotificationHeaderImpl;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJN\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/mailbox/sendMail/EmailSender;", "", "()V", "createYouTrackHeaders", "", "", "notifyAdmin", "", "admin", "Ljetbrains/youtrack/persistent/XdUser;", "limit", "", "nextResetTimestamp", "", "sendMail", "relatedIssue", "Ljetbrains/exodus/entitystore/Entity;", "fromPersonal", "fromEmail", "toEmails", "ccEmails", "replyTo", "subject", "body", "Companion", "youtrack-mailbox"})
public final class EmailSender {
    private static final String REPLY_TO_HEADER = "Reply-To";
    private static final String IN_REPLY_TO_HEADER = "In-Reply-To";
    private static final String REFERENCES_HEADER = "References";
    private static final String LIMIT_REFERENCE = "limit";
    private static final String NEXT_RESET_REFERENCE = "next_reset";
    private static final String SUPPORT_EMAIL_REFERENCE = "support_email";
    public static final Companion Companion = new Companion(null);

    private final Map<String, String> createYouTrackHeaders() {
        Map map;
        Map $receiver = map = (Map)new LinkedHashMap();
        String baseUrl = ((XdNotificationsConfig)XdExtensionsKt.toXd((Entity)((Entity)jetbrains.charisma.persistent.BeansKt.getNotificationsConfig()))).getBaseUrl();
        try {
            String string = new URL(baseUrl).getHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URL(baseUrl).host");
            $receiver.put("X-YouTrack-Host", string);
        }
        catch (MalformedURLException e) {
            Companion.getLogger().warn((Function0)new Function0<String>(baseUrl){
                final /* synthetic */ String $baseUrl;

                @NotNull
                public final String invoke() {
                    return "Can't parse host value from base URL " + this.$baseUrl;
                }
                {
                    this.$baseUrl = string;
                    super(0);
                }
            });
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public final void sendMail(@Nullable Entity relatedIssue, @Nullable String fromPersonal, @NotNull String fromEmail, @NotNull String toEmails, @Nullable String ccEmails, @Nullable String replyTo, @NotNull String subject, @NotNull String body) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)fromEmail, (String)"fromEmail");
        Intrinsics.checkParameterIsNotNull((Object)toEmails, (String)"toEmails");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Map<String, String> headers = this.createYouTrackHeaders();
        Entity entity = relatedIssue;
        XdIssue xdIssue = entity != null ? (XdIssue)XdExtensionsKt.toXd((Entity)entity) : null;
        KProperty1 kProperty1 = (KProperty1)EmailSender$sendMail$seenMessage$1.INSTANCE;
        XdEntityType xdEntityType = (XdEntityType)XdSeenMessage.Companion;
        NodeBase nodeBase = NodeBaseOperationsKt.eq((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdSeenMessage.class), (XdEntity)((XdEntity)xdIssue));
        XdSeenMessage seenMessage2 = (XdSeenMessage)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)nodeBase));
        String messageId = BeansKt.getMessageIdUtils().generateIssueId();
        XdSeenMessage xdSeenMessage = seenMessage2;
        if (xdSeenMessage != null) {
            XdSeenMessage xdSeenMessage2;
            XdSeenMessage it = xdSeenMessage2 = xdSeenMessage;
            Map<String, String> map = headers;
            String string = IN_REPLY_TO_HEADER;
            String string2 = '<' + it.getId() + '>';
            map.put(string, string2);
            map = headers;
            string = REFERENCES_HEADER;
            string2 = '<' + it.getId() + '>';
            map.put(string, string2);
            if (replyTo != null) {
                map = headers;
                string = REPLY_TO_HEADER;
                string2 = replyTo;
                map.put(string, string2);
            }
            if (it.getRelatedIds() == null) {
                it.setRelatedIds("");
            }
            it.setRelatedIds(it.getRelatedIds() + ' ' + messageId);
        }
        String string = messageId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"messageId");
        new UnregisteredUserEmailNotificationJob(fromEmail, fromPersonal, toEmails, null, ccEmails, subject, body, string, headers).schedule();
    }

    public final void notifyAdmin(@NotNull XdUser admin2, int limit, long nextResetTimestamp) {
        Intrinsics.checkParameterIsNotNull((Object)admin2, (String)"admin");
        DateTimeZone timezone = jetbrains.charisma.service.BeansKt.getUserProfileService().getGeneralUserProfile(admin2).getTimeZone();
        String nextReset = DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)nextResetTimestamp, (DateTimeZone)timezone), (DateTimeFormatter)DateTimeFormat.fullDateTime(), (Locale)Locale.ENGLISH);
        NotificationCase notificationCase = new NotificationCase(){

            @NotNull
            public NotificationHeader getHeader() {
                return (NotificationHeader)new NotificationHeaderImpl("WL"){

                    @NotNull
                    public String getValue() {
                        return "Workflow message limit exceeded";
                    }
                };
            }

            @NotNull
            public String getTemplateId(@NotNull NotificationComponentType type) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                switch (EmailSender$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        string = "workflow_message_limit_subject.ftl";
                        break;
                    }
                    case 2: {
                        string = "workflow_message_limit_email.ftl";
                        break;
                    }
                    case 3: {
                        string = "workflow_message_limit_email.ftl";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }

            public boolean isCumulative() {
                return NotificationCase.DefaultImpls.isCumulative((NotificationCase)this);
            }

            public boolean isPersistable() {
                return NotificationCase.DefaultImpls.isPersistable((NotificationCase)this);
            }

            @Nullable
            public Map<String, String> getEmailHeaders(@NotNull NotificationData data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return NotificationCase.DefaultImpls.getEmailHeaders((NotificationCase)this, (NotificationData)data);
            }

            @Nullable
            public String retrieveDataId(@NotNull NotificationData data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return NotificationCase.DefaultImpls.retrieveDataId((NotificationCase)this, (NotificationData)data);
            }
        };
        NotificationServiceKt.getNotificationService().notify(notificationCase, null, admin2, null, (Function1)new Function1<NotificationData, Unit>(limit, nextReset){
            final /* synthetic */ int $limit;
            final /* synthetic */ String $nextReset;

            public final void invoke(@NotNull NotificationData $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.set("limit", (Object)this.$limit);
                $receiver.set("next_reset", (Object)this.$nextReset);
                $receiver.set("support_email", (Object)ConfigurationUtil.getSupportEmail());
            }
            {
                this.$limit = n;
                this.$nextReset = string;
                super(1);
            }
        });
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/mailbox/sendMail/EmailSender$Companion;", "Lmu/KLogging;", "()V", "IN_REPLY_TO_HEADER", "", "LIMIT_REFERENCE", "NEXT_RESET_REFERENCE", "REFERENCES_HEADER", "REPLY_TO_HEADER", "SUPPORT_EMAIL_REFERENCE", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

