/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.sendMail;

import jetbrains.charisma.main.LocalScoped;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.mailbox.sendMail.BeansKt;
import jetbrains.youtrack.mailbox.sendMail.EmailSender;
import jetbrains.youtrack.mailbox.sendMail.SendingEmailController;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0004JN\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0018\u0010\r\u001a\n \u000b*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljetbrains/youtrack/mailbox/sendMail/SendingEmailController;", "", "()V", "<set-?>", "", "mailCounter", "getMailCounter", "()I", "setMailCounter", "(I)V", "mailCounterRestartInterval", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "mailLimit", "nextCounterRestart", "", "notificationsForAdminsAreSent", "", "resetNextCounterRestart", "", "setMailLimit", "trySendMail", "relatedIssue", "Ljetbrains/exodus/entitystore/Entity;", "fromPersonal", "", "fromEmail", "email", "cc", "replyTo", "subject", "body", "Companion", "youtrack-mailbox"})
public final class SendingEmailController {
    private Integer mailLimit = Integer.decode(System.getProperty("jetbrains.youtrack.mailLimit", "0"));
    private Integer mailCounterRestartInterval = Integer.decode(System.getProperty("jetbrains.youtrack.mailCounterRestartInterval", "86400000"));
    private long nextCounterRestart;
    private boolean notificationsForAdminsAreSent;
    private int mailCounter;
    @NotNull
    public static final String ADMIN_MESSAGE_REASON = "Workflow failure: You've exceeded daily limit for sent emails";
    private static final String MAIL_LIMIT = "jetbrains.youtrack.mailLimit";
    private static final String MAIL_COUNTER_RESTART_INTERVAL = "jetbrains.youtrack.mailCounterRestartInterval";
    private static final int DEFAULT_RESTART_INTERVAL = 86400000;
    public static final Companion Companion = new Companion(null);

    public final int getMailCounter() {
        return this.mailCounter;
    }

    private final void setMailCounter(int n) {
        this.mailCounter = n;
    }

    public final void setMailLimit(int mailLimit) {
        this.mailLimit = mailLimit;
        this.mailCounterRestartInterval = 86400000;
        long l = System.currentTimeMillis();
        Integer n = this.mailCounterRestartInterval;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"mailCounterRestartInterval");
        this.nextCounterRestart = l + (long)n.intValue();
        this.notificationsForAdminsAreSent = false;
    }

    public final void resetNextCounterRestart() {
        this.nextCounterRestart = System.currentTimeMillis();
    }

    public final void trySendMail(@Nullable Entity relatedIssue, @Nullable String fromPersonal, @NotNull String fromEmail, @NotNull String email, @Nullable String cc, @Nullable String replyTo, @NotNull String subject, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)fromEmail, (String)"fromEmail");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Integer n = this.mailLimit;
        if (n != null && n == 0) {
            BeansKt.getEmailSender().sendMail(relatedIssue, fromPersonal, fromEmail, email, cc, replyTo, subject, body);
        } else {
            if (System.currentTimeMillis() > this.nextCounterRestart) {
                long l = System.currentTimeMillis();
                Integer n2 = this.mailCounterRestartInterval;
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"mailCounterRestartInterval");
                this.nextCounterRestart = l + (long)n2.intValue();
                this.mailCounter = 0;
                this.notificationsForAdminsAreSent = false;
            }
            Integer n3 = this.mailLimit;
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"mailLimit");
            if (Intrinsics.compare((int)this.mailCounter, (int)n3) < 0) {
                int n4 = this.mailCounter;
                this.mailCounter = n4 + 1;
                BeansKt.getEmailSender().sendMail(relatedIssue, fromPersonal, fromEmail, email, cc, replyTo, subject, body);
            } else if (!this.notificationsForAdminsAreSent) {
                Companion.getLogger().warn(ADMIN_MESSAGE_REASON);
                Entity entity = jetbrains.charisma.service.BeansKt.getUserService().getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"userService.root");
                XdUser root = (XdUser)XdExtensionsKt.toXd((Entity)entity);
                if (root.getEmail() != null) {
                    EmailSender emailSender = BeansKt.getEmailSender();
                    Integer n5 = this.mailLimit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n5, (String)"mailLimit");
                    emailSender.notifyAdmin(root, n5, this.nextCounterRestart);
                } else {
                    XdUser admin2 = (XdUser)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdUser.Companion.all(), (Function2)trySendMail.admin.1.INSTANCE));
                    if (admin2 != null) {
                        EmailSender emailSender = BeansKt.getEmailSender();
                        Integer n6 = this.mailLimit;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n6, (String)"mailLimit");
                        emailSender.notifyAdmin(admin2, n6, this.nextCounterRestart);
                    } else {
                        Companion.getLogger().warn("Failed to notify admins on Workflow failure: You've exceeded daily limit for sent emails because their emails are empty");
                    }
                }
                this.notificationsForAdminsAreSent = true;
            }
        }
    }

    public SendingEmailController() {
        long l = System.currentTimeMillis();
        Integer n = this.mailCounterRestartInterval;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"mailCounterRestartInterval");
        this.nextCounterRestart = l + (long)n.intValue();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/mailbox/sendMail/SendingEmailController$Companion;", "Lmu/KLogging;", "()V", "ADMIN_MESSAGE_REASON", "", "DEFAULT_RESTART_INTERVAL", "", "MAIL_COUNTER_RESTART_INTERVAL", "MAIL_LIMIT", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

