/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.service;

import com.sun.mail.pop3.StoreTerminatorKt;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import javax.mail.Store;
import javax.mail.event.ConnectionAdapter;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.servlet.ServletContext;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.youtrack.mailbox.service.MailboxWatchDog;
import jetbrains.youtrack.mailbox.service.MailboxWatchDog$sam$java_lang_Runnable$0;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import mu.KLogging;
import org.apache.log4j.MDC;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.WebLocalScope;

@Component
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0017J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxWatchDog;", "", "()V", "data", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljavax/mail/Store;", "Ljetbrains/youtrack/mailbox/service/MailboxWatchDog$ConnectionStartWithServletContext;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "hangedConnectionTimeout", "", "getHangedConnectionTimeout", "()J", "checkHangedConnections", "", "init", "unwatch", "store", "watchFor", "Companion", "ConnectionStartWithServletContext", "youtrack-mailbox"})
public class MailboxWatchDog {
    private final ConcurrentHashMap<Store, ConnectionStartWithServletContext> data = new ConcurrentHashMap();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    @NotNull
    public static final String HANGED_CONNECTION_TIMEOUT = "jetbrains.youtrack.mailbox.watchdog.timeout";
    public static final long WATCHDOG_CHECK_INTERVAL = 10L;
    public static final Companion Companion = new Companion(null);

    private final long getHangedConnectionTimeout() {
        long l;
        String string = System.getProperty(HANGED_CONNECTION_TIMEOUT);
        if (string != null) {
            String string2 = string;
            l = Long.parseLong(string2);
        } else {
            l = TimeUnit.MINUTES.toMillis(30L);
        }
        return l;
    }

    @PostConstruct
    public void init() {
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                MailboxWatchDog.access$checkHangedConnections((MailboxWatchDog)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MailboxWatchDog.class);
            }

            public final String getName() {
                return "checkHangedConnections";
            }

            public final String getSignature() {
                return "checkHangedConnections()V";
            }
        };
        this.executor.scheduleWithFixedDelay(new MailboxWatchDog$sam$java_lang_Runnable$0(function0), 10L, 10L, TimeUnit.MINUTES);
    }

    public final void watchFor(@NotNull Store store) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        BeanContainer beanContainer = WebLocalScope.getContainer();
        Intrinsics.checkExpressionValueIsNotNull((Object)beanContainer, (String)"WebLocalScope.getContainer()");
        ServletContext servletContext = beanContainer.getContext();
        Map map = this.data;
        long l = System.currentTimeMillis();
        ServletContext servletContext2 = servletContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)servletContext2, (String)"servletContext");
        ConnectionStartWithServletContext connectionStartWithServletContext = new ConnectionStartWithServletContext(l, servletContext2);
        map.put(store, connectionStartWithServletContext);
        store.addConnectionListener((ConnectionListener)new ConnectionAdapter(this){
            final /* synthetic */ MailboxWatchDog this$0;

            public void closed(@NotNull ConnectionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                try {
                    Object object = e.getSource();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type javax.mail.Store");
                    }
                    MailboxWatchDog.access$unwatch(this.this$0, (Store)object);
                }
                catch (Throwable e2) {
                    MailboxWatchDog.Companion.getLogger().error(e2, (Function0)watchFor.closed.1.INSTANCE);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void unwatch(Store store) {
        this.data.remove(store);
    }

    private final void checkHangedConnections() {
        long time = System.currentTimeMillis();
        this.data.forEach(new BiConsumer<Store, ConnectionStartWithServletContext>(this, time){
            final /* synthetic */ MailboxWatchDog this$0;
            final /* synthetic */ long $time;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void accept(@NotNull Store store, @NotNull ConnectionStartWithServletContext entry) {
                Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                long startTime = entry.getStartTime();
                try {
                    MDC.put((String)WebLocalScope.MDC_SERVLET_CONTEXT_KEY, (Object)entry.getContext());
                    MDC.put((String)"domain", (String)entry.getContext().getInitParameter("domain"));
                    if (this.$time - startTime > MailboxWatchDog.access$getHangedConnectionTimeout$p(this.this$0)) {
                        MailboxWatchDog.Companion.getLogger().warn((Function0)new Function0<String>(startTime){
                            final /* synthetic */ long $startTime;

                            @NotNull
                            public final String invoke() {
                                return "Found hanged mailbox store with start time : " + new Date(this.$startTime);
                            }
                            {
                                this.$startTime = l;
                                super(0);
                            }
                        });
                        try {
                            MailboxWatchDog.access$getData$p(this.this$0).remove(store);
                            StoreTerminatorKt.close(store);
                            MailboxWatchDog.Companion.getLogger().warn((Function0)checkHangedConnections.2.INSTANCE);
                        }
                        catch (Throwable e) {
                            MailboxWatchDog.Companion.getLogger().warn(e, (Function0)checkHangedConnections.3.INSTANCE);
                        }
                    }
                }
                finally {
                    MDC.remove((String)WebLocalScope.MDC_SERVLET_CONTEXT_KEY);
                    MDC.remove((String)"domain");
                }
            }
            {
                this.this$0 = mailboxWatchDog;
                this.$time = l;
            }
        });
    }

    public static final /* synthetic */ void access$checkHangedConnections(MailboxWatchDog $this) {
        $this.checkHangedConnections();
    }

    public static final /* synthetic */ void access$unwatch(MailboxWatchDog $this, @NotNull Store store) {
        $this.unwatch(store);
    }

    public static final /* synthetic */ long access$getHangedConnectionTimeout$p(MailboxWatchDog $this) {
        return $this.getHangedConnectionTimeout();
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getData$p(MailboxWatchDog $this) {
        return $this.data;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxWatchDog$ConnectionStartWithServletContext;", "", "startTime", "", "context", "Ljavax/servlet/ServletContext;", "(JLjavax/servlet/ServletContext;)V", "getContext", "()Ljavax/servlet/ServletContext;", "getStartTime", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "youtrack-mailbox"})
    public static final class ConnectionStartWithServletContext {
        private final long startTime;
        @NotNull
        private final ServletContext context;

        public final long getStartTime() {
            return this.startTime;
        }

        @NotNull
        public final ServletContext getContext() {
            return this.context;
        }

        public ConnectionStartWithServletContext(long startTime, @NotNull ServletContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.startTime = startTime;
            this.context = context;
        }

        public final long component1() {
            return this.startTime;
        }

        @NotNull
        public final ServletContext component2() {
            return this.context;
        }

        @NotNull
        public final ConnectionStartWithServletContext copy(long startTime, @NotNull ServletContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return new ConnectionStartWithServletContext(startTime, context);
        }

        @NotNull
        public static /* synthetic */ ConnectionStartWithServletContext copy$default(ConnectionStartWithServletContext connectionStartWithServletContext, long l, ServletContext servletContext, int n, Object object) {
            if ((n & 1) != 0) {
                l = connectionStartWithServletContext.startTime;
            }
            if ((n & 2) != 0) {
                servletContext = connectionStartWithServletContext.context;
            }
            return connectionStartWithServletContext.copy(l, servletContext);
        }

        @NotNull
        public String toString() {
            return "ConnectionStartWithServletContext(startTime=" + this.startTime + ", context=" + this.context + ")";
        }

        public int hashCode() {
            ServletContext servletContext = this.context;
            return Long.hashCode(this.startTime) * 31 + (servletContext != null ? servletContext.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ConnectionStartWithServletContext)) break block3;
                    ConnectionStartWithServletContext connectionStartWithServletContext = (ConnectionStartWithServletContext)object;
                    if (!(this.startTime == connectionStartWithServletContext.startTime) || !Intrinsics.areEqual((Object)this.context, (Object)connectionStartWithServletContext.context)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxWatchDog$Companion;", "Lmu/KLogging;", "()V", "HANGED_CONNECTION_TIMEOUT", "", "WATCHDOG_CHECK_INTERVAL", "", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

