/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup;

import java.util.List;
import jetbrains.exodus.backup.BackupBean;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import org.jetbrains.annotations.NotNull;

public class CancellableBackupBean
extends BackupBean {
    private volatile boolean interrupted = false;

    public CancellableBackupBean(Backupable target) {
        super(target);
    }

    public CancellableBackupBean(List<Backupable> targets) {
        super(targets);
    }

    public BackupStrategy getBackupStrategy() {
        final BackupStrategy originalStrategy = super.getBackupStrategy();
        this.interrupted = false;
        BackupStrategy cancellableStrategy = new BackupStrategy(){

            public Iterable<VirtualFileDescriptor> getContents() {
                return originalStrategy.getContents();
            }

            public long acceptFile(@NotNull VirtualFileDescriptor file) {
                return originalStrategy.acceptFile(file);
            }

            public void onError(Throwable throwable) {
                CancellableBackupBean.this.interrupted = false;
                originalStrategy.onError(throwable);
            }

            public boolean isInterrupted() {
                return CancellableBackupBean.this.interrupted;
            }

            public void afterBackup() throws Exception {
                CancellableBackupBean.this.interrupted = false;
                originalStrategy.afterBackup();
            }

            public void beforeBackup() throws Exception {
                originalStrategy.beforeBackup();
            }
        };
        return cancellableStrategy;
    }

    public void cancelBackup() {
        this.interrupted = true;
    }

    public boolean isCancelled() {
        return this.interrupted;
    }
}

