/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.TransientEntityStoreImpl;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistence.user.User;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.DatabaseBackupConfigImpl;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.gap.resource.HelpersKt;
import jetbrains.gap.resource.Secured;
import jetbrains.gap.resource.components.ResourceFactory;
import jetbrains.gap.resource.metadata.Delegate;
import jetbrains.gap.resource.metadata.DelegateProvider;
import jetbrains.gap.resource.metadata.DelegateProviderKt;
import jetbrains.gap.resource.metadata.PropertyDelegate;
import jetbrains.gap.resource.metadata.PropertyMetaData;
import jetbrains.gap.resource.metadata.ReadOnlyDelegate;
import jetbrains.youtrack.api.rest.RestPublic;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.gaprest.db.DatabaseEntity;
import jetbrains.youtrack.gaprest.db.helpers.DelegatesKt;
import jetbrains.youtrack.gaprest.exception.ExceptionsKt;
import jetbrains.youtrack.gaprest.exception.LocalizedFieldException;
import jetbrains.youtrack.gaprest.exception.LocalizedForbiddenException;
import jetbrains.youtrack.gaprest.util.SingletonDatabaseEntity;
import jetbrains.youtrack.maintenance.backup.BackupFileType;
import jetbrains.youtrack.maintenance.backup.BackupStatus;
import jetbrains.youtrack.maintenance.backup.DatabaseBackupSettings;
import jetbrains.youtrack.maintenance.backup.DatabaseBackupSettings$updateFrom$1;
import jetbrains.youtrack.maintenance.backup.DatabaseBackupSettings$updateFrom$3;
import jetbrains.youtrack.maintenance.backup.DatabaseBackupSettings$updateFrom$4;
import jetbrains.youtrack.maintenance.backup.DatabaseBackupSettings$updateFrom$simpleProperties$1;
import jetbrains.youtrack.maintenance.backup.DatabaseBackupSettings$updateFrom$simpleProperties$2;
import jetbrains.youtrack.maintenance.backup.DatabaseBackupSettings$updateFrom$simpleProperties$3;
import jetbrains.youtrack.maintenance.backup.DatabaseBackupSettings$updateFrom$simpleProperties$4;
import jetbrains.youtrack.maintenance.backup.DatabaseBackupSettingsKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RestPublic
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010>\u001a\u00020(H\u0016J\b\u0010?\u001a\u00020(H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020A2\b\u0010.\u001a\u0004\u0018\u00010\u0017R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R/\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0004\u001a\u0004\u0018\u00010\u00178F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001e\u001a\u0004\u0018\u00010\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0016\u001a\u0004\b\u001f\u0010\u001aR+\u0010\"\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020!8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R+\u0010)\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020(8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R/\u0010.\u001a\u0004\u0018\u00010\u00172\b\u0010\u0004\u001a\u0004\u0018\u00010\u00178F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b1\u0010\f\u001a\u0004\b/\u0010\u001a\"\u0004\b0\u0010\u001cR\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R7\u00108\u001a\b\u0012\u0004\u0012\u000207062\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u000207068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b=\u0010\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006F"}, d2={"Ljetbrains/youtrack/maintenance/backup/DatabaseBackupSettings;", "Ljetbrains/youtrack/gaprest/util/SingletonDatabaseEntity;", "Ljetbrains/gap/resource/Secured;", "()V", "<set-?>", "Ljetbrains/youtrack/maintenance/backup/BackupFileType;", "archiveFormat", "getArchiveFormat", "()Ljetbrains/youtrack/maintenance/backup/BackupFileType;", "setArchiveFormat", "(Ljetbrains/youtrack/maintenance/backup/BackupFileType;)V", "archiveFormat$delegate", "Ljetbrains/gap/resource/metadata/Delegate;", "availableDiskSpace", "", "getAvailableDiskSpace", "()J", "backupStatus", "Ljetbrains/youtrack/maintenance/backup/BackupStatus;", "getBackupStatus", "()Ljetbrains/youtrack/maintenance/backup/BackupStatus;", "backupStatus$delegate", "Ljetbrains/gap/resource/metadata/ReadOnlyDelegate;", "", "cronExpression", "getCronExpression", "()Ljava/lang/String;", "setCronExpression", "(Ljava/lang/String;)V", "cronExpression$delegate", "defaultLocation", "getDefaultLocation", "defaultLocation$delegate", "", "filesToKeep", "getFilesToKeep", "()I", "setFilesToKeep", "(I)V", "filesToKeep$delegate", "", "isOn", "()Z", "setOn", "(Z)V", "isOn$delegate", "location", "getLocation", "setLocation", "location$delegate", "mpsClass", "Ljetbrains/charisma/persistent/DatabaseBackupConfigImpl;", "getMpsClass", "()Ljetbrains/charisma/persistent/DatabaseBackupConfigImpl;", "", "Ljetbrains/charisma/persistence/user/User;", "notifiedUsers", "getNotifiedUsers", "()Ljava/util/Collection;", "setNotifiedUsers", "(Ljava/util/Collection;)V", "notifiedUsers$delegate", "canAccess", "canUpdate", "updateFrom", "", "that", "Ljetbrains/gap/resource/Entity;", "validateAndStoreLocation", "Companion", "youtrack-maintenance"})
public class DatabaseBackupSettings
extends SingletonDatabaseEntity
implements Secured {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private final Delegate location$delegate = DelegateProviderKt.string((DelegateProvider)this).by("backupLocation");
    @Nullable
    private final ReadOnlyDelegate defaultLocation$delegate = DelegateProviderKt.readOnlyDelegate$default((DelegateProvider)this, null, (Function0)defaultLocation.2.INSTANCE, (int)1, null);
    @NotNull
    private final Delegate filesToKeep$delegate = DelegateProviderKt.integer$default((DelegateProvider)this, null, (int)1, null).by("backupCountToKeep");
    @Nullable
    private final Delegate cronExpression$delegate = DelegateProviderKt.nullableDelegate((DelegateProvider)this, (Function0)cronExpression.2.INSTANCE);
    @NotNull
    private final Delegate archiveFormat$delegate = DelegateProviderKt.delegate((DelegateProvider)this, (Function0)archiveFormat.2.INSTANCE);
    @NotNull
    private final Delegate isOn$delegate = DelegateProviderKt.boolean$default((DelegateProvider)this, null, (int)1, null);
    @NotNull
    private final Delegate notifiedUsers$delegate = DelegatesKt.directed_many((DatabaseEntity)this, (KClass)Reflection.getOrCreateKotlinClass(User.class)).resource((ResourceFactory)DatabaseBackupSettingsKt.getChildLinkUser());
    @NotNull
    private final ReadOnlyDelegate backupStatus$delegate = DelegateProviderKt.editableDelegate$default((DelegateProvider)this, null, (Function0)backupStatus.2.INSTANCE, (int)1, null);
    @NotNull
    private static final PropertyDelegate<DatabaseEntity, BackupFileType> archiveFormatProvider;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseBackupSettings.class), "location", "getLocation()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseBackupSettings.class), "defaultLocation", "getDefaultLocation()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseBackupSettings.class), "filesToKeep", "getFilesToKeep()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseBackupSettings.class), "cronExpression", "getCronExpression()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseBackupSettings.class), "archiveFormat", "getArchiveFormat()Ljetbrains/youtrack/maintenance/backup/BackupFileType;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseBackupSettings.class), "isOn", "isOn()Z")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseBackupSettings.class), "notifiedUsers", "getNotifiedUsers()Ljava/util/Collection;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseBackupSettings.class), "backupStatus", "getBackupStatus()Ljetbrains/youtrack/maintenance/backup/BackupStatus;"))};
        Companion = new Companion(null);
        archiveFormatProvider = (PropertyDelegate)new PropertyDelegate<DatabaseEntity, BackupFileType>(new PropertyMetaData("zipArhive", null, null, 4, null)){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public BackupFileType getValue(@NotNull DatabaseEntity thisRef, @NotNull KProperty<?> property) {
                void this_$iv;
                Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
                Intrinsics.checkParameterIsNotNull(property, (String)"property");
                DatabaseEntity databaseEntity = thisRef;
                String name$iv = this.name(property);
                Boolean b = (Boolean)((Comparable)PrimitiveAssociationSemantics.get((Entity)((Entity)this_$iv.getEntity()), (String)name$iv, Boolean.class, null));
                if (b != null && b.booleanValue()) {
                    return BackupFileType.ZIP;
                }
                return BackupFileType.TAR_GZ;
            }

            /*
             * WARNING - void declaration
             */
            public void setValue(@NotNull DatabaseEntity thisRef, @NotNull KProperty<?> property, @NotNull BackupFileType value) {
                void name$iv;
                void this_$iv;
                Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
                Intrinsics.checkParameterIsNotNull(property, (String)"property");
                Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
                DatabaseEntity databaseEntity = thisRef;
                String string = this.name(property);
                Comparable value$iv = Boolean.valueOf(value == BackupFileType.ZIP);
                PrimitiveAssociationSemantics.set((Entity)((Entity)this_$iv.getEntity()), (String)name$iv, (Comparable)value$iv, Boolean.class);
            }
        };
    }

    @NotNull
    public DatabaseBackupConfigImpl getMpsClass() {
        DatabaseBackupSettings $receiver$iv = this;
        TransientEntityStore transientEntityStore = $receiver$iv.getEntity().getStore();
        if (transientEntityStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.teamsys.dnq.database.TransientEntityStoreImpl");
        }
        TransientEntityStoreImpl store$iv = (TransientEntityStoreImpl)transientEntityStore;
        BasePersistentClassImpl basePersistentClassImpl = store$iv.getCachedPersistentClassInstance(DatabaseBackupConfigImpl.class);
        if (basePersistentClassImpl == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.persistent.DatabaseBackupConfigImpl");
        }
        return (DatabaseBackupConfigImpl)basePersistentClassImpl;
    }

    @Nullable
    public final String getLocation() {
        return (String)this.location$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setLocation(@Nullable String string) {
        this.location$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @Nullable
    public final String getDefaultLocation() {
        return (String)this.defaultLocation$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final int getFilesToKeep() {
        return ((Number)this.filesToKeep$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    public final void setFilesToKeep(int n) {
        this.filesToKeep$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)n);
    }

    @Nullable
    public final String getCronExpression() {
        return (String)this.cronExpression$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public final void setCronExpression(@Nullable String string) {
        this.cronExpression$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
    }

    @NotNull
    public final BackupFileType getArchiveFormat() {
        return (BackupFileType)((Object)this.archiveFormat$delegate.getValue((Object)this, $$delegatedProperties[4]));
    }

    public final void setArchiveFormat(@NotNull BackupFileType backupFileType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)backupFileType), (String)"<set-?>");
        this.archiveFormat$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)backupFileType);
    }

    public final boolean isOn() {
        return (Boolean)this.isOn$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    public final void setOn(boolean bl) {
        this.isOn$delegate.setValue((Object)this, $$delegatedProperties[5], (Object)bl);
    }

    public long getAvailableDiskSpace() {
        return this.getMpsClass().getAvailableBytes((Entity)this.getEntity());
    }

    @NotNull
    public final Collection<User> getNotifiedUsers() {
        return (Collection)this.notifiedUsers$delegate.getValue((Object)this, $$delegatedProperties[6]);
    }

    public final void setNotifiedUsers(@NotNull Collection<User> collection) {
        Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
        this.notifiedUsers$delegate.setValue((Object)this, $$delegatedProperties[6], collection);
    }

    @NotNull
    public BackupStatus getBackupStatus() {
        return (BackupStatus)((Object)this.backupStatus$delegate.getValue((Object)this, $$delegatedProperties[7]));
    }

    public void updateFrom(@NotNull jetbrains.gap.resource.Entity that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        List simpleProperties2 = CollectionsKt.listOf((Object[])new KMutableProperty1[]{DatabaseBackupSettings$updateFrom$simpleProperties$1.INSTANCE, DatabaseBackupSettings$updateFrom$simpleProperties$2.INSTANCE, DatabaseBackupSettings$updateFrom$simpleProperties$3.INSTANCE, DatabaseBackupSettings$updateFrom$simpleProperties$4.INSTANCE});
        for (KMutableProperty1 property : simpleProperties2) {
            HelpersKt.apply((jetbrains.gap.resource.Entity)this, (jetbrains.gap.resource.Entity)that, (KMutableProperty1)property);
        }
        HelpersKt.applyCollection((jetbrains.gap.resource.Entity)this, (jetbrains.gap.resource.Entity)that, (KProperty1)((KProperty1)DatabaseBackupSettings$updateFrom$1.INSTANCE), (Function1)updateFrom.2.INSTANCE);
        if (that.provides((KProperty1)DatabaseBackupSettings$updateFrom$3.INSTANCE)) {
            this.validateAndStoreLocation(((DatabaseBackupSettings)that).getLocation());
        }
        HelpersKt.update((jetbrains.gap.resource.Entity)this, (jetbrains.gap.resource.Entity)that, (KProperty1)DatabaseBackupSettings$updateFrom$4.INSTANCE);
    }

    public final void validateAndStoreLocation(@Nullable String location) {
        if (ConfigurationUtil.isYoutrackHosted()) {
            throw (Throwable)new LocalizedForbiddenException("DatabaseBackupSettings.backup_location_is_readonly", new Object[0]);
        }
        Companion.validateBackupLocationPermissions(location);
        this.setLocation(location);
    }

    public boolean canAccess() {
        return PrincipalsKt.hasPermission((Entity)((Entity)BeansKt.getLoggedInUser()), (Permission)Permission.ADMIN_READ_APP);
    }

    public boolean canUpdate() {
        return PrincipalsKt.hasPermission((Entity)((Entity)BeansKt.getLoggedInUser()), (Permission)Permission.ADMIN_UPDATE_APP);
    }

    public void assertAccess() {
        Secured.DefaultImpls.assertAccess((Secured)this);
    }

    public void assertDeleteAccess() {
        Secured.DefaultImpls.assertDeleteAccess((Secured)this);
    }

    public void assertUpdateAccess() {
        Secured.DefaultImpls.assertUpdateAccess((Secured)this);
    }

    public void assertUpdateAccess(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Secured.DefaultImpls.assertUpdateAccess((Secured)this, property);
    }

    public boolean canDelete() {
        return Secured.DefaultImpls.canDelete((Secured)this);
    }

    public boolean canUpdateProperty(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        return Secured.DefaultImpls.canUpdateProperty((Secured)this, property);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/maintenance/backup/DatabaseBackupSettings$Companion;", "", "()V", "archiveFormatProvider", "Ljetbrains/gap/resource/metadata/PropertyDelegate;", "Ljetbrains/youtrack/gaprest/db/DatabaseEntity;", "Ljetbrains/youtrack/maintenance/backup/BackupFileType;", "getArchiveFormatProvider", "()Ljetbrains/gap/resource/metadata/PropertyDelegate;", "backupLocationError", "", "localizationId", "", "validateBackupLocationPermissions", "location", "youtrack-maintenance"})
    public static final class Companion {
        @NotNull
        public final PropertyDelegate<DatabaseEntity, BackupFileType> getArchiveFormatProvider() {
            return archiveFormatProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void validateBackupLocationPermissions(@Nullable String location) {
            boolean canCreateFile;
            File folder;
            CharSequence charSequence = location;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                this.backupLocationError("DatabaseBackupSettings.backup_location_is_required");
            }
            if ((folder = new File(location)).exists() && !folder.isDirectory()) {
                this.backupLocationError("DatabaseBackupSettings.backup_location_must_reference_a_directory");
            }
            if (!folder.exists() && !folder.mkdirs()) {
                this.backupLocationError("DatabaseBackupSettings.the_backup_location_is_not_write_accessible");
            }
            File testFile = new File(folder, UUID.randomUUID().toString());
            try {
                canCreateFile = testFile.createNewFile();
            }
            catch (Throwable e) {
                canCreateFile = false;
            }
            finally {
                testFile.delete();
            }
            if (!canCreateFile) {
                this.backupLocationError("DatabaseBackupSettings.the_backup_location_is_not_write_accessible");
            }
        }

        private final void backupLocationError(String localizationId) {
            throw (Throwable)new LocalizedFieldException("location", DatabaseBackupSettings.class, ExceptionsKt.invalidFieldError(DatabaseBackupSettings.class, (String)"location"), localizationId, new Object[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

