/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.statisics;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.statistics.StatisticsCommonParamsProvider;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.webr.LocalScopeKt;
import jetbrains.youtrack.maintenance.statisics.FeatureUsagesCounter;
import jetbrains.youtrack.maintenance.statisics.IncrementalStatisticsProvider;
import jetbrains.youtrack.maintenance.statisics.StatisticsReporter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.WebLocalScope;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0003J2\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u0006\u0010\u001d\u001a\u00020\u0016J0\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0006\u0010\"\u001a\u00020\u0016R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Ljetbrains/youtrack/maintenance/statisics/StatisticsReporter;", "", "()V", "commonParameters", "", "Ljetbrains/charisma/statistics/StatisticsCommonParamsProvider;", "dateTimeFormatter", "Lorg/joda/time/format/DateTimeFormatter;", "getDateTimeFormatter", "()Lorg/joda/time/format/DateTimeFormatter;", "resource", "Ljavax/ws/rs/client/WebTarget;", "statisticsProvider", "Ljetbrains/youtrack/maintenance/statisics/IncrementalStatisticsProvider;", "getStatisticsProvider", "()Ljetbrains/youtrack/maintenance/statisics/IncrementalStatisticsProvider;", "applyDateFormat", "", "time", "", "collectCommonData", "init", "", "sendData", "userId", "content", "common", "start", "close", "sendServerStat", "sendUserStat", "ringUserId", "counter", "Ljetbrains/youtrack/maintenance/statisics/FeatureUsagesCounter;", "sendUsersStat", "Companion", "youtrack-maintenance"})
public final class StatisticsReporter {
    private WebTarget resource;
    @Autowired
    private Collection<? extends StatisticsCommonParamsProvider> commonParameters;
    private static final String STAT_URL_PARAMETER = "jetbrains.youtrack.statistics.url";
    private static final String DEFAULT_STAT_URL = "https://youtrack-statistics.aws.intellij.net:8099";
    public static final Companion Companion = new Companion(null);

    private final DateTimeFormatter getDateTimeFormatter() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss").withZoneUTC();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"DateTimeFormat.forPatter\u2026'HH:mm:ss\").withZoneUTC()");
        return dateTimeFormatter;
    }

    private final IncrementalStatisticsProvider getStatisticsProvider() {
        String name$iv = "countersIncrementer";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.maintenance.statisics.IncrementalStatisticsProvider");
        }
        return (IncrementalStatisticsProvider)object;
    }

    @PostConstruct
    private final void init() {
        int threadsCount = ConfigurationUtil.isYoutrackHosted() ? 2 : 1;
        Client client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().property("jersey.config.client.connectTimeout", (Object)20000)).property("jersey.config.client.readTimeout", (Object)20000)).property("jersey.config.client.async.threadPoolSize", (Object)threadsCount)).build();
        WebTarget webTarget = client.target(StatisticsReporter.Companion.getStatisticsServiceUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"client.target(statisticsServiceUrl)");
        this.resource = webTarget;
    }

    public final void sendUsersStat() {
        Pair<Long, Map<String, FeatureUsagesCounter>> data = this.getStatisticsProvider().dropAndGetUserCounters();
        String startTime = this.applyDateFormat(((Number)data.getFirst()).longValue());
        String closeTime = this.applyDateFormat(System.currentTimeMillis());
        String common2 = this.collectCommonData();
        if (((Map)data.getSecond()).isEmpty() && ((Number)data.getFirst()).longValue() == -1L) {
            startTime = this.applyDateFormat(System.currentTimeMillis() - (long)18000000);
        }
        Map map = (Map)data.getSecond();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String key = (String)entry2.getKey();
            entry2 = entry;
            FeatureUsagesCounter value = (FeatureUsagesCounter)entry2.getValue();
            this.sendUserStat(key, value, startTime, closeTime, common2);
        }
    }

    private final void sendUserStat(String ringUserId, FeatureUsagesCounter counter, String start, String close, String common2) {
        String content = counter.toFormUrlEncodedData();
        this.sendData(ringUserId, content, common2, start, close);
    }

    public final void sendServerStat() {
        Pair<Long, FeatureUsagesCounter> data = this.getStatisticsProvider().dropAndGetServerCounters();
        String content = ((FeatureUsagesCounter)data.getSecond()).toFormUrlEncodedData();
        String startTime = this.applyDateFormat(((Number)data.getFirst()).longValue());
        String closeTime = this.applyDateFormat(System.currentTimeMillis());
        String common2 = this.collectCommonData();
        if (((Number)data.getFirst()).longValue() == -1L) {
            startTime = this.applyDateFormat(System.currentTimeMillis() - (long)43200000);
        }
        this.sendData(StatisticsReporter.Companion.getUuid(), content, common2, startTime, closeTime);
    }

    private final void sendData(String userId, String content, String common2, String start, String close) {
        MultivaluedStringMap multivaluedStringMap;
        MultivaluedStringMap $receiver = multivaluedStringMap = new MultivaluedStringMap();
        $receiver.putSingle((Object)"ytsa-UserUUID", (Object)userId);
        $receiver.putSingle((Object)"ytsa-InstUUID", (Object)StatisticsReporter.Companion.getUuid());
        $receiver.putSingle((Object)"ytsa-StartDate", (Object)start);
        $receiver.putSingle((Object)"ytsa-EndDate", (Object)close);
        $receiver.putSingle((Object)"ytsa-Content", (Object)content);
        $receiver.putSingle((Object)"ytsa-Common", (Object)common2);
        MultivaluedStringMap requestEntity = multivaluedStringMap;
        BeanContainer beanContainer = WebLocalScope.getContainer();
        Intrinsics.checkExpressionValueIsNotNull((Object)beanContainer, (String)"WebLocalScope.getContainer()");
        BeanContainer beanContainer2 = beanContainer;
        int totalSize = content.length() + common2.length();
        InvocationCallback<Response> callback2 = new InvocationCallback<Response>(beanContainer2, totalSize){
            final /* synthetic */ BeanContainer $beanContainer;
            final /* synthetic */ int $totalSize;

            public void completed(@Nullable Response response) {
                LocalScopeKt.inLocalScope((BeanContainer)this.$beanContainer, (Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ sendData.callback.1 this$0;

                    public final void invoke() {
                        StatisticsReporter.Companion.getLogger().trace("Successful sending statistics. Size " + this.this$0.$totalSize);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }

            public void failed(@Nullable Throwable throwable) {
                LocalScopeKt.inLocalScope((BeanContainer)this.$beanContainer, (Function0)((Function0)new Function0<Unit>(this, throwable){
                    final /* synthetic */ sendData.callback.1 this$0;
                    final /* synthetic */ Throwable $throwable;

                    public final void invoke() {
                        Throwable throwable = this.$throwable;
                        StatisticsReporter.Companion.getLogger().error("Unsuccessful sending statistics because of " + (throwable != null ? throwable.getMessage() : null) + " Size " + this.this$0.$totalSize);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$throwable = throwable;
                        super(0);
                    }
                }));
            }
            {
                this.$beanContainer = $captured_local_variable$0;
                this.$totalSize = $captured_local_variable$1;
            }
        };
        WebTarget webTarget = this.resource;
        if (webTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resource");
        }
        webTarget.request().async().post(Entity.entity((Object)requestEntity, (String)"application/x-www-form-urlencoded"), (InvocationCallback)callback2);
    }

    private final String collectCommonData() {
        long startTime = System.currentTimeMillis();
        Collection<? extends StatisticsCommonParamsProvider> collection = this.commonParameters;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonParameters");
        }
        String common2 = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)";", null, null, (int)0, null, (Function1)collectCommonData.common.1.INSTANCE, (int)30, null);
        Companion.getLogger().trace((Function0)new Function0<String>(startTime){
            final /* synthetic */ long $startTime;

            @NotNull
            public final String invoke() {
                return "Common data collecting took " + (System.currentTimeMillis() - this.$startTime) + " ms";
            }
            {
                this.$startTime = l;
                super(0);
            }
        });
        return common2;
    }

    private final String applyDateFormat(long time) {
        String string = this.getDateTimeFormatter().print((ReadableInstant)new DateTime(time));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dateTimeFormatter.print(DateTime(time))");
        return string;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/maintenance/statisics/StatisticsReporter$Companion;", "Lmu/KLogging;", "()V", "DEFAULT_STAT_URL", "", "STAT_URL_PARAMETER", "statisticsServiceUrl", "getStatisticsServiceUrl", "()Ljava/lang/String;", "uuid", "getUuid", "youtrack-maintenance"})
    public static final class Companion
    extends KLogging {
        private final String getStatisticsServiceUrl() {
            String string = System.getProperty(StatisticsReporter.STAT_URL_PARAMETER, StatisticsReporter.DEFAULT_STAT_URL);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(STAT_\u2026AMETER, DEFAULT_STAT_URL)");
            return string;
        }

        private final String getUuid() {
            return (String)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, String>(){

                public final String invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return BeansKt.getXdApplicationMetaData().getUuid();
                }
            }), (int)7, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

