/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.updates;

import jetbrains.youtrack.maintenance.updates.Build;
import org.apache.commons.lang.math.NumberUtils;

public class BuildCompareUtil {
    public static boolean isNewer(Build _this, String oldBuild) {
        return BuildCompareUtil.isNewer(_this.getNumber(), oldBuild);
    }

    public static boolean isNewer(String _this, String oldBuild) {
        String newBuild = _this;
        if (newBuild == null || newBuild.length() == 0 || oldBuild == null || oldBuild.length() == 0) {
            return false;
        }
        int[] newBuildComponents = BuildCompareUtil.parseBuild(newBuild);
        int[] oldBuildComponents = BuildCompareUtil.parseBuild(oldBuild);
        if (newBuildComponents == null || oldBuildComponents == null) {
            return false;
        }
        if (newBuildComponents.length > oldBuildComponents.length) {
            return true;
        }
        if (newBuildComponents.length < oldBuildComponents.length) {
            return false;
        }
        for (int i = 0; i < newBuildComponents.length; ++i) {
            int cmp = newBuildComponents[i] - oldBuildComponents[i];
            if (cmp > 0) {
                return true;
            }
            if (cmp >= 0) continue;
            return false;
        }
        return false;
    }

    private static int[] parseBuild(String _this) {
        String[] components = _this.split("\\.");
        int[] result = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            int num = NumberUtils.toInt((String)components[i], (int)-1);
            if (num == -1) {
                return null;
            }
            result[i] = num;
        }
        return result;
    }
}

