/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.updates;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistent.UserActionJobContainer;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.youtrack.api.misc.UpdateCheckResult;
import jetbrains.youtrack.api.misc.UpdateChecker;
import jetbrains.youtrack.maintenance.updates.Channel;
import jetbrains.youtrack.maintenance.updates.ChannelStatus;
import jetbrains.youtrack.maintenance.updates.UpdateRest;
import webr.framework.controller.CentralManager;

public class UpdateCheckerImpl
implements UpdateChecker {
    private UserActionJobContainer jobContainer;
    private final String applicationBuild;
    private UpdateCheckResult recentResult;
    private ReadWriteLock resultLock;
    private List<_FunctionTypes._void_P1_E0<? super UpdateCheckResult>> listeners;
    private String myProductCode;
    private String myJobName;
    private UpdateRest myUpdateRest;

    public UpdateCheckerImpl(String applicationBuild) {
        this.applicationBuild = applicationBuild;
        this.resultLock = new ReentrantReadWriteLock();
        this.recentResult = UpdateCheckResult.notAvailable();
        this.listeners = ListSequence.fromList(new ArrayList());
    }

    public boolean isUpdateCheckRequired() {
        return !ConfigurationUtil.isYoutrackHosted() && !"true".equals(ConfigurationParameter.getParameter((String)"jetbrains.youtrack.disableCheckForUpdate"));
    }

    public void checkForUpdate() {
        this.jobContainer.getOrCreateJob(new Runnable(){

            @Override
            public void run() {
                UpdateCheckResult result;
                try {
                    Channel channel = UpdateCheckerImpl.this.getUpdateRest().getNewerBuild(UpdateCheckerImpl.this.getProductCode(), ChannelStatus.RELEASE, UpdateCheckerImpl.this.applicationBuild, UpdateCheckerImpl.this.createParams());
                    result = channel != null ? UpdateCheckResult.available((String)channel.getBuild().getMessage(), (String)channel.getBuild().getDate(), (String)channel.getUrl()) : UpdateCheckResult.nothingFoundToUpdate();
                }
                catch (Exception e) {
                    result = UpdateCheckResult.fail((Exception)e);
                }
                UpdateCheckerImpl.this.setRecentResult(result);
            }
        }, this.getJobName(), new Entity[0]);
    }

    private Map<String, String> createParams() {
        IMapSequence params = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        this.addParameter((Map<String, String>)params, "u", CharismaLicenseChecker.getUserCount(), Integer.MAX_VALUE);
        this.addParameter((Map<String, String>)params, "i", CharismaLicenseChecker.getIssueCount(), Long.MAX_VALUE);
        this.addParameter((Map<String, String>)params, "exp", CharismaLicenseChecker.getLicenseExpirationTime(), Long.MAX_VALUE);
        this.addParameter((Map<String, String>)params, "upd", CharismaLicenseChecker.getLicenseFreeUpdateEnd(), Long.MAX_VALUE);
        MapSequence.fromMap((Map)params).put((Object)"os", (Object)System.getProperty("os.name", "UNKNOWN"));
        MapSequence.fromMap((Map)params).put((Object)"inst", (Object)System.getProperty("jetbrains.youtrack.installation-type", "UNKNOWN"));
        MapSequence.fromMap((Map)params).put((Object)"v", (Object)((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion());
        MapSequence.fromMap((Map)params).put((Object)"b", (Object)this.applicationBuild);
        MapSequence.fromMap((Map)params).put((Object)"lang", (Object)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale().toString());
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0((Map)params){
            final /* synthetic */ Map val$params;
            {
                this.val$params = map;
            }

            public void invoke() {
                MapSequence.fromMap((Map)this.val$params).put((Object)"uuid", PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"uuid", String.class, null));
            }
        });
        return params;
    }

    private void addParameter(Map<String, String> params, String key, long value, long undefinedValue) {
        if (value != undefinedValue) {
            MapSequence.fromMap(params).put((Object)key, (Object)String.valueOf(value));
        }
    }

    public boolean isChecking() {
        return this.jobContainer.hasGlobalJob(this.getJobName());
    }

    public void setJobContainer(UserActionJobContainer jobContainer) {
        this.jobContainer = jobContainer;
    }

    public UpdateCheckResult getRecentResult() {
        Lock r = this.resultLock.readLock();
        r.lock();
        try {
            UpdateCheckResult updateCheckResult = this.recentResult;
            return updateCheckResult;
        }
        finally {
            r.unlock();
        }
    }

    public void setRecentResult(UpdateCheckResult recentResult) {
        Lock w = this.resultLock.writeLock();
        w.lock();
        try {
            this.recentResult = recentResult;
        }
        finally {
            w.unlock();
        }
        this.fire(recentResult);
    }

    public void addListener(_FunctionTypes._void_P1_E0<? super UpdateCheckResult> listener) {
        Lock w = this.resultLock.writeLock();
        w.lock();
        try {
            ListSequence.fromList(this.listeners).addElement(listener);
        }
        finally {
            w.unlock();
        }
    }

    public void removeListener(_FunctionTypes._void_P1_E0<? super UpdateCheckResult> listener) {
        Lock w = this.resultLock.writeLock();
        w.lock();
        try {
            ListSequence.fromList(this.listeners).removeElement(listener);
        }
        finally {
            w.unlock();
        }
    }

    protected void fire(final UpdateCheckResult result) {
        Lock r = this.resultLock.readLock();
        r.lock();
        try {
            ListSequence.fromList(this.listeners).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<_FunctionTypes._void_P1_E0<? super UpdateCheckResult>>(){

                public void visit(_FunctionTypes._void_P1_E0<? super UpdateCheckResult> it) {
                    it.invoke((Object)result);
                }
            });
        }
        finally {
            r.unlock();
        }
    }

    public String getProductCode() {
        return this.myProductCode;
    }

    public void setProductCode(String value) {
        this.myProductCode = value;
    }

    public String getJobName() {
        return this.myJobName;
    }

    public void setJobName(String value) {
        this.myJobName = value;
    }

    public UpdateRest getUpdateRest() {
        return this.myUpdateRest;
    }

    public void setUpdateRest(UpdateRest value) {
        this.myUpdateRest = value;
    }
}

