var Control = {};
Control = function (bodyId) {
  var t = this;
  t.body = $("#" + bodyId);
  t.controls = [];
  t.tables = [];
  t.indices = [];
  t.body.children("tr").each(function () {
    t.addRow(this);
  });
  if (true == false) {
    window.alert("Controls: " + t.controls.length + ", tables: " + t.tables.length);
    window.alert("Indices[DatePeriod]: " + t.indices["DatePeriod"]);
  }

};
Control.prototype.selectCurrentControl = function () {
  var currentControl = $(this.controls[this.currentIndex]);
  currentControl.scrollTo();
  currentControl.focus();
};
Control.prototype.navigateTo = function (entityType, linkId) {
  var i = this.checkEntityType(entityType);
  this.currentIndex = i;
  this.selectCurrentControl();
  this.setAnchor(linkId);
};
Control.prototype.tableLoaded = function (entityType) {
  var table = this.getTable(entityType);
  return $(table).children("td").length > 0;
};
Control.prototype.tableDisplayed = function (entityType) {
  var table = this.getTable(entityType);
  return !($(table).hasClass("hidden"));
};
Control.prototype.toggle = function (entityType, linkId) {
  var control = $(this.getControl(entityType));
  control.children("td:first").children("a:first").click();
  var it = this;
  window.setTimeout(function () {
    it.setAnchor(linkId);
  }, 100);
};
Control.prototype.setAnchor = function (anchor) {
  if (anchor) {
    window.location.hash = anchor;
  }

};
Control.prototype.addRow = function (selector) {
  var r = $(selector);
  if (!r) {
    throw "Can't find tr for selector [" + selector + "]";
  } else {
    var row = r.get(0);
    var id = row.id;
    var firstLetter = id.charAt(0);
    if (firstLetter == "c") {
      this.controls.push(row);
      //parse index from id
      this.indices[this.parseEntityType(id)] = this.controls.length - 1;
    } else {
      if (firstLetter == "e") {
        this.tables.push(row);
      } else {
        throw "Unexpected row id [" + id + "]";
      }

    }

  }

};
Control.prototype.parseEntityType = function (id) {
  var indexOfUnderscore = id.indexOf("_");
  if (indexOfUnderscore < 0) {
    throw "No underscore in row id [" + id + "]";
  }

  return id.substring(indexOfUnderscore + 1);
};
Control.prototype.checkEntityType = function (entityType) {
  var i = this.indices[entityType];
  if ((i != 0) && (!i)) {
    throw "Unknown entity type: " + entityType;
  } else {
    return i;
  }

};
Control.prototype.getControl = function (entityType) {
  var control = this.controls[this.checkEntityType(entityType)];
  if (!control) {
    throw "Control not found for entity type: " + entityType;
  } else {
    return control;
  }

};
Control.prototype.getTable = function (entityType) {
  var table = this.tables[this.checkEntityType(entityType)];
  if (!table) {
    throw "Table not found for entity type: " + entityType;
  } else {
    return table;
  }

};
Control.prototype.updateRow = function (id) {
  var i = this.checkEntityType(this.parseEntityType(id));
  var firstLetter = id.charAt(0);
  var query = "#" + id;
  var item = $(query);
  if (!item) {
    throw "Can't find tr for selector [" + id + "]";
  }

  var row = item.get(0);
  if (firstLetter == "c") {
    this.controls[i] = row;
  } else {
    if (firstLetter = "e") {
      this.tables[i] = row;
    } else {
      throw "Unexpected row id [" + id + "]";
    }

  }

};
