/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.issue;

import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.IssueAttachmentImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueComment;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001c\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000e"}, d2={"canCreateAttachment", "", "Ljetbrains/youtrack/persistent/XdIssue;", "authorLogin", "", "created", "", "(Ljetbrains/youtrack/persistent/XdIssue;Ljava/lang/String;Ljava/lang/Long;)V", "checkAccess", "operation", "Ljetbrains/youtrack/core/security/Operation;", "attachment", "Ljetbrains/youtrack/persistent/XdIssueAttachment;", "Ljetbrains/youtrack/persistent/XdIssueComment;", "youtrack-old-rest"})
public final class AccessRestUtilKt {
    public static final void checkAccess(@NotNull XdIssue $receiver, @NotNull Operation operation) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        if (!XdIssue.isAccessible$default((XdIssue)$receiver, (Operation)operation, null, (int)2, null)) {
            String string = operation.name();
            StringBuilder stringBuilder = new StringBuilder().append("You have no access to ");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            String string5 = stringBuilder.append(string4).append(" issue.").toString();
            throw (Throwable)new ForbiddenException(string5);
        }
    }

    public static final void checkAccess(@NotNull XdIssue $receiver, @NotNull XdIssueAttachment attachment, @NotNull Operation operation) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        if (!XdIssueAttachment.isAccessible$default((XdIssueAttachment)attachment, (Operation)operation, null, (int)2, null)) {
            String string = operation.name();
            StringBuilder stringBuilder = new StringBuilder().append("You don't have permissions to ");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            String string5 = stringBuilder.append(string4).append(" this attachment").toString();
            throw (Throwable)new ForbiddenException(string5);
        }
        if (Intrinsics.areEqual((Object)attachment.getIssue(), (Object)$receiver) ^ true) {
            throw (Throwable)new ForbiddenException("You can't access this attachment in context of wrong issue");
        }
    }

    public static final void canCreateAttachment(@NotNull XdIssue $receiver, @Nullable String authorLogin, @Nullable Long created) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!IssueAttachmentImpl.canCreateAttachment((Entity)$receiver.getEntity())) {
            throw (Throwable)new ForbiddenException("You have no access to attach files. " + Permission.CREATE_ATTACHMENT_ISSUE.getHumanizedName() + " permission is required");
        }
        if ((authorLogin != null && (charSequence = (CharSequence)authorLogin).length() > 0 || created != null) && !BeansKt.getXdLoggedInUser().hasPermission(Permission.ADMIN_UPDATE_APP)) {
            throw (Throwable)new ForbiddenException("You have no access to manual setup of attachment author or creation date. " + Permission.ADMIN_UPDATE_APP.getHumanizedName() + " is required.");
        }
    }

    public static final void checkAccess(@NotNull XdIssueComment $receiver, @NotNull Operation operation) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        if (!XdIssueComment.isAccessible$default((XdIssueComment)$receiver, (Operation)operation, null, (int)2, null)) {
            String string = operation.name();
            StringBuilder stringBuilder = new StringBuilder().append("You don't have permissions to ");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            String string5 = stringBuilder.append(string4).append(" this comment.").toString();
            throw (Throwable)new ForbiddenException(string5);
        }
    }
}

