/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.parser.lexer;

import jetbrains.youtrack.parser.lexer.LexerListener;
import jetbrains.youtrack.parser.lexer.StringUtils;

public class Lexer {
    public static final String SPACE = " ";
    public static final String EOL = "\n";
    private String input;
    public int current;
    public int wordStart;
    private LexerListener lexerListener;
    private boolean lineBreakAsSpace;
    private State state;

    public Lexer(String input, LexerListener lexerListener) {
        this.input = input;
        this.lexerListener = lexerListener;
        this.current = 0;
        this.PARSING_READING_SPACES_enter();
        this.state = State.READING_SPACES;
    }

    public void parse() {
        if (Lexer.isNotEmpty_ltp4m_a0a0a(this.input)) {
            while (this.current < this.input.length()) {
                char currentChar = this.input.charAt(this.current);
                if (currentChar == '\n') {
                    if (this.lineBreakAsSpace) {
                        this.space();
                    } else {
                        this.punctuation();
                    }
                } else if (currentChar <= ' ') {
                    this.space();
                } else if ('!' <= currentChar && currentChar <= ')') {
                    this.punctuation();
                } else if ('+' <= currentChar && currentChar <= '/') {
                    this.punctuation();
                } else if (':' <= currentChar && currentChar <= '>') {
                    this.punctuation();
                } else if ('@' <= currentChar && currentChar <= '@') {
                    this.punctuation();
                } else if ('[' <= currentChar && currentChar <= '`') {
                    this.punctuation();
                } else if ('{' <= currentChar && currentChar <= '~') {
                    this.punctuation();
                } else {
                    this.other();
                }
                ++this.current;
            }
        }
        this.eol();
    }

    public void parseIgnorePunctuation() {
        if (Lexer.isNotEmpty_ltp4m_a0a0b(this.input)) {
            while (this.current < this.input.length()) {
                char currentChar = this.input.charAt(this.current);
                if (currentChar == '\n') {
                    if (this.lineBreakAsSpace) {
                        this.space();
                    } else {
                        this.punctuation();
                    }
                } else if (currentChar <= ' ') {
                    this.space();
                } else {
                    this.other();
                }
                ++this.current;
            }
        }
        this.eol();
    }

    public void pushSpace(int start, int end) {
        this.lexerListener.space(start, end);
    }

    public void pushToken(int start, int end) {
        this.lexerListener.token(StringUtils.substring(this.input, start, end), start, end);
    }

    public void pushPunctuation(int start, int end) {
        this.lexerListener.punctuation(StringUtils.substring(this.input, start, end), start, end);
    }

    private void pushEOL() {
        this.lexerListener.eol(this.current);
    }

    public void setLineBreakAsSpace(boolean value) {
        this.lineBreakAsSpace = value;
    }

    public void punctuation() {
        switch (this.state) {
            case PARSING: {
                break;
            }
            case READING_SPACES: {
                this.PARSING_READING_SPACES_exit();
                this.state = State.READING_PUNCTUATIONS;
                this.PARSING_READING_PUNCTUATIONS_enter();
                break;
            }
            case READING_PUNCTUATIONS: {
                this.state = State.READING_PUNCTUATIONS;
                this.PARSING_READING_PUNCTUATIONS_enter();
                break;
            }
            case READING_WORD: {
                this.PARSING_READING_WORD_exit();
                this.state = State.READING_PUNCTUATIONS;
                this.PARSING_READING_PUNCTUATIONS_enter();
                break;
            }
        }
    }

    public void space() {
        switch (this.state) {
            case PARSING: {
                break;
            }
            case READING_SPACES: {
                break;
            }
            case READING_PUNCTUATIONS: {
                this.state = State.READING_SPACES;
                this.PARSING_READING_SPACES_enter();
                break;
            }
            case READING_WORD: {
                this.PARSING_READING_WORD_exit();
                this.state = State.READING_SPACES;
                this.PARSING_READING_SPACES_enter();
                break;
            }
        }
    }

    public void other() {
        switch (this.state) {
            case PARSING: {
                break;
            }
            case READING_SPACES: {
                this.PARSING_READING_SPACES_exit();
                this.state = State.READING_WORD;
                this.PARSING_READING_WORD_enter();
                break;
            }
            case READING_PUNCTUATIONS: {
                this.state = State.READING_WORD;
                this.PARSING_READING_WORD_enter();
                break;
            }
            case READING_WORD: {
                break;
            }
        }
    }

    public void eol() {
        switch (this.state) {
            case PARSING: {
                this.pushEOL();
                this.state = State.FINISHED;
                break;
            }
            case READING_SPACES: {
                this.PARSING_READING_SPACES_exit();
                this.pushEOL();
                this.state = State.FINISHED;
                break;
            }
            case READING_PUNCTUATIONS: {
                this.pushEOL();
                this.state = State.FINISHED;
                break;
            }
            case READING_WORD: {
                this.PARSING_READING_WORD_exit();
                this.pushEOL();
                this.state = State.FINISHED;
                break;
            }
        }
    }

    public boolean isInState(State state) {
        if (this.state == state) {
            return true;
        }
        switch (state) {
            case PARSING: {
                switch (this.state) {
                    case READING_SPACES: {
                        return true;
                    }
                    case READING_PUNCTUATIONS: {
                        return true;
                    }
                    case READING_WORD: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public State _state() {
        return this.state;
    }

    private void PARSING_READING_SPACES_enter() {
        this.wordStart = this.current;
    }

    private void PARSING_READING_SPACES_exit() {
        if (this.current != this.wordStart) {
            this.pushSpace(this.wordStart, this.current);
        }
    }

    private void PARSING_READING_PUNCTUATIONS_enter() {
        this.pushPunctuation(this.current, this.current + 1);
    }

    private void PARSING_READING_WORD_enter() {
        this.wordStart = this.current;
    }

    private void PARSING_READING_WORD_exit() {
        this.pushToken(this.wordStart, this.current);
    }

    public static boolean isNotEmpty_ltp4m_a0a0a(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_ltp4m_a0a0b(String str) {
        return str != null && str.length() > 0;
    }

    public static enum State {
        PARSING,
        READING_SPACES,
        READING_PUNCTUATIONS,
        READING_WORD,
        FINISHED;

    }
}

