/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.parser.lexer;

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.youtrack.parser.lexer.CharIterable;
import jetbrains.youtrack.parser.lexer.CharIterator;
import jetbrains.youtrack.parser.lexer.StringUtils;
import jetbrains.youtrack.parser.lexer.Word;

public class WordsIterable
implements CharIterable {
    private final List<Word> words;
    private final int startToken;
    private final int stopToken;
    private final int offsetInStopToken;
    private final int offsetInStartToken;

    public WordsIterable(List<Word> words, int startToken, int stopToken) {
        this(words, startToken, stopToken, -1);
    }

    public WordsIterable(List<Word> words, int startToken, int stopToken, int offsetInStopToken) {
        this(words, startToken, -1, stopToken, offsetInStopToken);
    }

    public WordsIterable(List<Word> words, int startToken, int offsetInStartToken, int stopToken, int offsetInStopToken) {
        this.words = words;
        this.startToken = Math.max(0, startToken);
        this.stopToken = Math.min(ListSequence.fromList(words).count() - 1, stopToken);
        if (ListSequence.fromList(words).isNotEmpty()) {
            this.offsetInStartToken = offsetInStartToken >= 0 && offsetInStartToken <= ((Word)ListSequence.fromList(words).getElement(startToken)).getWord().length() ? offsetInStartToken : 0;
            this.offsetInStopToken = offsetInStopToken >= 0 && offsetInStopToken <= ((Word)ListSequence.fromList(words).getElement(stopToken)).getWord().length() ? offsetInStopToken : ((Word)ListSequence.fromList(words).getElement(stopToken)).getWord().length();
        } else {
            this.offsetInStartToken = 0;
            this.offsetInStopToken = 0;
        }
    }

    @Override
    public CharIterator iterator() {
        return new Iterator();
    }

    @Override
    public CharIterator reverseIterator() {
        return new ReverseIterator();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int token = this.startToken; token <= this.stopToken; ++token) {
            String word = ((Word)ListSequence.fromList(this.words).getElement(token)).getWord();
            if (token == this.startToken) {
                word = StringUtils.substring(word, this.offsetInStartToken);
            }
            if (token == this.stopToken) {
                word = StringUtils.substring(word, 0, this.offsetInStopToken);
            }
            builder.append(word);
        }
        return builder.toString();
    }

    private class ReverseIterator
    implements CharIterator {
        private int token;
        private int nextOffset;

        public ReverseIterator() {
            this.token = WordsIterable.this.stopToken;
            this.nextOffset = WordsIterable.this.offsetInStopToken - 1;
            this.normalize();
        }

        @Override
        public char next() {
            char c = ((Word)ListSequence.fromList((List)WordsIterable.this.words).getElement(this.token)).getWord().charAt(this.nextOffset);
            --this.nextOffset;
            this.normalize();
            return c;
        }

        @Override
        public boolean hasNext() {
            return this.token > WordsIterable.this.startToken || this.token == WordsIterable.this.startToken && this.nextOffset >= WordsIterable.this.offsetInStartToken;
        }

        private void normalize() {
            List w = WordsIterable.this.words;
            while (this.token >= WordsIterable.this.startToken && this.nextOffset < 0) {
                --this.token;
                if (this.token < WordsIterable.this.startToken) continue;
                this.nextOffset = ((Word)ListSequence.fromList((List)w).getElement(this.token)).getWord().length() - 1;
            }
        }
    }

    private class Iterator
    implements CharIterator {
        private int token;
        private int nextOffset;

        public Iterator() {
            this.token = WordsIterable.this.startToken;
            this.nextOffset = WordsIterable.this.offsetInStartToken;
            this.normalize();
        }

        @Override
        public char next() {
            char c = ((Word)ListSequence.fromList((List)WordsIterable.this.words).getElement(this.token)).getWord().charAt(this.nextOffset);
            ++this.nextOffset;
            this.normalize();
            return c;
        }

        @Override
        public boolean hasNext() {
            return this.token < WordsIterable.this.stopToken || this.token == WordsIterable.this.stopToken && this.nextOffset < WordsIterable.this.offsetInStopToken;
        }

        private void normalize() {
            List w = WordsIterable.this.words;
            while (this.token <= WordsIterable.this.stopToken && this.nextOffset >= ((Word)ListSequence.fromList((List)w).getElement(this.token)).getWord().length()) {
                this.nextOffset = 0;
                ++this.token;
            }
        }
    }
}

