/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.parser.prefixTree;

import java.util.Collections;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.youtrack.parser.lexer.CharIterable;
import jetbrains.youtrack.parser.lexer.CharIterator;
import jetbrains.youtrack.parser.prefixTree.IPredicate;
import jetbrains.youtrack.parser.prefixTree.PrefixIterable;
import jetbrains.youtrack.parser.prefixTree.PrefixIterator;

public abstract class IntegerPrefixIterable<T>
implements PrefixIterable<T> {
    @Override
    public int getNodesCount() {
        return 0;
    }

    @Override
    public PrefixIterator<T> prefixIterator() {
        return new IntegerPrefixIterator();
    }

    public T getValue(int number) {
        throw new UnsupportedOperationException("getValue() or getValues() should be overriden");
    }

    public Iterable<T> getValues(int number) {
        return Sequence.singleton(this.getValue(number));
    }

    public Iterable<T> getDescendantValues(int number) {
        return Sequence.fromIterable(Collections.emptyList());
    }

    public boolean matches(IPredicate<T> predicate) {
        return true;
    }

    private class IntegerPrefixIterator
    implements PrefixIterator<T> {
        private int number = 0;
        private boolean finished = false;

        private IntegerPrefixIterator() {
        }

        @Override
        public boolean move(CharIterable step) {
            if (this.finished) {
                return false;
            }
            CharIterator i = step.iterator();
            while (i.hasNext()) {
                char c = i.next();
                if ('0' <= c && c <= '9') {
                    this.number = this.number * 10 + (c - 48);
                    continue;
                }
                this.finished = true;
                return false;
            }
            return true;
        }

        @Override
        public Iterable<T> getValues(final IPredicate<T> predicate) {
            if (!this.finished && IntegerPrefixIterable.this.matches(predicate)) {
                ISequence values = IntegerPrefixIterable.this.getValues(this.number);
                return predicate == null ? values : Sequence.fromIterable(values).where((_FunctionTypes._return_P1_E0)new IWhereFilter<T>(){

                    public boolean accept(T it) {
                        return predicate.matches(it);
                    }
                });
            }
            return Sequence.fromIterable(Collections.emptyList());
        }

        @Override
        public Iterable<T> getDescendantValues(final IPredicate<T> predicate) {
            if (!this.finished && IntegerPrefixIterable.this.matches(predicate)) {
                ISequence values = IntegerPrefixIterable.this.getDescendantValues(this.number);
                return predicate == null ? values : Sequence.fromIterable(values).where((_FunctionTypes._return_P1_E0)new IWhereFilter<T>(){

                    public boolean accept(T it) {
                        return predicate.matches(it);
                    }
                });
            }
            return Sequence.fromIterable(Collections.emptyList());
        }
    }
}

