/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.parser.prefixTree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.youtrack.parser.prefixTree.IPredicate;

public class Node<T> {
    private final int nodeNumber;
    private List<T> values;

    public Node(int nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public Iterable<T> getValues() {
        return this.values;
    }

    public void addValue(T value) {
        if (this.values == null) {
            this.values = new ArrayList<T>(2);
        }
        this.values.add(value);
    }

    public boolean hasValues() {
        return this.values != null && this.values.size() > 0;
    }

    public Iterable<T> removeValues(IPredicate<T> predicate) {
        List<T> removedValues;
        if (predicate == null) {
            removedValues = this.values;
            this.values = new ArrayList<T>(2);
        } else {
            removedValues = new ArrayList<T>();
            if (this.values != null) {
                Iterator<T> i = this.values.iterator();
                while (i.hasNext()) {
                    T value = i.next();
                    if (!predicate.matches(value)) continue;
                    removedValues.add(value);
                    i.remove();
                }
            }
        }
        return removedValues;
    }

    public void appendToString(StringBuilder builder) {
        builder.append('[');
        boolean first = true;
        for (Object value : Sequence.fromIterable(this.getValues())) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(value);
        }
        builder.append(']');
    }
}

